<?php namespace Elementor;

class calfin_accordion_Widget extends Widget_Base {

    public function get_name() {
        return 'calfin_accordion';
    }
    public function get_title() {
        return esc_html__( 'Calfin Accordion', 'calfincore' );
    }
    public function get_icon() {
        return 'eicon-accordion';
    }
    public function get_categories() {
        return ['calfin'];
    }
    protected function register_controls() {
        //Content tab start
        $this->start_controls_section(
            'calfin_faq_options',
            [
                'label' => esc_html__( 'Calfin FAQ', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'calfin_faq_active',
            [
                'label'        => esc_html__( 'Active FAQ', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $repeater->add_control(
            'calfin_faq_title', [
                'label'       => esc_html__( 'Title', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'How much time do I need to volunteer?', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'more_options',
            [

                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'calfin_faq_content', [
                'label'      => esc_html__( 'Content', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::WYSIWYG,
                'default'    => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and industry. been the industry,s standard dummy text ever since the printer took galley scrambled it to make a type specimen book.', 'calfincore' ),
                'show_label' => false,
            ]
        );
        $this->add_control(
            'calfin_faqs',
            [
                'label'          => esc_html__( 'FAQ List', 'calfincore' ),
                'type'           => \Elementor\Controls_Manager::REPEATER,
                'fields'         => $repeater->get_controls(),
                'default'        => [
                    [
                        'calfin_faq_active'  => 'yes',
                        'calfin_faq_title'   => esc_html__( 'How much time do I need to volunteer?', 'calfincore' ),
                        'calfin_faq_content' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and industry. been the industry,s standard dummy text ever since the printer took galley scrambled it to make a type specimen book.', 'calfincore' ),
                    ],
                    [
                        'calfin_faq_active'  => 'no',
                        'calfin_faq_title'   => esc_html__( 'How much time do I need to volunteer?', 'calfincore' ),
                        'calfin_faq_content' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and industry. been the industry,s standard dummy text ever since the printer took galley scrambled it to make a type specimen book.' ),
                    ],
                    [
                        'calfin_faq_active'  => 'no',
                        'calfin_faq_title'   => esc_html__( 'How much time do I need to volunteer?', 'calfincore' ),
                        'calfin_faq_content' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and industry. been the industry,s standard dummy text ever since the printer took galley scrambled it to make a type specimen book.' ),
                    ],
                ],
                'calfin_faq_title' => '{{{ list_title }}}',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_faq_css',
            [
                'label' => esc_html__( 'Box CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_box_align',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion-item'   => 'text-align: {{VALUE}}',
                    '{{WRAPPER}} .faq-accordion .accordion-button' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_box_bg',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'calfin_faq_css_box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion-item',
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_box_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-item' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_faq_css_box_shoadow',
                'label'    => esc_html__( 'Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion-item',
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // =======================================
        // ========== CONTENT STYLE CSS ==========
        // =======================================
        $this->start_controls_section(
            'calfin_faq_css_title',
            [
                'label' => esc_html__( 'Content Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'calfin_content_tabs'
        );

        $this->start_controls_tab(
            'style_title_tab',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_faq_css_title_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion-button',
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_title_color',
            [
                'label'     => esc_html__( 'Title Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion-button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_title_bg',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'calfin_faq_css_title_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion-button',
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_title_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-button' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_faq_css_title_shoadow',
                'label'    => esc_html__( 'Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion-button',
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_title_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_title_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        // ===================================================
        $this->start_controls_tab(
            'style_description_tab',
            [
                'label' => esc_html__( 'Description', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_faq_css_dec_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .faq-accordion .accordion-body',
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_dec_color',
            [
                'label'     => esc_html__( 'Title Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion-body' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_dec_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_dec_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        // ==================================================
        $this->start_controls_tab(
            'style_icon_tab',
            [
                'label' => esc_html__( 'Icon', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-accordion .accordion-button::after' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_icon_size',
            [
                'label'      => esc_html__( 'Icon size', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'calfin_faq_css_icon_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-button::after' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_faq_css_icon_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .faq-accordion .accordion-button::after' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        $_id = rand( 1241, 3256 );
        ob_start();
        ?>
        <div class="calfin-accordion-wraper">
            <div class="accordion faq-accordion" id="calfin-faq">
            <?php $count = 0;foreach ( $settings['calfin_faqs'] as $item ): $count++;
                 if($item['calfin_faq_active'] == 'yes' ){
                    $active = 'collapse';
                    $show = 'show';
                }else{
                    $active = 'collapsed';
                    $show = '';
                }
            ?>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="faq<?php echo esc_attr($count)?>">
                        <button class="accordion-button <?php echo esc_attr($active); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#calfin-faq-item-<?php echo esc_attr($_id . $count)?>" aria-expanded="false" aria-controls="calfin-faq-item-<?php echo esc_attr($_id . $count)?>">
                            <?php echo esc_html($item['calfin_faq_title']); ?>
                        </button>
                    </h2>
                    <div id="calfin-faq-item-<?php echo esc_attr($_id . $count)?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>"" aria-labelledby="faq<?php echo esc_attr($count)?>" data-bs-parent="#calfin-faq">
                    <div class="accordion-body"><?php echo wp_kses_post($item['calfin_faq_content']); ?></div>
                    </div>
                </div>
                <?php endforeach;?>
            </div>
        </div>
        <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_accordion_Widget );
