<?php namespace Elementor;

class blog_two_Widget extends Widget_Base {

    public function get_name() {

        return 'blog_two_widget';
    }

    public function get_title() {
        return esc_html__( 'Blog Two', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {
        $options = array();
        $args = array(
            'hide_empty' => false,
        );
        $categories = get_categories( $args );
        foreach ( $categories as $key => $category ) {
            $options[$category->term_id] = $category->name;
        }

        //Content tab start
        $this->start_controls_section(
			'blog_content_tab',
			[
				'label' => esc_html__( 'Blog Option', 'calfincore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'enable_container',
			[
				'label' => esc_html__( 'Enable Container', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
            'item_show',
            [
                'label'   => esc_html__( 'Disply Items', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => 3,
            ]
        );
        $this->add_control(
            'title_lanth',
            [
                'label'   => esc_html__( 'Title Lanth ', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 4,
                'max'     => 12,
                'step'    => 1,
                'default' => 5,
            ]
        );
        $this->add_control(
            'dec_lanth',
            [
                'label'   => esc_html__( 'Content Lanth ', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'min'     => 5,
                'max'     => 40,
                'step'    => 1,
                'default' => 15,
            ]
        );
        $this->add_control(
            'enable_cat',
            [
                'label'        => esc_html__( 'Post By Category', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $this->add_control(
            'post_cat',
            [
                'label'     => __( 'Select Categoris', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::SELECT2,
                'multiple'  => true,
                'options'   => $options,
                'condition' => [
                    'enable_cat' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__( 'Order by', 'calfincore' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'          => esc_html__( 'None', 'calfincore' ),
                    'ID'            => esc_html__( 'ID', 'calfincore' ),
                    'date'          => esc_html__( 'Date', 'calfincore' ),
                    'name'          => esc_html__( 'Name', 'calfincore' ),
                    'title'         => esc_html__( 'Title', 'calfincore' ),
                    'comment_count' => esc_html__( 'Comment count', 'calfincore' ),
                    'rand'          => esc_html__( 'Random', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'order_item',
            [
                'label'   => esc_html__( 'Order', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'ASC'  => esc_html__( 'ASC', 'calfincore' ),
                    'DESE' => esc_html__( 'DESE', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'desktop_col',
            [
                'label' => esc_html__( 'Columns On Desktop', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-xl-4',
                'options' => [
                    'col-xl-12'  => esc_html__( '1 Column', 'calfincore' ),
                    'col-xl-6'  => esc_html__( '2 Column', 'calfincore' ),
                    'col-xl-4'  => esc_html__( '3 Column', 'calfincore' ),
                    'col-xl-3'  => esc_html__( '4 Column', 'calfincore' ),
                ],
            
            ]
        );
        $this->add_control(
            'ipadpro_col',
            [
                'label' => esc_html__( 'Columns On Ipad Pro', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-lg-6',
                'options' => [
                    'col-lg-12'  => esc_html__( '1 Column', 'calfincore' ),
                    'col-lg-6'  => esc_html__( '2 Column', 'calfincore' ),
                    'col-lg-4'  => esc_html__( '3 Column', 'calfincore' ),
                    'col-lg-3'  => esc_html__( '4 Column', 'calfincore' ),
                ],
            ]
            
        );
        $this->add_control(
            'tab_col',
            [
                'label' => esc_html__( 'Columns On Tablet', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-md-12',
                'options' => [
                    'col-md-12'  => esc_html__( '1 Column', 'calfincore' ),
                    'col-md-6'  => esc_html__( '2 Column', 'calfincore' ),
                    'col-md-4'  => esc_html__( '3 Column', 'calfincore' ),
                    'col-md-3'  => esc_html__( '4 Column', 'calfincore' ),
                ],
             
            ]
        );
        $this->end_controls_section();

        
     //===========================================//
        //========= BLOG BOX STYLE START ========//
        //=========================================//

        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Box Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'section_tabs'
        );
        $this->start_controls_tab(
            'section_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'calfincore' ),
            ]
        );  
        $this->add_responsive_control(
			'box_align',
			[
				'label' => esc_html__( 'Alignment', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'calfincore' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .blog-two-content' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->add_responsive_control(
            'box_width',
            [
                'label'      => esc_html__( 'Box Width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .blog-two-content',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .blog-two-content',
            ]
        );
        $this->add_responsive_control(
            'team_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .blog-two-content',
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds_hover',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .blog-two-content:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow_hover',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .blog-two-content:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border_hover',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .blog-two-content:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_hover',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        // ===============================================
        // =========== IMAGE STYLE CSS ===================
        // ===============================================

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__( 'Image Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' =>1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content-wrp img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content-wrp img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'object',
            [
                'label' => esc_html__( 'Object Fit', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__( 'Fill', 'calfincore' ),
                    'contain' => esc_html__( 'Contain', 'calfincore' ),
                    'cover' => esc_html__( 'Cover', 'calfincore' ),
                    'none' => esc_html__( 'None', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-two-content-wrp img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-image-wrapper .calfin-image img',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content-wrp img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content-wrp' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-content-wrp' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ===================================================
        //=============== META STYLE CSS ======================
        //=====================================================
        
        $this->start_controls_section(
            'meta_box_date_style',
            [
                'label' => esc_html__( 'Meta Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'matabox_tabs'
        );
        $this->start_controls_tab(
            'meta_tab',
            [
                'label' => esc_html__( 'Meta Content', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'meta_typ',
                'selector' => '{{WRAPPER}} .blog-two-meta ul li',
            ]
        );
        $this->add_responsive_control(
            'meta_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-two-meta ul li' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .blog-two-meta .item-date .posted-on a' => 'color: {{VALUE}}',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'meta_color_h',
            [
                'label'     => esc_html__( 'Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-two-content:hover .blog-two-meta ul li' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .blog-two-content:hover .item-date .posted-on a' => 'color: {{VALUE}}',
                    
                ],
            ]
        );
        $this->add_responsive_control(
            'meta_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-meta ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'meta_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-meta ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'meta_icon_tab',
            [
                'label' => esc_html__( 'Meta Icon', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'meta_icon_typ',
                'selector' => '{{WRAPPER}} .blog-two-meta ul li i',
            ]
        );
        $this->add_responsive_control(
            'meta_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-two-meta ul li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'meta_icon_color_h',
            [
                'label'     => esc_html__( 'Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-two-content:hover .blog-two-meta ul li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'meta_icon_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-meta ul li i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'meta_icon_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .blog-two-meta ul li i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Title Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'blog_title_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .blog-title',
            ]
        );
        $this->add_responsive_control(
            'blog_title_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-title a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_title_color_h',
            [
                'label' => esc_html__( 'Hover Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-title a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_content_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'blog_content_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        $col =  'col-12 col-sm-12 '.$settings['desktop_col'] . ' ' . $settings['ipadpro_col'] . ' ' . $settings['tab_col'].'';
        global $post;
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        if($settings['enable_cat'] == 'yes' && !empty($settings['post_cat'])){
            $p = new \WP_Query( array( 
                'posts_per_page' => esc_attr($settings['item_show'] ),
                'post_type' => 'post',
                'paged' => $paged,
                'orderby' => esc_attr($settings['orderby']), 
                'order' => esc_attr($settings['order_item']), 
                'tax_query' => array(
                    array(
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $settings['post_cat'],
                    )
                ),
            ));
        }else{
            $p = new \WP_Query( array( 
                'posts_per_page' => esc_attr($settings['item_show'] ),
                'post_type' => 'post',
                'paged' => $paged,
                'orderby' => esc_attr($settings['orderby']), 
                'order' => esc_attr($settings['order_item']), 
            ));
        }
        if ( $settings['enable_container'] == 'yes' ) {
            $container = 'container';
        } else {
            $container = 'container-fluid';
        }
        ob_start();
        ?>
           <div class="testimonial-wrapper">
            <div class="<?php echo esc_attr( $container ); ?>">               
                <div class="row">
                    <?php while ( $p->have_posts() ): $p->the_post(); ?>
                        <div class="<?php echo esc_attr($col); ?>">
                            <div class="blog-two-item">
                                <div class="blog-two-content-wrp">
                                    <?php the_post_thumbnail('full', array('class' => 'img-responsive')); ?>
                                    <div class="blog-two-content">
                                        <div class="blog-two-meta">
                                            <ul class="post-grid-meta">
                                                <li class="blog-author"><i class="icon far fa-user"></i> <?php the_author(); ?></li>	
                                                <li class="item-date"><i class="far fa-calendar-alt"></i> <?php calfin_posted_on(); ?></li>
                                            </ul>
                                        </div>
                                        <div class="text">
                                            <h5 class="blog-title">
                                                <a href="<?php echo the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), esc_html($settings['title_lanth']) ); ?></a>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;?>
                </div>
               
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new blog_two_Widget );

