<?php namespace Elementor;

class calfin_company_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_company_info';
    }

    public function get_title() {
        return esc_html__( 'calfin Company Info', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-identity';
    }

    public function get_categories() {
        return ['calfinhf'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_company_info_options',
            [
                'label' => esc_html__( 'calfin Company Info', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_company_info_align',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'calfin_company_logo_enalbe',
            [
                'label'        => esc_html__( 'Enable Logo', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $this->add_control(
            'calfin_company_logo',
            [
                'label'     => __( 'Choose Image', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'calfin_company_logo_enalbe' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_company_dec',
            [
                'label'      => esc_html__( 'Description', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::TEXTAREA,
                'default'    => esc_html__( 'Lorem ipsum dolor sit amet elit consectetur adipisicing sed do eiusmod tempor incididunt et dolore elit labore', 'calfincore' ),
                'show_label' => true,
            ]
        );
        $this->add_control(
            'calfin_company_info_show',
            [
                'label'        => esc_html__( 'Enable Info List', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'calfin_company_info_icon',
            [
                'label' => esc_html__( 'Icon', 'calfincore' ),
                'type'  => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $repeater->add_control(
            'calfin_company_info_text',
            [
                'label'      => esc_html__( 'Textarea', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::TEXTAREA,
                'default'    => esc_html__( '1791 Yorkshire Circle Kitty Hawk, NC 27949', 'calfincore' ),
                'show_label' => true,
            ]
        );
        $this->add_control(
            'calfin_company_infos',
            [
                'label'     => esc_html__( 'Slider List', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::REPEATER,
                'fields'    => $repeater->get_controls(),
                'default'   => [
                    [
                        'calfin_company_info_icon' => '',
                        'calfin_company_info_text' => '',
                    ],
                ],
                'condition' => [
                    'calfin_company_info_show' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_company_info_CSS_options',
            [
                'label' => esc_html__( 'Box Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_company_info_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_company_info_box_padding',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_company_content_CSS_options',
            [
                'label' => esc_html__( 'Content Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'calfin_ompany_content_CSS_tabs'
        );
        $this->start_controls_tab(
            'calfin_ompany_content_CSS_tabs_logo',
            [
                'label' => __( 'Logo', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_company_info_logo_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_company_info_logo_padding',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'calfin_ompany_content_CSS_tabs_dec',
            [
                'label' => __( 'Content', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_tabs_dec_c',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_ompany_content_CSS_tabs_dec_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .company-info-widget p',
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_tabs_dec_m',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_tabs_dec_p',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'calfin_ompany_content_CSS_tabs_list',
            [
                'label' => __( 'List', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_tabs_list_c',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_ompany_content_CSS_tabs_list_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .company-info-widget ul li',
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_tabs_list_m',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_tabs_list_p',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'calfin_ompany_content_CSS_tabs_note',
            [
                'label'     => __( 'Icon CSS', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_icon_bgcolor',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_icon_size',
            [
                'label'      => esc_html__( 'Icon Size', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 60,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_icon_position',
            [
                'label'      => esc_html__( 'Icon Position', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -200,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_ompany_content_CSS_icon_radius',
            [
                'label'      => esc_html__( 'Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        if ( $settings['calfin_company_info_align'] == 'right' ) {
            $right = 'fright';
        } else {
            $right = '';
        }
        ob_start();
        ?>
        <div class="calfin-company-info-wrapper">
            <div class="company-info-widget">
                <?php if($settings['calfin_company_logo_enalbe'] == 'yes' ) {
                    echo wp_get_attachment_image( $settings['calfin_company_logo']['id'], 'full' );
                } ?>
                <p><?php echo esc_html($settings['calfin_company_dec']); ?></p>
                <?php if(!empty($settings['calfin_company_infos'])) : ?>
                <div class="company-contact-widget">
                    <ul>
                        <?php foreach( $settings['calfin_company_infos'] as $info ) : ?>
                        <li>
                            <i class="<?php echo esc_attr($right); ?> <?php echo esc_attr($info['calfin_company_info_icon']['value']); ?>"></i><?php echo esc_html($info['calfin_company_info_text']); ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_company_Widget );