<?php namespace Elementor;

class calfin_copyright_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_copyright';
    }

    public function get_title() {
        return esc_html__( 'calfin Copyright', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-cogs-check';
    }

    public function get_categories() {
        return ['calfinhf'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_copyright_options',
            [
                'label' => esc_html__( 'calfin Copyright', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_copyright_area',
            [
                'label'   => esc_html__( 'Copyright', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __( '© calfin 2021 | Developed by: <a href="#">Themepul</a> ', 'calfincore' ),
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_copyright_CSS',
            [
                'label' => esc_html__( 'calfin Copyright Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_copyright_CSS_c',
            [
                'label'     => esc_html__( 'Text Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-copyright-test' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_copyright_CSS_link_c',
            [
                'label'     => esc_html__( 'Link Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-copyright-test a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_copyright_CSS_link_ch',
            [
                'label'     => esc_html__( 'Link Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-copyright-test a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_copyright_CSS_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-copyright-test',
            ]
        );
        $this->add_responsive_control(
            'calfin_copyright_CSS_alig',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .calfin-copyright-test' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_copyright_CSS_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-copyright-test' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_copyright_CSS_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-copyright-test' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ob_start();
        ?>
        <div class="calfin-copyright-wrapper">
           <div class="calfin-copyright-test">
               <?php echo wp_kses($settings['calfin_copyright_area'],'calfin_allowed_html'); ?>
           </div>
        </div>
        <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_copyright_Widget );