<?php namespace Elementor;

class widget_name_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_img_exp';
    }

    public function get_title() {
        return esc_html__( 'calfin Image With experience', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_title_options',
            [
                'label' => esc_html__( 'Calfin Image With experience', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                
            ]
        );
        $this->add_control(
            'calfin_image_show_shape',
            [
                'label' => esc_html__( 'Enable Shape', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'image',
            [
                'label'   => esc_html__( ' Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'count_number',
            [
                'label'   => esc_html__( 'Count Number', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '20+', 'calfincore' ),
            ]
        );
        $this->add_control(
            'count_title',
            [
                'label'       => esc_html__( 'Count Title', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Years Of Experiences', 'calfincore' ),
                'label_block' => 'true',
            ]
        );

        $this->end_controls_section();


        // ===============================================
        // =========== IMAGE STYLE CSS ===================
        // ===============================================


        $this->start_controls_section(
            'calfin_image_CSS_shape1',
            [
                'label' => esc_html__( 'Shape 1', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_image_show_shape' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape1_bg',
            [
                'label' => esc_html__( 'Background Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-shape' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape1_width',
            [
                'label' => esc_html__( 'Width', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .image-shape' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape1_height',
            [
                'label' => esc_html__( 'Height', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-shape' => 'height: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape1_left',
            [
                'label' => esc_html__( 'Left', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-shape' => 'left: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape1_top',
            [
                'label' => esc_html__( 'Bottom', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-shape' => 'bottom: {{SIZE}}{{UNIT}};',
				],
                
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_image_CSS_shape2',
            [
                'label' => esc_html__( 'Shape 2', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_image_show_shape' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape2_bg',
            [
                'label' => esc_html__( 'Background Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image-shape2' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape2_width',
            [
                'label' => esc_html__( 'Width', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .image-shape2' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape2_height',
            [
                'label' => esc_html__( 'Height', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .image-shape2' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape2_left',
            [
                'label' => esc_html__( 'Left', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .image-shape2' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_image_CSS_shape2_top',
            [
                'label' => esc_html__( 'Top', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors' => [
                    '{{WRAPPER}} .image-shape2' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        // ===============================================
        // =========== IMAGE STYLE CSS ===================
        // ===============================================

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__( 'Image Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'image_align',
			[
				'label' => esc_html__( 'Alignment', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'calfincore' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .calfin-image-wrapper .calfin-image' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' =>1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-image-wrapper .calfin-image img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-image-wrapper .calfin-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'object',
            [
                'label' => esc_html__( 'Object Fit', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__( 'Fill', 'calfincore' ),
                    'contain' => esc_html__( 'Contain', 'calfincore' ),
                    'cover' => esc_html__( 'Cover', 'calfincore' ),
                    'none' => esc_html__( 'None', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-image-wrapper .calfin-image img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-image-wrapper .calfin-image img',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-image-wrapper .calfin-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-image-wrapper .calfin-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-image-wrapper .calfin-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


     //==================================================//
        // ============= COUNTER SECTION STYLE ==============//
        //===================================================//

        $this->start_controls_section(
            'counter_style',
            [
                'label' => esc_html__( 'Counter Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'content_tabs'
        );
        $this->start_controls_tab(
            'counter_box',
            [
                'label' => esc_html__( 'Counter Box', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'box_height',
            [
                'label'      => esc_html__( 'Box Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_width',
            [
                'label'      => esc_html__( 'Box Width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'counter_box_background',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .img-expariance-box',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'counter_box_shadow_hover',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .img-expariance-box',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'counter_box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .img-expariance-box',
            ]
        );
        $this->add_responsive_control(
            'counter_border_redius',
            [
                'label'      => esc_html__( 'Border Redius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'counter_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'counter_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'counter_number_tab',
            [
                'label' => esc_html__( 'Number', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'counter_number_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .img-expariance-box h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'counter_number_typography',
                'selector' => '{{WRAPPER}} .img-expariance-box h2',
            ]
        );
        $this->add_responsive_control(
            'counter_number_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'counter_number_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        //start titile style -------

        $this->start_controls_tab(
            'content_title_tab',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
            ]
        );

        $this->add_responsive_control(
            'counter_title_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .img-expariance-box span ' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'counter_title_typography',
                'selector' => '{{WRAPPER}} .img-expariance-box span',
            ]
        );
        $this->add_responsive_control(
            'counter_title_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'counter_title_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .img-expariance-box span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ob_start();
        ?>
         <div class="calfin-image-wrapper">
            <?php if($settings['calfin_image_show_shape'] == 'yes' ) : ?>
                <div class="image-shape2"></div>
                <div class="image-shape"></div>
            <?php endif; ?>
            <div class="calfin-image">
                <?php echo wp_get_attachment_image( $settings['image']['id'], 'full' );?>
                <div class="img-expariance-box">
                    <h2><?php echo esc_html($settings['count_number']); ?></h2>
                    <span><?php echo esc_html($settings['count_title']); ?></span>
                </div>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new widget_name_Widget );
