<?php namespace Elementor;

class calfin_nave_menu_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_nave_menu';
    }

    public function get_title() {
        return esc_html__( 'calfin Nav Menu', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-nav-menu';
    }

    public function get_categories() {
        return ['calfinhf'];
    }
    private function get_available_menus() {
        $menus = wp_get_nav_menus();

        $options = [];

        foreach ( $menus as $menu ) {
            $options[$menu->slug] = $menu->name;
        }

        return $options;
    }
    protected function register_controls() {

        $this->start_controls_section(
            'calfin_site_logo_options',
            [
                'label' => esc_html__( 'calfin Site Logo', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_nav_site_logo_enable',
            [
                'label'        => esc_html__( 'Show Logo', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'calfin_nav_site_logo_select',
            [
                'label'     => esc_html__( 'Select Options', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'one',
                'options'   => [
                    'one' => esc_html__( 'Site Logo', 'calfincore' ),
                    'two' => esc_html__( 'Custom Logo', 'calfincore' ),
                ],
                'condition' => [
                    'calfin_nav_site_logo_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_nav_custom_logo',
            [
                'label'     => __( 'Upload Logo', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::MEDIA,
                'default'   => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'calfin_nav_site_logo_select' => 'two',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'calfin_nav_clogo_size', // // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
            ]
        );
        $this->end_controls_section();

        //Content tab start
        $this->start_controls_section(
            'calfin_nave_menu_options',
            [
                'label' => esc_html__( 'calfin Nav Menu', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $menus = $this->get_available_menus();

        if ( !empty( $menus ) ) {
            $this->add_control(
                'calfin_menu_select',
                [
                    'label'        => __( 'Menu', 'calfincore' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => $menus,
                    'default'      => array_keys( $menus )[0],
                    'save_default' => true,
                    'separator'    => 'after',
                    'description'  => sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'calfincore' ), admin_url( 'nav-menus.php' ) ),
                ]
            );
        } else {
            $this->add_control(
                'calfin_menu_select',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => '<strong>' . __( 'There are no menus in your site.', 'calfincore' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'calfincore' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
                    'separator'       => 'after',
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                ]
            );
        }
        $this->add_control(
            'calfin_menu_location',
            [
                'label'       => __( 'Menu Location', 'calfincore' ),
                'description' => __( 'Select a location for your menu. This option facilitate the ability to create up to 2 mobile enabled menu locations', 'calfincore' ),
                'type'        => Controls_Manager::SELECT, 'options' => [
                    'mainmenu' => __( 'Main Menu', 'calfincore' ),
                ],
                'default'     => 'mainmenu',
            ]
        );
        $this->add_control(
            'text_padding',
            [
                'label'      => __( 'Text Padding - Default 1em', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-navigation a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_search_nmeu_options',
            [
                'label' => __( 'Search', 'calfincore' ),
            ]
        );
        $this->add_control(
            'calfin_search_nmeu_enable',
            [
                'label'        => esc_html__( 'Enable Search', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $this->add_control(
            'calfin_search_nmeu_icons',
            [
                'label'     => esc_html__( 'Icon', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::ICONS,
                'default'   => [
                    'value'   => 'fas fa-search',
                    'library' => 'solid',
                ],
                'condition' => [
                    'calfin_search_nmeu_enable' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_cta_nmeu_options',
            [
                'label' => __( 'Button', 'calfincore' ),
            ]
        );
        $this->add_control(
            'calfin_cta_nmeu_enable',
            [
                'label'        => esc_html__( 'Enable Button', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $this->add_control(
            'calfin_nmenu_buttons_select',
            [
                'label'       => esc_html__( 'Select Link', 'calfincore' ),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'extranal',
                'options'     => [
                    'extranal' => esc_html__( 'Extranal', 'calfincore' ),
                    'page'     => esc_html__( 'Page', 'calfincore' ),
                ],
                'condition'   => [
                    'calfin_cta_nmeu_enable' => 'yes',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'calfin_nmenu_buttons_extra',
            [
                'label'       => esc_html__( 'Extranal Link', 'calfincore' ),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active' => true,
                ],
                'condition'   => [
                    'calfin_nmenu_buttons_select' => 'extranal',
                    'calfin_cta_nmeu_enable'      => 'yes',
                ],
                'placeholder' => esc_html__( 'Add Extranal Link', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'calfin_nmenu_buttons_link',
            [
                'label'       => esc_html__( 'Page Link', 'calfincore' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => calfin_page_list(),
                'condition'   => [
                    'calfin_nmenu_buttons_select' => 'page',
                    'calfin_cta_nmeu_enable'      => 'yes',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'calfin_nmenu_buttons_text',
            [
                'label'       => esc_html__( 'Buttn Text', 'calfincore' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Meet With Us', 'calfincore' ),
                'label_block' => true,
                'condition'   => [
                    'calfin_cta_nmeu_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_nmenu_buttons_new_tab',
            [
                'label'        => __( 'Open New Window?', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'calfincore' ),
                'label_off'    => __( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'calfin_cta_nmeu_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_nmenu_buttons_nofollow',
            [
                'label'        => __( 'Add nofollow ?', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => __( 'Show', 'calfincore' ),
                'label_off'    => __( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'calfin_cta_nmeu_enable' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_site_logo_css_options',
            [
                'label'     => esc_html__( 'Logo CSS', 'calfincore' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_nav_site_logo_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_logo_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .logo-area .site-branding' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_logo_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .logo-area .site-branding' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_menus_box_css_options',
            [
                'label' => esc_html__( 'Menu Box CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'calfin_class_box_aligment',
            [
                'label'                => __( 'Alignment', 'calfincore' ),
                'type'                 => \Elementor\Controls_Manager::CHOOSE,
                'options'              => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'              => 'center',
                'toggle'               => true,
                'selectors_dictionary' => [
                    'left'   => 'margin-right: auto',
                    'center' => 'margin: 0 auto',
                    'right'  => 'margin-left: auto',
                ],
                'selectors'            => [
                    '{{WRAPPER}} ul.elementor-nav-menu' => '{{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_class_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} ul.elementor-nav-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_class_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} ul.elementor-nav-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_menus_css_options',
            [
                'label' => esc_html__( 'Menu CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_menus_normal_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_menus_hover_color',
            [
                'label'     => esc_html__( 'Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_menus_bgcolor',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_menus_hover_bgcolor',
            [
                'label'     => esc_html__( 'Background Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_nav_menus_normal_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a',
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_menus_normal_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_menus_normal_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .main-navigation ul.elementor-nav-menu > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_submenus_box_css_options',
            [
                'label' => esc_html__( 'SubMenu Box CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'calfin_nav_sub_box_align',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .stellarnav ul ul' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'calfin_nav_sub_box_bg',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .main-navigation ul li ul',
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_sub_box_top',
            [
                'label'      => esc_html__( 'Position Top', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -200,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .main-navigation ul li ul' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_nav_sub_box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .main-navigation ul li ul',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_submenus_css_options',
            [
                'label' => esc_html__( 'SubMenu CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_nav_submenus_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .main-navigation ul ul.sub-menu li a',
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_hcolor',
            [
                'label'     => esc_html__( 'Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_bg',
            [
                'label'     => esc_html__( 'background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_hbg',
            [
                'label'     => esc_html__( 'Hover background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_border_c',
            [
                'label'     => esc_html__( 'Border Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_submenus_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .main-navigation ul ul.sub-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_mobile_css_options',
            [
                'label' => esc_html__( 'Mobile Menu CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_navmenu_mobile_bgcolor',
            [
                'label'     => esc_html__( 'background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .stellarnav.mobile ul' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_navmenu_mobile_toggle_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .stellarnav .menu-toggle span.bars span' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_navmenu_mobile_toggle_top',
            [
                'label'      => esc_html__( 'Top', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -100,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs a.menu-toggle.full' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_navmenu_mobile_toggle_right',
            [
                'label'      => esc_html__( 'Right', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -100,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs a.menu-toggle.full' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_search_css_options',
            [
                'label'     => esc_html__( 'Search CSS', 'calfincore' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_search_nmeu_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_search_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementornavs .button.search-open' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_search_size',
            [
                'label'      => esc_html__( 'Font SIze', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs .button.search-open' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_search_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs .button.search-open' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_search_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs .button.search-open' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_nav_button_CSS_options',
            [
                'label'     => esc_html__( 'Button CSS', 'calfincore' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_cta_nmeu_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_button_CSS_aligment',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .calfin-button' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_button_CSS_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs a.theme-btns' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_button_CSS_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs a.theme-btns' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs(
            'calfin_nav_buttons_tabs'
        );
        $this->start_controls_tab(
            'calfin_nav_buttons_tabs_normal',
            [
                'label' => __( 'Normal', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_buttons_Css_ncolor',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementornavs a.theme-btns' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_buttons_Css_nbg',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementornavs a.theme-btns' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'calfin_nav_buttons_Css_nborder',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .elementornavs a.theme-btns',
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_buttons_Css_nradisu',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs a.theme-btns' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_nav_buttons_Css_nshadow',
                'label'    => esc_html__( 'Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .elementornavs a.theme-btns',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'calfin_nav_buttons_tabs_hover',
            [
                'label' => __( 'Hover', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_buttons_Css_hcolor',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementornavs a.theme-btns:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_buttons_Css_hbg',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementornavs a.theme-btns:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'calfin_nav_buttons_Css_hborder',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .elementornavs a.theme-btns:hover',
            ]
        );
        $this->add_responsive_control(
            'calfin_nav_buttons_Css_hradisu',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .elementornavs a.theme-btns:hover' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_nav_buttons_Css_hshadow',
                'label'    => esc_html__( 'Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .elementornavs a.theme-btns:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        $calfin_menu_location = $settings['calfin_menu_location'];
        // Get menu
        $calfin_nav_menu = !empty( $settings['calfin_menu_select'] ) ? wp_get_nav_menu_object( $settings['calfin_menu_select'] ) : false;
        if ( !$calfin_nav_menu ) {
            return;
        }
        $nav_menu_args = array(
            'container'      => false,
            'menu_id'        => $calfin_menu_location,
            'menu_class'     => 'elementor-nav-menu',
            'theme_location' => $calfin_menu_location,
            'menu'           => $calfin_nav_menu,
            'echo'           => true,
        );
        if ( $settings['calfin_cta_nmeu_enable'] == 'yes' && $settings['calfin_nmenu_buttons_select'] == 'page' ) {
            $link = get_page_link( $settings['calfin_nmenu_buttons_link'] );
        } else {
            $link = $settings['calfin_nmenu_buttons_extra'];
        }
        echo '
		<script>
			jQuery(document).ready(function($) {
				"use strict";
				jQuery(".elementornavs").stellarNav({
					theme: "plain",
					breakpoint: 1023,
					sticky: false,
					menuLabel: "",
					position: "static",
					openingSpeed: 80,
					closingDelay: 80,
					showArrows: true,
					closeBtn: false,
					closeLabel: "Close",
					mobileMode: false,
					scrollbarFix: false
				});
			});
		</script>';
        ob_start();
        ?>
		<div id="elementor-header-<?php echo esc_attr( $calfin_menu_location ); ?>" class="elementor-header">
			<div class="elementor-menu">
				<nav class="navbar navbar-expand-lg navbar-light main-navigation">
					<?php if ( $settings['calfin_nav_site_logo_enable'] == 'yes' ): ?>
					<div class="logo-area">
						<div class="site-branding">
							<?php
if ( $settings['calfin_nav_site_logo_select'] == 'two' ) {
            ?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'calfin_nav_clogo_size', 'calfin_nav_custom_logo' ); ?>
								</a>
								<?php
} else {
            the_custom_logo();
        }
        ?>
						</div><!-- .site-branding -->
					</div>
					<?php endif;?>
					<div class="navbar-collapse nav-menu stellarnav elementornavs">
						<?php
wp_nav_menu(
            apply_filters(
                'nav_menu_args',
                $nav_menu_args,
                $calfin_nav_menu,
                $settings
            )
        );
        ?>
						<?php if ( $settings['calfin_search_nmeu_enable'] == 'yes' ): ?>
						<div class="button search-open">
							<i class="<?php echo esc_attr( $settings['calfin_search_nmeu_icons']['value'] ) ?>"></i></a>
						</div>
						<?php endif;if ( $settings['calfin_cta_nmeu_enable'] == 'yes' ): ?>
						<div class="button d-flex cta">
							<a href="<?php echo esc_url( $link ); ?>" class="theme-btns" <?php if ( $settings['calfin_nmenu_buttons_new_tab'] == 'yes' ): ?> target="_blank" <?php endif;?> <?php if ( $settings['calfin_nmenu_buttons_nofollow'] == 'yes' ): ?>  rel="nofollow" <?php endif;?>><?php echo esc_html( $settings['calfin_nmenu_buttons_text'] ); ?></a>
						</div>
						<?php endif;?>
					</div>
				</nav>
			</div>
		</div>
		<?php if ( $settings['calfin_search_nmeu_enable'] == 'yes' ): ?>
		<div class="header-search-popup">
			<div class="header-search-overlay search-open"></div>
			<div class="header-search-popup-content">
				<form method="get" class="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<span class="screen-reader-text"><?php esc_html_e( 'Search here...', 'calfincore' )?></span>
					<input type="search" value="<?php echo esc_attr( get_search_query() ) ?>" name="s" placeholder="<?php esc_attr_e( 'Search here... ', 'calfincore' )?>" title="<?php esc_attr_e( 'Search for:', 'calfincore' )?>">
					<button type="submit"><i class="bi bi-search"></i></button>
				</form>
			</div>
		</div>
		<?php endif;?>
	<?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_nave_menu_Widget );