<?php
namespace Elementor;

class calfin_Animation_shape_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_Animation_shape';
    }

    public function get_title() {
        return esc_html__( 'calfin Shape Animation', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-handle';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_Animation_shape_options',
            [
                'label' => esc_html__( 'calfin Animation Shape 1', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_shape1_enable',
            [
                'label' => esc_html__( 'Enable Shape', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'calfin_shape_select',
            [
                'label'   => esc_html__( 'Select Animation', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'shapeMover',
                'options'   => [
                    'shapeMover'        => esc_html__( 'Shape Mover', 'calfincore' ),
                    'bubbleMover'       => esc_html__( 'Bubble Mover', 'calfincore' ),
                    'bounce'            => esc_html__( 'Bounce', 'calfincore' ),
                    'zoomIn'            => esc_html__( 'ZoomIn', 'calfincore' ),
                    'flash'             => esc_html__( 'Flash', 'calfincore' ),
                    'pulse'             => esc_html__( 'Pulse', 'calfincore' ),
                    'rubberBand'        => esc_html__( 'Rubber Band', 'calfincore' ),
                    'shake'             => esc_html__( 'ShakeX', 'calfincore' ),
                    'fadeIn'            => esc_html__( 'FadeIn', 'calfincore' ),
                    'fadeInDown'        => esc_html__( 'FadeIn Down', 'calfincore' ),
                    'fadeInLeft'        => esc_html__( 'FadeIn Left', 'calfincore' ),
                    'fadeInRight'       => esc_html__( 'FadeIn Right', 'calfincore' ),
                    'fadeInUp'          => esc_html__( 'FadeIn Up', 'calfincore' ),
                    'fadeOut'           => esc_html__( 'FadeOut', 'calfincore' ),
                    'fadeOutDown'       => esc_html__( 'FadeOut Down', 'calfincore' ),
                    'fadeOutLeft'       => esc_html__( 'FadeOut Left', 'calfincore' ),
                    'fadeOutRight'      => esc_html__( 'FadeOut Right', 'calfincore' ),
                    'fadeOutUp'         => esc_html__( 'FadeOut Up', 'calfincore' ),
                    'flip'              => esc_html__( 'Flip', 'calfincore' ),
                    'flipInX'           => esc_html__( 'FlipInX', 'calfincore' ),
                    'flipInY'           => esc_html__( 'FlipInY', 'calfincore' ),
                    'rotateIn'          => esc_html__( 'RotateIn', 'calfincore' ),
                    'rotateInDownLeft'  => esc_html__( 'RotateIn Down Left', 'calfincore' ),
                    'rotateInDownRight' => esc_html__( 'RotateIn Down Right', 'calfincore' ),
                    'rotateInUpLeft'    => esc_html__( 'RotateIn Up Left', 'calfincore' ),
                    'rotateInUpRight'   => esc_html__( 'RotateIn Up Right', 'calfincore' ),
                    'rotateOut'         => esc_html__( 'Rotate Out', 'calfincore' ),
                    'hinge'             => esc_html__( 'Hinge', 'calfincore' ),
                    'slideInDown'       => esc_html__( 'SlideIn Down', 'calfincore' ),
                    'slideInLeft'       => esc_html__( 'SlideIn Left', 'calfincore' ),
                    'slideInRight'      => esc_html__( 'SlideIn Right', 'calfincore' ),
                ],
                'condition' => [
                    'calfin_shape1_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_shape_img',
            [
                'label'   => __( 'Choose Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'calfin_shape1_enable' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'calfin_Animation_shape2_options',
            [
                'label' => esc_html__( 'calfin Animation Shape 2', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                
            ]
        );
        $this->add_control(
            'calfin_shape2_enable',
            [
                'label' => esc_html__( 'Enable Shape', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'calfin_shape2_select',
            [
                'label'   => esc_html__( 'Select Animation', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'shapeMover',
                'options'   => [
                    'shapeMover'        => esc_html__( 'Shape Mover', 'calfincore' ),
                    'bubbleMover'       => esc_html__( 'Bubble Mover', 'calfincore' ),
                    'bounce'            => esc_html__( 'Bounce', 'calfincore' ),
                    'zoomIn'            => esc_html__( 'ZoomIn', 'calfincore' ),
                    'flash'             => esc_html__( 'Flash', 'calfincore' ),
                    'pulse'             => esc_html__( 'Pulse', 'calfincore' ),
                    'rubberBand'        => esc_html__( 'Rubber Band', 'calfincore' ),
                    'shake'             => esc_html__( 'ShakeX', 'calfincore' ),
                    'fadeIn'            => esc_html__( 'FadeIn', 'calfincore' ),
                    'fadeInDown'        => esc_html__( 'FadeIn Down', 'calfincore' ),
                    'fadeInLeft'        => esc_html__( 'FadeIn Left', 'calfincore' ),
                    'fadeInRight'       => esc_html__( 'FadeIn Right', 'calfincore' ),
                    'fadeInUp'          => esc_html__( 'FadeIn Up', 'calfincore' ),
                    'fadeOut'           => esc_html__( 'FadeOut', 'calfincore' ),
                    'fadeOutDown'       => esc_html__( 'FadeOut Down', 'calfincore' ),
                    'fadeOutLeft'       => esc_html__( 'FadeOut Left', 'calfincore' ),
                    'fadeOutRight'      => esc_html__( 'FadeOut Right', 'calfincore' ),
                    'fadeOutUp'         => esc_html__( 'FadeOut Up', 'calfincore' ),
                    'flip'              => esc_html__( 'Flip', 'calfincore' ),
                    'flipInX'           => esc_html__( 'FlipInX', 'calfincore' ),
                    'flipInY'           => esc_html__( 'FlipInY', 'calfincore' ),
                    'rotateIn'          => esc_html__( 'RotateIn', 'calfincore' ),
                    'rotateInDownLeft'  => esc_html__( 'RotateIn Down Left', 'calfincore' ),
                    'rotateInDownRight' => esc_html__( 'RotateIn Down Right', 'calfincore' ),
                    'rotateInUpLeft'    => esc_html__( 'RotateIn Up Left', 'calfincore' ),
                    'rotateInUpRight'   => esc_html__( 'RotateIn Up Right', 'calfincore' ),
                    'rotateOut'         => esc_html__( 'Rotate Out', 'calfincore' ),
                    'hinge'             => esc_html__( 'Hinge', 'calfincore' ),
                    'slideInDown'       => esc_html__( 'SlideIn Down', 'calfincore' ),
                    'slideInLeft'       => esc_html__( 'SlideIn Left', 'calfincore' ),
                    'slideInRight'      => esc_html__( 'SlideIn Right', 'calfincore' ),
                ],
                'condition' => [
                    'calfin_shape2_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_shape_img2',
            [
                'label'   => __( 'Choose Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'calfin_shape2_enable' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'calfin_Animation_shape3_options',
            [
                'label' => esc_html__( 'calfin Animation Shape 3', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
                
            ]
        );
        $this->add_control(
            'calfin_shape3_enable',
            [
                'label' => esc_html__( 'Enable Shape', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'calfin_shape3_select',
            [
                'label'   => esc_html__( 'Select Animation', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'shapeMover',
                'options'   => [
                    'shapeMover'        => esc_html__( 'Shape Mover', 'calfincore' ),
                    'bubbleMover'       => esc_html__( 'Bubble Mover', 'calfincore' ),
                    'bounce'            => esc_html__( 'Bounce', 'calfincore' ),
                    'zoomIn'            => esc_html__( 'ZoomIn', 'calfincore' ),
                    'flash'             => esc_html__( 'Flash', 'calfincore' ),
                    'pulse'             => esc_html__( 'Pulse', 'calfincore' ),
                    'rubberBand'        => esc_html__( 'Rubber Band', 'calfincore' ),
                    'shake'             => esc_html__( 'ShakeX', 'calfincore' ),
                    'fadeIn'            => esc_html__( 'FadeIn', 'calfincore' ),
                    'fadeInDown'        => esc_html__( 'FadeIn Down', 'calfincore' ),
                    'fadeInLeft'        => esc_html__( 'FadeIn Left', 'calfincore' ),
                    'fadeInRight'       => esc_html__( 'FadeIn Right', 'calfincore' ),
                    'fadeInUp'          => esc_html__( 'FadeIn Up', 'calfincore' ),
                    'fadeOut'           => esc_html__( 'FadeOut', 'calfincore' ),
                    'fadeOutDown'       => esc_html__( 'FadeOut Down', 'calfincore' ),
                    'fadeOutLeft'       => esc_html__( 'FadeOut Left', 'calfincore' ),
                    'fadeOutRight'      => esc_html__( 'FadeOut Right', 'calfincore' ),
                    'fadeOutUp'         => esc_html__( 'FadeOut Up', 'calfincore' ),
                    'flip'              => esc_html__( 'Flip', 'calfincore' ),
                    'flipInX'           => esc_html__( 'FlipInX', 'calfincore' ),
                    'flipInY'           => esc_html__( 'FlipInY', 'calfincore' ),
                    'rotateIn'          => esc_html__( 'RotateIn', 'calfincore' ),
                    'rotateInDownLeft'  => esc_html__( 'RotateIn Down Left', 'calfincore' ),
                    'rotateInDownRight' => esc_html__( 'RotateIn Down Right', 'calfincore' ),
                    'rotateInUpLeft'    => esc_html__( 'RotateIn Up Left', 'calfincore' ),
                    'rotateInUpRight'   => esc_html__( 'RotateIn Up Right', 'calfincore' ),
                    'rotateOut'         => esc_html__( 'Rotate Out', 'calfincore' ),
                    'hinge'             => esc_html__( 'Hinge', 'calfincore' ),
                    'slideInDown'       => esc_html__( 'SlideIn Down', 'calfincore' ),
                    'slideInLeft'       => esc_html__( 'SlideIn Left', 'calfincore' ),
                    'slideInRight'      => esc_html__( 'SlideIn Right', 'calfincore' ),
                ],
                'condition' => [
                    'calfin_shape3_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_shape_img3',
            [
                'label'   => __( 'Choose Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'calfin_shape3_enable' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'calfin_Animation_shape_css_options',
            [
                'label' => esc_html__( 'CSS Shape 1', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_shape1_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape_top',
            [
                'label' => esc_html__( 'Top To Bottom', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation.shape1' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape_left',
            [
                'label' => esc_html__( 'Left To Right', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation.shape1' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape_duration',
            [
                'label' => esc_html__( 'Animation Duration', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 's' ],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 100,
                        'step' => 0.1,
                    ]
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 9,
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'calfin_Animation_shape2_css_options',
            [
                'label' => esc_html__( 'CSS Shape 2', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_shape2_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape2_top',
            [
                'label' => esc_html__( 'Top To Bottom', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation.shape2' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape2_left',
            [
                'label' => esc_html__( 'Left To Right', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation.shape2' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape2_duration',
            [
                'label' => esc_html__( 'Animation Duration', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 's' ],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 100,
                        'step' => 0.1,
                    ]
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 9,
                ],
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'calfin_Animation_shape3_css_options',
            [
                'label' => esc_html__( 'CSS Shape 3', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'calfin_shape3_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape3_top',
            [
                'label' => esc_html__( 'Top To Bottom', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation.shape3' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape3_left',
            [
                'label' => esc_html__( 'Left To Right', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 2000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation.shape3' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_shape3_duration',
            [
                'label' => esc_html__( 'Animation Duration', 'calfincore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 's' ],
                'range' => [
                    's' => [
                        'min' => 0.1,
                        'max' => 100,
                        'step' => 0.1,
                    ]
                ],
                'default' => [
                    'unit' => 's',
                    'size' => 9,
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <?php 
        ob_start();
        if($settings['calfin_shape1_enable'] == 'yes'){
            echo '<img src="'.esc_url($settings['calfin_shape_img']['url']).'" alt="'.esc_attr('calfin Shape','calfincore').'" class="bubbleMover shapeanimation shape1" style="-webkit-animation-name:'.esc_attr($settings['calfin_shape_select']).';
            animation-name: '.esc_attr($settings['calfin_shape_select']).'; animation-duration:'.esc_attr($settings['calfin_shape_duration']['size']).'s;-webkit-animation-duration:'.esc_attr($settings['calfin_shape_duration']['size']).'s">';
        }
        if($settings['calfin_shape2_enable'] == 'yes'){
            echo '<img src="'.esc_url($settings['calfin_shape_img2']['url']).'" alt="'.esc_attr('calfin Shape','calfincore').'" class="bubbleMover shapeanimation shape2" style="-webkit-animation-name:'.esc_attr($settings['calfin_shape2_select']).';
            animation-name: '.esc_attr($settings['calfin_shape2_select']).'; animation-duration:'.esc_attr($settings['calfin_shape2_duration']['size']).'s;-webkit-animation-duration:'.esc_attr($settings['calfin_shape2_duration']['size']).'s">';
        }
        if($settings['calfin_shape3_enable'] == 'yes'){
            echo '<img src="'.esc_url($settings['calfin_shape_img3']['url']).'" alt="'.esc_attr('calfin Shape','calfincore').'" class="bubbleMover shapeanimation shape3" style="-webkit-animation-name:'.esc_attr($settings['calfin_shape3_select']).';
            animation-name: '.esc_attr($settings['calfin_shape3_select']).'; animation-duration:'.esc_attr($settings['calfin_shape3_duration']['size']).'s;-webkit-animation-duration:'.esc_attr($settings['calfin_shape3_duration']['size']).'s">';
        }
       
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_Animation_shape_Widget );