<?php namespace Elementor;

class calfin_slider_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_slider';
    }

    public function get_title() {
        return esc_html__( 'Calfin Slider', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-slider-album';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'slider_option',
            [
                'label' => esc_html__( 'Slider', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'enable_container',
			[
				'label' => esc_html__( 'Enable Container', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label'   => esc_html__( 'Background Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_responsive_control(
			'image_background_color',
			[
				'label' => esc_html__( 'Background Opacity', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slider-item:after' => 'background-color: {{VALUE}}',
				],
			]
		);
        $repeater->add_control(
            'image_right',
            [
                'label'   => esc_html__( 'Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'images',
            [
                'label'   => esc_html__( 'Background Shape', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'small_title',
            [
                'label'   => esc_html__( 'Small Title', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::TEXT ,
                'default' => esc_html__( 'ABOUT COMPANY', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'calfin_section_title',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Making the world','calfincore' ),
            ]
        );
        $repeater->add_control(
            'calfin_section_title_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'calfincore' ),
                'description' => esc_html__( 'Add HTML Tag For Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h2',
                'options' => [
                    'h1'  => esc_html__( 'H1', 'calfincore' ),
                    'h2'  => esc_html__( 'H2', 'calfincore' ),
                    'h3'  => esc_html__( 'H3', 'calfincore' ),
                    'h4'  => esc_html__( 'H4', 'calfincore' ),
                    'h5'  => esc_html__( 'H5', 'calfincore' ),
                    'h6'  => esc_html__( 'H6', 'calfincore' ),
                    'p'  => esc_html__( 'P', 'calfincore' ),
                    'span'  => esc_html__( 'span', 'calfincore' ),
                    'div'  => esc_html__( 'Div', 'calfincore' ),
                ],
            ]
        );
        $repeater->add_control(
            'calfin_highlight_title',
            [
                'label' => esc_html__( 'High Light Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'A better place','calfincore' ),
            ]
        );
        $repeater->add_control(
            'enable_dec',
            [
                'label'        => esc_html__( 'Enable Description', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $repeater->add_control(
            'des',
            [
                'label'   => esc_html__( 'Description', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( ' Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vel iaculis lectus diam mattis consectetur amet lorem condimentum.,', 'calfincore' ),
                'condition' => [
                    'enable_dec' => 'yes',
                ],
                'rows'   =>     10,
            ]
        );
        $repeater->add_control(
            'enable_button',
            [
                'label'        => esc_html__( 'Enable Button one', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $repeater->add_control(
            'button_text',
            [
                'label'     => esc_html__( 'Button ', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'default'   => esc_html__( 'Join Us Today', 'calfincore' ),
                'condition' => [
                    'enable_button' => 'yes',
                ],
            ]
        );
        $repeater->add_control(
            'button_link',
            [
                'label'       => esc_html__( 'Url', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'calfincore' ),
                'options'     => ['url', 'is_external', 'nofollow'],
                'label_block' => true,
                'default'     => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                    'custom_attributes' => false,
                ],
                'condition'   => [
                    'enable_button' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'sliders',
            [
                'label'       => esc_html__( 'Repeater List', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
				'default' => [
					[
						'title' => esc_html__( 'Donate To Contribution', 'calfincore' ),
						'list_content' => esc_html__( 'Description is the pattern of narrative development that aims to make vivid a place, object, character, or group. Description is one of four rhetorical modes, along with exposition, argumentation.', 'calfincore' ),
					],
				],
                'title_field' => '{{{ title }}}',
            ]
        );
        $this->add_responsive_control(
			'reverge',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Content Alignment', 'calfincore' ),
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-long-arrow-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-long-arrow-right',
					],
				],
				'default' => 'right',
                'toggle'  => true,
                'selectors_dictionary' => [
                    'right'   => 'flex-direction:row',
                    'left'  => 'flex-direction:row-reverse',
                ],
                'selectors'            => [
                    '{{WRAPPER}} .content-row' => '{{VALUE}}',
                ],
			]
		);      
        $this->add_responsive_control(
            'content_alignment',
            [
                'label'     => esc_html__( 'Content Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'    => [
                        'title' => esc_html__( 'Left', 'calfincore' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'calfincore' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    
                    'right'   => [
                        'title' => esc_html__( 'Right', 'calfincore' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .slider-content-box' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'bg_image_height',
            [
                'label'      => esc_html__( 'Background Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px','%'],
                'range'      => [
                   
                    'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .slider-item' => 'height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'calfin_slider_arrow',
            [
                'label' => esc_html__( 'Enable Arrow Icon', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'calfin_enable_dots',
            [
                'label' => esc_html__( 'Enable Dots Icon', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'calfin_slider_autoplay',
            [
                'label' => esc_html__( 'Enable autoplay', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'calfin_slider_speed',
            [
                'label' => esc_html__( 'Slider Speed', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 500,
                'max' => 10000,
                'step' => 100,
                'default' => 5000,
            ]
        );
        $this->end_controls_section();

		
		$this->start_controls_section(
			'blog_box_css',
			[
				'label' => esc_html__( 'Content Box Css', 'calfincore' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'box_background',
				'label' => esc_html__( 'Background', 'calfincore' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .inner-slider',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'label' => esc_html__( 'Border', 'calfincore' ),
				'selector' => '{{WRAPPER}} .inner-slider',
			]
		);
		$this->add_responsive_control(
			'box_radius',
			[
				'label' => esc_html__( 'Border Radius', 'calfincore' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .inner-slider' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Box Shadow', 'calfincore' ),
				'selector' => '{{WRAPPER}} .inner-slider',
			]
		);
		$this->add_responsive_control(
			'box_margin',
			[
				'label' => esc_html__( 'Margin', 'calfincore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .inner-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'calfincore' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .inner-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

        // ===============================================
        // =========== IMAGE STYLE CSS ===================
        // ===============================================

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__( 'Image Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' =>1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .slider-feature-img img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .slider-feature-img img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'object',
            [
                'label' => esc_html__( 'Object Fit', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__( 'Fill', 'calfincore' ),
                    'contain' => esc_html__( 'Contain', 'calfincore' ),
                    'cover' => esc_html__( 'Cover', 'calfincore' ),
                    'none' => esc_html__( 'None', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-feature-img img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .slider-feature-img img',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-feature-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-feature-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-feature-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

		
        // =============================================//
         // ========= SLIDER CONTENT STYLE START ========//
        // =============================================//


        $this->start_controls_section(
            'slider_section',
            [
                'label' => esc_html__( 'Content', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'slider_content_tabs'
        );
        $this->start_controls_tab(
            'style_small_title_tab',
            [
                'label' => esc_html__( 'Small Title', 'calfincore' ),
            ]
        );
        $this->add_control(
            'sm_title',
            [
                'label'     => esc_html__( 'Small Title', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'sm_color',
            [
                'label'     => esc_html__( 'Title Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'sm_typography',
                'selector' => '{{WRAPPER}} .calfin-section-stitle',
            ]
        );
        $this->add_responsive_control(
            'sm_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sm_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        //start titile style -------

        $this->start_controls_tab(
            'calfin_titles_tabs_title',
            [
                'label' => __( 'Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_section_title_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-t-title',
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_high_light_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .highlight-heading',
            ]
        );
        $this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Hight Light Border Color', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .calfin-t-title .highlight-heading::after' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
            'calfin_section_title_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        //Description style------

        $this->start_controls_tab(
            'style_description_tab',
            [
                'label' => esc_html__( 'Description', 'calfincore' ),
            ]
        );
        $this->add_control(
            'slider_description',
            [
                'label'     => esc_html__( 'Description', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'dec_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sty_des' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'Des_typography',
                'selector' => '{{WRAPPER}} .sty_des',
            ]
        );
        $this->add_responsive_control(
            'des_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .sty_des' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'des_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .sty_des' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();       
        $this->end_controls_section();

        // =============================================//
         // ========= BUTTON ONE CONTENT STYLE START ========//
        // =============================================//

       
        $this->start_controls_section(
            'btn_one',
            [
                'label' => esc_html__( 'Button Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'btn_one_tabs'
        );

        $this->start_controls_tab(
            'btn_one_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_one_typo',
                'selector' => '{{WRAPPER}} .theme-btns',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name'     => 'btn_one_text_shadow',
                'label'    => esc_html__( 'Text Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .theme-btns',
            ]
        );
        $this->add_responsive_control(
            'btn_one_text_color',
            [
                'label'     => esc_html__( 'Text Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-btns' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'btn_one_bg',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .theme-btns',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'btn_one_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .theme-btns',
            ]
        );
        $this->add_responsive_control(
            'btn_one_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .theme-btns' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_one_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .theme-btns' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_one_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .theme-btns' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'btn_one_tab_hover',
            [
                'label' => esc_html__( 'Hover', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'btn_one_typo_hover',
                'selector' => '{{WRAPPER}} .theme-btns:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name'     => 'btn_one_shadow_hover',
                'label'    => esc_html__( 'Text Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .theme-btns:hover',
            ]
        );
        $this->add_responsive_control(
            'btn_one_color_hover',
            [
                'label'     => esc_html__( 'Text Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .theme-btns:hover.theme-btns' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'btn_one_bg_hover',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .theme-btns:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'btn_one_border_hover',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .theme-btns:hover',
            ]
        );
        $this->add_responsive_control(
            'btn_one_border_radius_hover',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .theme-btns:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

         //==========================================//
        //=========== ARROW STYLE START===========//
        //========================================//

        $this->start_controls_section(
			'arrow_content',
			[
				'label' => esc_html__( 'Arrow Style', 'calfincore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'more_options',
			[
				'label' => esc_html__( 'Dode Color', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'left_dode_color',
				'label' => esc_html__( 'Background', 'calfincore' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .slick-dots li button',
                'separator' => 'before',
			]
		);
        $this->add_responsive_control(
            'arrow_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .slick-arrow' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'left_arrow_typography',
				'selector' => '{{WRAPPER}} .slick-arrow',
			]
		);
		$this->add_responsive_control(
            'left_arrow_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-arrow' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_responsive_control(
            'left_arrow_color_hover',
            [
                'label'     => esc_html__( 'Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slick-arrow:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'left_arrow_background',
				'label' => esc_html__( 'Background', 'calfincore' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .slick-arrow',
			]
		);
        $this->add_control(
			'more_options2',
			[
				'label' => esc_html__( 'Background Hover Color', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'left_arrow_background_hover',
				'label' => esc_html__( 'Background Hover', 'calfincore' ),
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .slick-arrow:hover',
			]
		);
        $this->add_responsive_control(
            'left_arrow_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .slick-arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 
		$this->add_responsive_control(
            'left_arrow_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .slick-arrow' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'left_arrow_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .slick-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

 
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        if( $settings['enable_container'] == 'yes' ){
            $container = 'container';
        }else{
            $container = 'container-fluid';
        }
        ob_start();
        $_id = rand( 1241, 3256 );
        ?>
        <script>
                (function ($) {
                    "use strict";
                    //Documnet Ready Function
                    $( document ).ready(function() {
                        // slider - active
                        function homeSlider() {
                            var SliderActive = $('#slider<?php echo esc_attr($_id)?>');

                            SliderActive.slick({
                                slidesToShow: 1,
                                autoplay: <?php echo json_encode( $settings['calfin_slider_autoplay'] == 'yes' ? true : false ); ?>,
                                speed: 1000, // slide speed
                                autoplaySpeed: <?php echo json_encode($settings['calfin_slider_speed']); ?>,
                                dots: <?php echo json_encode( $settings['calfin_enable_dots'] == 'yes' ? true : false ); ?>,
                                fade: true,
                                draggable: true,
                                pauseOnHover: false,
                                arrows:<?php echo json_encode( $settings['calfin_slider_arrow'] == 'yes' ? true : false ); ?>,
                                prevArrow: '<i class="slick-arrow slick-prev fas fa-angle-left"></i>',
                                nextArrow: '<i class="slick-arrow slick-next fas fa-angle-right"></i>',
								responsive: [
                                    {
                                        breakpoint: 1024,
                                        settings: {
                                            arrows:false,
                                            dots:true
                                        }
                                    },
                                    {
                                        breakpoint: 992,
                                        settings: {
                                            arrows:false
                                        }
                                    },
                                    {
                                        breakpoint: 768,
                                        settings: {
                                            arrows:false
                                        }
                                    }
                                ]
                            });
                            function doAnimations(elements) {
                                var animationEndEvents = 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend';
                                elements.each(function () {
                                    var $this = $(this);
                                    var $animationDelay = $this.data('delay');
                                    var $animationType = 'animated ' + $this.data('animation');
                                    $this.css({
                                        'animation-delay': $animationDelay,
                                        '-webkit-animation-delay': $animationDelay
                                    });
                                    $this.addClass($animationType).one(animationEndEvents, function () {
                                        $this.removeClass($animationType);
                                    });
                                });
                            }
                            SliderActive.on('init', function (e, slick) {
                                var $firstAnimatingElements = $('.slider-item:first-child').find('[data-animation]');
                                doAnimations($firstAnimatingElements);
                            });
                            SliderActive.on('beforeChange', function (e, slick, currentSlide, nextSlide) {
                                var $animatingElements = $('.slider-item[data-slick-index="' + nextSlide + '"]').find('[data-animation]');
                                doAnimations($animatingElements);
                            });
                        }
                        homeSlider();
                    });
                })(jQuery);
			</script>
    <div class="calfin-slider-wrapper">
        <div class="slider-area" id="slider<?php echo esc_attr( $_id ); ?>">
            <?php foreach ( $settings['sliders'] as $item ): ?>
                <div class="slider-items">
                    <div class="slider-item" style="background-image:url( <?php echo esc_url(wp_get_attachment_image_url( $item['image']['id'], 'full' )); ?> ) ">
                        <div class="<?php echo esc_attr($container)?>">
                            <div class="row content-row">
                                <div class=" slider-content-box col-xl-6 col-lg-6 col-md-12">
                                    <div class="inner-slider">
                                        <h4 class="calfin-section-stitle animated" data-animation-in="fadeInRight"><?php echo  esc_html($item['small_title'])?></h4>
                                        <<?php echo esc_attr($item['calfin_section_title_tag']); ?> class="calfin-t-title animated" data-animation-in="fadeInRight">
                                            <?php echo wp_kses_post($item['calfin_section_title']); ?>
                                            <span class="highlight-heading"><?php echo esc_html($item['calfin_highlight_title'])?></span>
                                        </<?php echo esc_attr($item['calfin_section_title_tag']); ?>>
                                        <?php if ( 'yes' == $item['enable_dec'] ) :?>
                                        <p class = "sty_des animated" data-animation-in="fadeInRight"><?php echo $item['des']; ?></p>
                                        <?php endif;?>
                                        <div class="slider-buttons buttons animated" data-animation-in="fadeInRight" >
                                        <?php if ( 'yes' == $item['enable_button'] ) :
                                                    $url      = $item['button_link']['url'];
                                                    $target   = $item['button_link']['is_external'] ? ' target="_blank"' : '';
                                                    $nofollow = $item['button_link']['nofollow'] ? ' rel="nofollow"' : '';
                                            ?>
                                            <a href="<?php echo esc_url($url); ?>" <?php echo $target . $nofollow;?> class="theme-btns"><?php echo esc_html($item['button_text']); ?></a>
                                            <?php endif;?>
                                        </div>
                                    </div>
                                </div>
                                <div class="slider-content-box col-xl-6 col-lg-6 col-md-12">
                                    <div class="slider-feature-img" style="background-image:url( <?php echo esc_url(wp_get_attachment_image_url( $item['images']['id'], 'full' )); ?> ) ">
                                        <?php echo wp_get_attachment_image( $item['image_right']['id'], 'full' );?>
                                    </div> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach?>
        </div>
    </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_slider_Widget );