<?php namespace Elementor;

class social_icons_Widget extends Widget_Base {

    public function get_name() {

        return 'social_icons';
    }

    public function get_title() {
        return esc_html__( 'calfin Social', 'calfincore' );
    }

    public function get_icon() {

        return ' eicon-social-icons';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_social_options',
            [
                'label' => esc_html__( 'calfin Social', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'follow us on social media', 'calfincore' ),
                'label_block' => 'true'
            ]
        );
        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			's_title', [
				'label' => esc_html__( 'Title', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'List Title' , 'calfincore' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default'     => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                    'custom_attributes' => false,
                ],
				'label_block' => true,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Repeater List', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						's_title' => esc_html__( 'Facebook ', 'calfincore' ),
					],
					[
						's_title' => esc_html__( ' Instragram', 'calfincore' ),
					],
                    [
						's_title' => esc_html__( ' Twiter', 'calfincore' ),
					],
				],
				'title_field' => '{{{ s_title }}}',
			]
		);
        $this->end_controls_section();
        $this->start_controls_section(
            'social_css_option',
            [
                'label' => esc_html__( 'Social Icon CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
			'social_align',
			[
				'label' => esc_html__( 'Alignment', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'calfincore' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .social-icon-wraper' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->start_controls_tabs(
            'social_tabs'
        );
        $this->start_controls_tab(
            'social_tab_title',
            [
                'label' => __( 'Title', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'socil_title_color',
            [
                'label' => esc_html__( 'Title Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social_icon_title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'social_title_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .social_icon_title',
            ]
        );
        $this->add_responsive_control(
            'social_title_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .social_icon_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_title_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .social_icon_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'social_normal_tab',
            [
                'label' => esc_html__( 'Normal Icon', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'social_text_color',
            [
                'label'     => esc_html__( 'Text Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon-box ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'social_bg',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .social-icon-box ul li a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'social_typo',
                'selector' => '{{WRAPPER}} .social-icon-box ul li a',
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'social_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'calfincore' ),
				'selector' => '{{WRAPPER}} .social-icon-box ul li a',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'social_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .social-icon-box ul li a',
            ]
        );
        $this->add_responsive_control(
            'social_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .social-icon-box ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .social-icon-box ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .social-icon-box ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'social_tab_hover',
            [
                'label' => esc_html__( 'Hover Icon', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'social_color_hover',
            [
                'label'     => esc_html__( 'Text Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-icon-box ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'social_bg_hover',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .social-icon-box ul li a:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'social_typo_hover',
                'selector' => '{{WRAPPER}} .social-icon-box ul li a:hover',
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'social_shadow_hover',
				'label' => esc_html__( 'Box Shadow', 'calfincore' ),
				'selector' => '{{WRAPPER}} .social-icon-box ul li a:hover',
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'social_border_hover',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .social-icon-box ul li a:hover',
            ]
        );
        $this->add_responsive_control(
            'social_border_radius_hover',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .social-icon-box ul li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ob_start();
        ?>
        <div class="social-icon-wraper">
            <div class="sicon-title">
            <?php if(!empty($settings['title'])): ?>
                <h2 class="social_icon_title"><?php echo esc_html($settings['title'])?></h2>
            <?php endif; ?>
            </div>
            <div class="social-icon-box">
                <ul>
                    <?php foreach($settings['list'] as $item):
                      $url      = $item['link']['url'];
                      $target   = $item['link']['is_external'] ? ' target="_blank"' : '';
                      $nofollow = $item['link']['nofollow'] ? ' rel="nofollow"' : '';
                        ?>
                    <li><a href="<?php echo esc_url($url); ?>" <?php echo $target . $nofollow;?>>
                    <?php echo esc_html($item['s_title'])?></a></li>
                    <?php endforeach;?>
                </ul>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new social_icons_Widget );