<?php namespace Elementor;

class calfin_tabs_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_tabs_widget';
    }

    public function get_title() {
        return esc_html__( 'calfin Tabs Widget', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['calfin'];
    }
    /**
     * Elementor Templates List
     * return array
     */
    public function calfin_elementor_template() {
        $templates = Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
        $types     = array();
        if ( empty( $templates ) ) {
            $template_lists = [ '0' => __( 'Do not Saved Templates.', 'calfincore' ) ];
        } else {
            $template_lists = [ '0' => __( 'Select Template', 'calfincore' ) ];
            foreach ( $templates as $template ) {
                $template_lists[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
            }
        }
        return $template_lists;
    }
    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_tabs_options',
            [
                'label' => esc_html__( 'calfin Tabs Widget', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'calfin_tabs_active',
            [
                'label' => esc_html__( 'Active', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $repeater->add_control(
            'calfin_tabs_title',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Digital Marketing', 'calfincore' ),
            ]
        );
        $repeater->add_responsive_control(
            'calfin_tabs_content_source',
            [
                'label' => esc_html__( 'Content Source', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'custom',
                'options' => [
                    'custom'  => esc_html__( 'Content', 'calfincore' ),
                    'elementor' => esc_html__( 'Template', 'calfincore' ),
                ],
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'template_id',
            [
                'label'     => __( 'Content', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '0',
                'options'   => $this->calfin_elementor_template(),
                'condition' => [
                    'calfin_tabs_content_source' => "elementor"
                ],
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
            'calfin_tabs_content_custom',
            [
                'label'      => __( 'Content', 'calfincore' ),
                'type'       => Controls_Manager::WYSIWYG,
                'title'      => __( 'Content', 'calfincore' ),
                'condition'  => [
                    'calfin_tabs_content_source' => 'custom',
                ],
                'separator' => 'before',
            ]
        );
        $repeater->add_control(
			'image',
			[
				'label' => esc_html__( 'Image', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
                'condition'  => [
                    'calfin_tabs_content_source' => 'custom',
                ],
                'separator' => 'before',
			]
		);
        $this->add_control(
            'calfin_tabs_list',
            [
                'label'   => esc_html__( 'Tabs', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'calfin_tabs_title' => '',
                        'calfin_tabs_content_source' => '',
                    ],
                ],
            ]
        );
        $this->add_control(
			'Additional',
			[
				'label' => esc_html__( 'Additional Options', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_responsive_control(
			'justify_content',
			[
				'label' => esc_html__( 'Justify Content:', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'flex-start' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-justify-start-h',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'calfincore' ),
						'icon' => 'eicon-justify-center-h',
					],
                    'space-between' => [
						'title' => esc_html__( 'Space Between', 'calfincore' ),
						'icon' => 'eicon-justify-space-between-h',
					],
                    'space-around' => [
						'title' => esc_html__( 'Space Around', 'calfincore' ),
						'icon' => 'eicon-justify-space-around-h',
					],
                    'space-evenly' => [
						'title' => esc_html__( 'Space Evenly', 'calfincore' ),
						'icon' => ' eicon-justify-space-evenly-h',
					],
					'flex-end' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-justify-end-h',
					],
				],
				'default' => 'space-evenly',
				'toggle' => true,
                'label_block' => true,
				'selectors' => [
					'{{WRAPPER}} .tabs-section-wrapper .nav' => 'justify-content: {{VALUE}};',
				],
			]
		);
        $this->end_controls_section();

        // ===================================================
        // ================ TABS BOX STYLE CSS ==============
        // ===================================================

        $this->start_controls_section(
            'calfin_tabs_css_box_options',
            [
                'label' => esc_html__( 'Calfin Tab Box', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .tabs-section-wrapper',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .tabs-section-wrapper',
            ]
        );
        $this->add_responsive_control(
            'tabs_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .tabs-section-wrapper',
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ===================================================
        // ================ TABS HEADING BOX STYLE CSS ==============
        // ===================================================

        $this->start_controls_section(
            'calfin_tabs_box_options',
            [
                'label' => esc_html__( 'Calfin Menu Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_tabs_css_box_active_color',
            [
                'label' => esc_html__( 'Active Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tabs-section-wrapper .nav-tabs .nav-link.active' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'active_padding',
            [
                'label'      => esc_html__( 'Active Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper .nav-tabs .nav-link.active' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'tbox_backgrounds',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .tabs-section-wrapper .nav',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'tbox_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .tabs-section-wrapper .nav-tabs .nav-link',
            ]
        );
        $this->add_responsive_control(
            'ttabs_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper .nav-tabs .nav-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tbox_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper .nav-tabs .nav-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tbox_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tabs-section-wrapper .nav-tabs .nav-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


        //========================================//
        //============  CONTENT STYLE ===========//
        //=======================================//

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'tabs_content_tabs'
        );

        $this->start_controls_tab(
            'content_tab',
            [
                'label' => esc_html__( 'Content', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'content_box_width',
            [
                'label'      => esc_html__( 'Box width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ '%', 'custom' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'default' => [
					'unit' => '%',
				],
                'selectors'  => [
                    '{{WRAPPER}} .alfin-tab-custom-content' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tabs_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-custom-content' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'tabs_typography',
                'selector' => '{{WRAPPER}} .tab-custom-content',
            ]
        );
        $this->add_responsive_control(
            'tabs_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tab-custom-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'tabs_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tab-custom-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
			'list_item_style',
			[
				'label' => esc_html__( 'List Item Style', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_responsive_control(
            'item_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-custom-content ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'item_typography',
                'selector' => '{{WRAPPER}} .tab-custom-content ul li',
            ]
        );
        $this->add_control(
			'more_options',
			[
				'label' => esc_html__( 'Icon Style', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_responsive_control(
            'icon_ item_color',
            [
                'label'     => esc_html__( 'Icon Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tab-custom-content ul li:after' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'list_width',
            [
                'label' => esc_html__( 'List Width', 'calfincore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'custom' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
                    'default' => [
                        'unit' => '%',
                        'size' => 50,
                    ],
				],
                'selectors' => [
                    '{{WRAPPER}} .tab-custom-content ul li' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label' => esc_html__( 'Icon Width', 'calfincore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px','%' ],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-custom-content ul li:after' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_height',
            [
                'label' => esc_html__( 'Icon Height', 'calfincore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px','%' ],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .tab-custom-content ul li:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );  
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'icon_item_backgrounds',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .tab-custom-content ul li:after',
            ]
        );
       
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'icon_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .tab-custom-content ul li:after',
            ]
        );
        $this->add_responsive_control(
            'icon_border_redius',
            [
                'label'      => esc_html__( 'Border Redius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tab-custom-content ul li:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tab-custom-content ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'item_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .tab-custom-content ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        // ======= START ITEM LIST STYLE =======//

        $this->start_controls_tab(
            'image_content',
            [
                'label' => esc_html__( 'Image Style', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'image_box_width',
            [
                'label'      => esc_html__( 'Box width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ '%', 'custom' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'default' => [
					'unit' => '%',
				],
                'selectors'  => [
                    '{{WRAPPER}} .custom-image .tab-custom-image' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'image_align',
			[
				'label' => esc_html__( 'Alignment', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'calfincore' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .custom-image .tab-custom-image' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' =>1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .custom-image .tab-custom-image img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .custom-image .tab-custom-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'object',
            [
                'label' => esc_html__( 'Object Fit', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__( 'Fill', 'calfincore' ),
                    'contain' => esc_html__( 'Contain', 'calfincore' ),
                    'cover' => esc_html__( 'Cover', 'calfincore' ),
                    'none' => esc_html__( 'None', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .custom-image .tab-custom-image img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .custom-image .tab-custom-image img',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .custom-image .tab-custom-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .custom-image .tab-custom-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .custom-image .tab-custom-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        $unique = rand(350, 540);
        ob_start();
        ?>
        <div class="tabs-section-wrapper">
            <ul class="nav nav-tabs" id="alfin_tab<?php echo esc_attr($unique); ?>" role="tablist">
                <?php $count = 0; foreach($settings['calfin_tabs_list'] as $tablist) : $count++; ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link <?php echo esc_attr($tablist['calfin_tabs_active'] == 'yes' ? 'active' : '' ); ?>" id="calfin-tab-<?php echo esc_attr($unique.$count) ?>" data-bs-toggle="tab" data-bs-target="#calfin-tab-body-<?php echo esc_attr($unique.$count) ?>" type="button" role="tab" aria-controls="calfin-tab-body-<?php echo esc_attr($unique.$count) ?>" aria-selected="true"> <?php echo esc_html($tablist['calfin_tabs_title'])?></button>
                </li>
                <?php endforeach; ?>
            </ul>
            <div class="tab-content" id="alfin_tab_content<?php echo esc_attr($unique); ?>">
                <?php $count = 0; foreach($settings['calfin_tabs_list'] as $tablist) : $count++; ?>
                <div class="tab-pane fade <?php echo esc_attr($tablist['calfin_tabs_active'] == 'yes' ? 'show active' : '' ); ?>" id="calfin-tab-body-<?php echo esc_attr($unique.$count) ?>" role="tabpanel" aria-labelledby="calfin-tab-<?php echo esc_attr($unique.$count) ?>">
                    <?php 
                        if($tablist['calfin_tabs_content_source'] == 'elementor' && !empty( $tablist['template_id'] )){
                        echo Plugin::instance()->frontend->get_builder_content_for_display( $tablist['template_id'] );
                        }else{
                            if(!empty($tablist['image']['url'])){
                                $image = 'custom-image';
                            }else{
                                $image = '';
                            }
                           ?>
                            <div class="alfin-tab-custom-content <?php echo esc_attr($image); ?>">
                                <div class="tab-custom-content">
                                    <?php echo wp_kses_post( $tablist['calfin_tabs_content_custom'] ); ?>
                                </div>
                                <?php if(!empty($tablist['image']['url'])) : ?>
                                <div class="tab-custom-image">
                                    <?php echo wp_get_attachment_image( $tablist['image']['id'], 'full' ); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                           <?php 
                        }
                    ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_tabs_Widget );

