<?php namespace Elementor;

class calfin_title_two_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_title_two';
    }

    public function get_title() {
        return esc_html__( 'Calfin Title Two', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_title_options',
            [
                'label' => esc_html__( 'calfin Title Two', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'enable_container',
			[
				'label' => esc_html__( 'Enable Container', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
            'calfin_section_stitle',
            [
                'label' => esc_html__( 'Small Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Our features', 'calfincore' ),
              
            ]
        );
        $this->add_control(
            'calfin_section_stitle_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'calfincore' ),
                'description' => esc_html__( 'Add HTML Tag For Small Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h6',
                'options' => [
                    'h1'  => esc_html__( 'H1', 'calfincore' ),
                    'h2'  => esc_html__( 'H2', 'calfincore' ),
                    'h3'  => esc_html__( 'H3', 'calfincore' ),
                    'h4'  => esc_html__( 'H4', 'calfincore' ),
                    'h5'  => esc_html__( 'H5', 'calfincore' ),
                    'h6'  => esc_html__( 'H6', 'calfincore' ),
                    'p'  => esc_html__( 'P', 'calfincore' ),
                    'span'  => esc_html__( 'span', 'calfincore' ),
                    'div'  => esc_html__( 'Div', 'calfincore' ),
                ],
              
            ]
        );
        $this->add_control(
            'calfin_section_title',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'We are Concern
                with','calfincore' ),
              
            ]
        );
        $this->add_control(
            'calfin_section_title_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'calfincore' ),
                'description' => esc_html__( 'Add HTML Tag For Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h2',
                'options' => [
                    'h1'  => esc_html__( 'H1', 'calfincore' ),
                    'h2'  => esc_html__( 'H2', 'calfincore' ),
                    'h3'  => esc_html__( 'H3', 'calfincore' ),
                    'h4'  => esc_html__( 'H4', 'calfincore' ),
                    'h5'  => esc_html__( 'H5', 'calfincore' ),
                    'h6'  => esc_html__( 'H6', 'calfincore' ),
                    'p'  => esc_html__( 'P', 'calfincore' ),
                    'span'  => esc_html__( 'span', 'calfincore' ),
                    'div'  => esc_html__( 'Div', 'calfincore' ),
                ],
                
            ]
        );
        $this->add_control(
            'calfin_highlight_title',
            [
                'label' => esc_html__( 'High Light Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Finance','calfincore' ),
                
            ]
        );
        $this->add_control(
            'buttons_text',
            [
                'label'       => esc_html__( 'Buttn Text', 'calfincore' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'MORE SERVICES', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_link',
            [
                'label'       => esc_html__( 'Link', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'calfincore' ),
                'options'     => ['url', 'is_external', 'nofollow'],
                'default'     => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                    // 'custom_attributes' => '',
                ],
                'label_block' => true,
            ]
        );
        $this->end_controls_section();
        // START CSS
        $this->start_controls_section(
            'calfin_title_CSS',
            [
                'label' => esc_html__( 'Box Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_title_CSS_box_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .title-two-items' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_title_CSS_box_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .title-two-items' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();


       
// ==================================================
// ============== TITLE STYEL SECTION ================
// ==================================================

        $this->start_controls_section(
            'calfin_title_CSS_title',
            [
                'label' => esc_html__( 'Title Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'calfin_titles_tabs'
        );
        $this->start_controls_tab(
            'calfin_titles_tabs_stitle',
            [
                'label' => __( 'Small Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_section_stitle_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-section-stitle',
            ]
        );
        $this->add_responsive_control(
            'calfin_section_stitle_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_stitle_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_stitle_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'calfin_titles_tabs_title',
            [
                'label' => __( 'Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_section_title_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-t-title',
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_high_light_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .highlight-heading',
            ]
        );
        $this->add_responsive_control(
            'calfic_high_light_c',
            [
                'label' => esc_html__( 'High Light Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title .highlight-heading::after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        //==========================================//
        //=========== Button Style css ============//
        //========================================//

        $this->start_controls_section(
            'button_CSS_options',
            [
                'label' => esc_html__( 'Button CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'button_content_tabs'
        );
        $this->start_controls_tab(
            'button_normal',
            [
                'label' => __( 'Normal', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'border_text_typography',
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'button_background',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns',
            ]
        );
        $this->add_responsive_control(
            'button_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-button .theme-btns' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'button_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns',
            ]
        );
        $this->add_responsive_control(
            'button_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-button .theme-btns' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow',
                'label'    => esc_html__( 'Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns',
            ]
        );
        $this->add_responsive_control(
            'button_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-button .theme-btns' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-button .theme-btns' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover',
            [
                'label' => __( 'Hover', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'border_text_typography_hover',
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'button_background_hover',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns:hover',
            ]
        );
        $this->add_responsive_control(
            'button_color_hover',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-button .theme-btns:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'button_border_hover',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns:hover',
            ]
        );
        $this->add_responsive_control(
            'button_border_radius_hover',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-button .theme-btns:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow_hover',
                'label'    => esc_html__( 'Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-button .theme-btns:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        if( $settings['enable_container'] == 'yes' ){
            $container = 'container';
        }else{
            $container = 'container-fluid';
        }
        ob_start();
        ?>
        <div class="calfin-title-two-wrapper">
            <div class="<?php echo esc_attr($container)?>">
                <div class="title-two-items"> 
                    <div class="calfin-section-title">
                        <?php if(!empty($settings['calfin_section_stitle'])){
                            echo '<'.esc_attr($settings['calfin_section_stitle_tag']).' class="calfin-section-stitle">
                            <span>'.esc_html($settings['calfin_section_stitle']).'</span></'.esc_attr($settings['calfin_section_stitle_tag']).'>';
                        } ?>
                        <<?php echo esc_attr($settings['calfin_section_title_tag']); ?> class="calfin-t-title">
                            <?php echo wp_kses($settings['calfin_section_title'],'calfin_allowed_html'); ?>
                            <span class="highlight-heading"><?php echo esc_html($settings['calfin_highlight_title'])?></span>
                        </<?php echo esc_attr($settings['calfin_section_title_tag']); ?>>
                    </div>
                    <div class="tb-two calfin-button">
                        <?php if ( ! empty( $settings['button_link']['url'] ) ) {
                            $this->add_link_attributes( 'button_link', $settings['button_link'] );
                        } ?>
                        <a  <?php echo $this->get_render_attribute_string( 'button_link' ); ?> class="theme-btns"><?php echo esc_html($settings['buttons_text'])?></a>
                    </div>
                </div>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_title_two_Widget );
