<?php namespace Elementor;

class calfin_title_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_title';
    }

    public function get_title() {
        return esc_html__( 'Calfin Title', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_title_options',
            [
                'label' => esc_html__( 'calfin Title', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_section_stitle',
            [
                'label' => esc_html__( 'Small Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Who help us', 'calfincore' ),
            ]
        );
        $this->add_control(
            'calfin_section_stitle_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'calfincore' ),
                'description' => esc_html__( 'Add HTML Tag For Small Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h6',
                'options' => [
                    'h1'  => esc_html__( 'H1', 'calfincore' ),
                    'h2'  => esc_html__( 'H2', 'calfincore' ),
                    'h3'  => esc_html__( 'H3', 'calfincore' ),
                    'h4'  => esc_html__( 'H4', 'calfincore' ),
                    'h5'  => esc_html__( 'H5', 'calfincore' ),
                    'h6'  => esc_html__( 'H6', 'calfincore' ),
                    'p'  => esc_html__( 'P', 'calfincore' ),
                    'span'  => esc_html__( 'span', 'calfincore' ),
                    'div'  => esc_html__( 'Div', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'calfin_section_title',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Our Partners &','calfincore' ),
            ]
        );
        $this->add_control(
            'calfin_section_title_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'calfincore' ),
                'description' => esc_html__( 'Add HTML Tag For Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'h2',
                'options' => [
                    'h1'  => esc_html__( 'H1', 'calfincore' ),
                    'h2'  => esc_html__( 'H2', 'calfincore' ),
                    'h3'  => esc_html__( 'H3', 'calfincore' ),
                    'h4'  => esc_html__( 'H4', 'calfincore' ),
                    'h5'  => esc_html__( 'H5', 'calfincore' ),
                    'h6'  => esc_html__( 'H6', 'calfincore' ),
                    'p'  => esc_html__( 'P', 'calfincore' ),
                    'span'  => esc_html__( 'span', 'calfincore' ),
                    'div'  => esc_html__( 'Div', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'calfin_highlight_title',
            [
                'label' => esc_html__( 'High Light Title', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Donors','calfincore' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
			'eleble_des',
			[
				'label' => esc_html__( 'Enable Description', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		); 
        $this->add_control(
            'calfin_section_des',
            [
                'label' => esc_html__( 'Description', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, in culpa qui officia','calfincore' ),
                'condition' => [
                    'eleble_des' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        // START CSS
        $this->start_controls_section(
            'calfin_title_CSS',
            [
                'label' => esc_html__( 'Box Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_title_CSS_box_aligment',
            [
                'label' => __( 'Alignment', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-title' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .calfin_title_item .title-desc' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_title_CSS_box_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin_title_item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_title_CSS_box_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin_title_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_title_CSS_title',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'calfin_titles_tabs'
        );
        $this->start_controls_tab(
            'calfin_titles_tabs_stitle',
            [
                'label' => __( 'Small Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_section_stitle_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-section-stitle',
            ]
        );
        $this->add_responsive_control(
            'calfin_section_stitle_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_stitle_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_stitle_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-section-stitle span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'calfin_titles_tabs_title',
            [
                'label' => __( 'Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_section_title_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-t-title',
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_high_light_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .highlight-heading',
            ]
        );
        $this->add_responsive_control(
            'calfic_high_light_c',
            [
                'label' => esc_html__( 'High Light Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .highlight-heading' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_section_title_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-t-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'calfin_des_tabs',
            [
                'label' => __( 'Description', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'calfin_des_typo',
                'label' => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .title-desc',
            ]
        );
        $this->add_responsive_control(
            'calfin_des_color',
            [
                'label' => esc_html__( 'Color', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-desc' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_des_margin',
            [
                'label' => esc_html__( 'Margin', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .title-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_des_padding',
            [
                'label' => esc_html__( 'Padding', 'calfincore' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .title-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ob_start();
        ?>
        <div class="calfin-section-title-wrapper">
            <div class="calfin_title_item">
                <div class="calfin-section-title">
                    <?php if(!empty($settings['calfin_section_stitle'])){
                        echo '<'.esc_attr($settings['calfin_section_stitle_tag']).' class="calfin-section-stitle">
                        <span>'.esc_html($settings['calfin_section_stitle']).'</span></'.esc_attr($settings['calfin_section_stitle_tag']).'>';
                    } ?>
                    <<?php echo esc_attr($settings['calfin_section_title_tag']); ?> class="calfin-t-title">
                        <?php echo wp_kses($settings['calfin_section_title'],'calfin_allowed_html'); ?>
                        <span class="highlight-heading"><?php echo esc_html($settings['calfin_highlight_title'])?></span>
                    </<?php echo esc_attr($settings['calfin_section_title_tag']); ?>>
                </div>
                <?php if(!empty($settings['calfin_section_des'])):?>
                    <div class="calfin-section-description">
                        <p class="title-desc"> <?php echo esc_html($settings['calfin_section_des'])?> </p>
                    </div>
                <?php endif;?>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_title_Widget );
