<?php namespace Elementor;

class widget_name_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_widget';
    }

    public function get_title() {
        return esc_html__( 'calfin Widget', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-title';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_title_options',
            [
                'label' => esc_html__( 'calfin Widget', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
     
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ob_start();
        ?>
        <?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new widget_name_Widget );

