<?php 
if( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'calfin_nabber_widget', array(
        'title'       => esc_html__( 'Calfin: Banner Widget', 'calfincore' ),
        'classname'   => 'calfin-banner-widgets',
        'description' => esc_html__( 'Add Your Banner Info', 'calfincore' ),
        'fields'      => array(
            array(
                'id'      => 'title',
                'type'    => 'text',
                'default' => __( 'Work  Together', 'calfincore' ),
                'title'   => esc_html__( 'Title', 'calfincore' ),
            ),
            array(
                'id'      => 'calfin_banner_dec',
                'type'    => 'textarea',
                'title'   => esc_html__( 'Content', 'calfincore' ),
                'default' => __( 'Bur wemust ipsum dolor sit amet consectetur adipisicing elit sed eiusmod tempor incididunt ut labore', 'calfincore' ),
            ),
            array(
                'id'    => 'calfin_banner_link',
                'type'  => 'link',
                'title' => esc_html__( 'Link', 'calfincore' ),
            ),
            array(
                'id'      => 'calfin_banner_link_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Link Text', 'calfincore' ),
                'default' => __( 'Contact Now', 'calfincore' ),
            ),
            array(
                'id'           => 'calfin_banner_widget_bg',
                'type'         => 'upload',
                'title'        => esc_html__( 'Background/Image', 'calfincore' ),
                'library'      => 'image',
                'placeholder'  => 'http://',
                'button_title' => esc_html__( 'Add Image', 'calfincore' ),
                'remove_title' => esc_html__( 'Remove Image', 'calfincore' ),
            ),
        ),
    ) );

    // OutPut
    if ( !function_exists( 'calfin_nabber_widget' ) ) {
        function calfin_nabber_widget( $args, $instance ) {
            echo wp_kses_post( $args['before_widget'] );
            ?>
                <div class="calfin-widget-banner-wrapper" style="background-image:url(<?php echo esc_url( $instance['calfin_banner_widget_bg'] ); ?>)">
                    <?php if ( !empty( $instance['title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title widtet-title', $instance['title'] ) . wp_kses_post( $args['after_title'] );
            }?>
                    <div class="calfin-banner-dec">
                        <p><?php echo esc_html( $instance['calfin_banner_dec'] ); ?></p>
                    </div>
                    <div class="calfin-banner-btn">
                        <a href="<?php echo esc_url( $instance['calfin_banner_link']['url'] ); ?>"><?php echo esc_html( $instance['calfin_banner_link_text'] ); ?><i class="fas fa-angle-double-right"></i></a>
                    </div>
                </div>
            <?php
    echo wp_kses_post( $args['after_widget'] );
        }
    }
}