<?php 

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'calfin_contact_info_widget', array(
        'title'       => esc_html__( 'Calfin: Contact Info', 'calfincore' ),
        'classname'   => 'contact-widget',
        'description' => esc_html__( 'Add Your Contact Info', 'calfincore' ),
        'fields'      => array(
            array(
                'id'    => 'title',
                'type'  => 'text',
                'title' => esc_html__( 'Title', 'calfincore' ),
            ),
            array(
                'id'      => 'calfin_contact_info_group',
                'type'    => 'group',
                'title'   => esc_html__( 'Add Information', 'calfincore' ),
                'fields'  => array(
                    array(
                        'id'    => 'calfin_contact_info_editor',
                        'type'  => 'wp_editor',
                        'title' => esc_html__( 'Content', 'calfincore' ),
                    ),
                    array(
                        'id'    => 'calfin_contact_info_icons',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Icon', 'calfincore' ),
                    ),
                ),
                'default' => array(
                    array(
                        'calfin_contact_info_editor' => esc_html__( '1791 Yorkshire Circle Kitty Hawk, NC 27949', 'calfincore' ),
                        'calfin_contact_info_icons'  => 'fas fa-map-marker-alt',
                    ),
                    array(
                        'calfin_contact_info_editor' => esc_html__( 'Mon-Sat 9:00 - 7:00', 'calfincore' ),
                        'calfin_contact_info_icons'  => 'fas fa-clock',
                    ),
                    array(
                        'calfin_contact_info_editor' => esc_html__( '+012-345-6789', 'calfincore' ),
                        'calfin_contact_info_icons'  => 'fas fa-phone-alt',
                    ),
                    array(
                        'calfin_contact_info_editor' => esc_html__( 'info@example.com', 'calfincore' ),
                        'calfin_contact_info_icons'  => 'fas fa-envelope',
                    ),
                ),
            ),
        ),
    ) );
    // OutPut

    if ( !function_exists( 'calfin_contact_info_widget' ) ) {
        function calfin_contact_info_widget( $args, $instance ) {
            echo wp_kses_post( $args['before_widget'] );
            ?>
            <?php
            if ( !empty( $instance['title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title widtet-title', $instance['title'] ) . wp_kses_post( $args['after_title'] );
            }
            ?>
            <div class="company-contact-widget">
                <ul>
                <?php foreach ( $instance['calfin_contact_info_group'] as $calfin_contact_info ): ?>
                    <li><i class="<?php echo esc_attr( $calfin_contact_info['calfin_contact_info_icons'] ); ?>"></i><?php echo wp_kses_post( $calfin_contact_info['calfin_contact_info_editor'] ); ?></li>
                <?php endforeach;?>
                </ul>
            </div>
            <?php
        echo wp_kses_post( $args['after_widget'] );
        }
    }
}