<?php 

if( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'calfin_newsletter_widget', array(
        'title'       => esc_html__( 'Calfin: Newletter Widget', 'calfincore' ),
        'classname'   => 'subscribe-widget',
        'description' => esc_html__( 'Add Newsletter Info', 'calfincore' ),
        'fields'      => array(
            array(
                'id'      => 'title',
                'type'    => 'text',
                'default' => esc_html__( 'Newsletter', 'calfincore' ),
                'title'   => esc_html__( 'Title', 'calfincore' ),
            ),
            array(
                'id'      => 'newsletter_dec',
                'type'    => 'textarea',
                'title'   => esc_html__( 'Sort Description', 'calfincore' ),
                'desc'    => esc_html__( 'Add Sort Description', 'calfincore' ),
                'default' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipisicing', 'calfincore' ),
            ),
            array(
                'id'          => 'select_newsletter',
                'type'        => 'select',
                'title'       => esc_html__( 'Select Type', 'calfincore' ),
                'placeholder' => esc_html__( 'Select an option', 'calfincore' ),
                'options'     => array(
                    '1' => esc_html__( 'Shortcode form Plugin', 'calfincore' ),
                    '2' => esc_html__( 'Add Link', 'calfincore' ),
                ),
                'default'     => '2',
            ),
            array(
                'id'         => 'newsletter_shortcode',
                'type'       => 'textarea',
                'title'      => esc_html__( 'Add Shortcode', 'calfincore' ),
                'desc'       => esc_html__( 'Add Shortcode from Mailchip wordpress Plugin', 'calfincore' ),
                'dependency' => array( 'select_newsletter', '==', '1' ),
            ),
            array(
                'id'         => 'newsletter_link',
                'type'       => 'textarea',
                'title'      => esc_html__( 'Add Link', 'calfincore' ),
                'desc'       => esc_html__( 'Add Newsletter Link from your Account', 'calfincore' ),
                'dependency' => array( 'select_newsletter', '==', '2' ),
            ),
        ),
    ) );

    // OutPut
    if ( !function_exists( 'calfin_newsletter_widget' ) ) {
        function calfin_newsletter_widget( $args, $instance ) {
            echo wp_kses_post( $args['before_widget'] );
            if ( !empty( $instance['title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title widtet-title', $instance['title'] ) . wp_kses_post( $args['after_title'] );
            }
            ?>
            <div class="company-subscribe-widget">
                <?php if ( !empty( $instance['newsletter_dec'] ) ): ?>
                    <p>
                        <?php echo esc_html( $instance['newsletter_dec'] ); ?>
                    </p>
                <?php endif;?>
                <?php
                if ( $instance['select_newsletter'] == '1' ) {
                ?>
                    <div class="subscribe-form">
                        <?php echo do_shortcode( $instance['newsletter_shortcode'] ); ?>
                    </div>
                <?php
                } else {
                ?>
                <div class="subscribe-form">
                    <form action="<?php echo esc_url( $instance['newsletter_link'] ) ?>" method="post">
                        <div class="mc4wp-form-fields">
                            <input type="email" name="EMAIL" placeholder="<?php esc_attr_e( 'Your Email Address', 'calfincore' );?>" required="" />
                            <button value="submit" class="theme-btns"><?php esc_html_e( 'Send Now', 'calfincore' );?> <i class="fas fa-arrow-right"></i></button>
                        </div>
                    </form>
                </div>
                <?php
            }
            ?>
            </div>
            <?php
    echo wp_kses_post( $args['after_widget'] );
        }
    }
}