<?php
/*
Plugin Name: Calfin Core
Author: ThemePul
Author URI: https://www.templatemonster.com/authors/themepul/
Version: 1.0.1
Description: This plugin is required for calfin WordPress theme
Text Domain: calfincore
 */

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
define( 'CALFIN_CORE', WP_PLUGIN_URL . '/' . plugin_basename( dirname( __FILE__ ) ) . '/' );

// Translate direction
load_plugin_textdomain( 'calfincore', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

include_once 'elementor-widgets/custom-elements-for-elementor.php';

include_once 'inc/calfincore-functions.php';
include_once 'inc/demo.php';
include_once 'addon-icon.php';

/*
*  Add CSF
*/

 require_once('inc/library/codestar-framework/codestar-framework.php' );

/*
 * Register Custom Widget
 */
if ( class_exists( 'CSF' )){
	require_once('inc/widgets/custom-widgets.php' );
	include_once 'inc/icons.php';
}

$theme = wp_get_theme();
if ( 'Calfin' == $theme->name || 'Calfin' == $theme->parent_theme ) {
    include_once 'inc/wp-custom-posts.php';
}

// Registering toolkit files
function calfincore_files() {
    wp_enqueue_style( 'iconfont', plugin_dir_url( __FILE__ ) . 'assets/css/iconfont.css', array( 'bootstrap', 'bootstrap-rtl', 'bootstrap-icons', 'fontawesome-all', 'magnific-popup', 'slick', 'calfin-unitest' ), '1.0.0', 'all' );
    wp_enqueue_style( 'flaticon', plugin_dir_url( __FILE__ ) . 'assets/css/flaticon.css', array( 'bootstrap', 'bootstrap-rtl', 'bootstrap-icons', 'fontawesome-all', 'magnific-popup', 'slick', 'calfin-unitest' ), '1.0.0', 'all' );
    wp_enqueue_style( 'owl-css', plugin_dir_url( __FILE__ ) . 'assets/css/owl.css', array(), '2.2.0', 'all' );
    wp_enqueue_style( 'animate-min', plugin_dir_url( __FILE__ ) . 'assets/css/animate-min.css', array(), '2.2.0', 'all' );
    wp_enqueue_style( 'calfin-custom-widget', plugin_dir_url( __FILE__ ) . 'assets/css/custom-widgets.css', array( 'bootstrap', 'bootstrap-rtl', 'bootstrap-icons', 'fontawesome-all', 'magnific-popup', 'slick', 'calfin-unitest', 'calfin-theme', 'owl-css' ), '1.0.0', 'all' );
    wp_enqueue_script( 'calfin-count-js', plugin_dir_url( __FILE__ ) . 'assets/js/count-to.js', array( 'jquery' ), 1.0, true );
    wp_enqueue_script( 'calfin-appear-js', plugin_dir_url( __FILE__ ) . 'assets/js/jquery-appear.js', array( 'jquery' ), 1.0, true );
    wp_enqueue_script( 'isotop-min-js', plugin_dir_url( __FILE__ ) . 'assets/js/isotop-min.js', array( 'jquery' ), 3.6, true );
    wp_enqueue_script( 'owl-js', plugin_dir_url( __FILE__ ) . 'assets/js/owl.js', array( 'jquery' ), 2.2, true );
    wp_enqueue_script( 'progressbar-js', plugin_dir_url( __FILE__ ) . 'assets/js/progressbar.js', array( 'jquery' ), 1.2, true );
    wp_enqueue_script( 'counterup-js', plugin_dir_url( __FILE__ ) . 'assets/js/counterup.min.js', array( 'jquery' ), 1.2, true ); 

}
add_action( 'wp_enqueue_scripts', 'calfincore_files' );
/**
 * Enqueue Backend Styles And Scripts.
 **/
function calfin_backend_css_js( $screen ) {
    wp_enqueue_style( 'iconfont', plugin_dir_url( __FILE__ ) . 'assets/css/iconfont.css', array(), '1.0.0', 'all' );
    wp_enqueue_style( 'flaticon', plugin_dir_url( __FILE__ ) . 'assets/css/flaticon.css', array(), '1.0.0', 'all' );
}
add_action( 'admin_enqueue_scripts', 'calfin_backend_css_js' );
