<?php namespace Elementor;

class calfin_brand_widget extends Widget_Base {

    public function get_name() {

        return 'calfin_brand';
    }

    public function get_title() {
        return esc_html__( 'Calfin Brand Logo', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-person';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'brand_logo_options',
            [
                'label' => esc_html__( 'brand Brand Logo', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'brand_logo',
            [
                'label'   => esc_html__( 'Choose Image', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'brand_logo_enable_link',
            [
                'label'        => esc_html__( 'Enable Lilk', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
            ]
        );
        $repeater->add_control(
            'brand_link',
            [
                'label'       => esc_html__( 'Link', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'calfincore' ),
                'options'     => ['url', 'is_external', 'nofollow'],
                'default'     => [
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                    'custom_attributes' => false,
                ],
                'condition'   => [
                    'brand_logo_enable_link' => 'yes',
                ],
                'label_block' => true,
            ]
        );
        $this->add_control(
            'brand_logo_list',
            [
                'label'       => esc_html__( 'Logo List', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'list_title' => esc_html__( 'Logo List', 'calfincore' ),
                    ],
                    [
                        'list_title' => esc_html__( 'Logo List', 'calfincore' ),
                    ],
                    [
                        'list_title' => esc_html__( 'Logo List', 'calfincore' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );
        $this->add_control(
			'enable_container',
			[
				'label' => esc_html__( 'Enable Container', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
            'brand_section_setting',
            [
                'label' => esc_html__( 'brand Section Setting', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'calfin_slide_enable',
            [
                'label'        => esc_html__( 'Enable Slide', 'calfincore' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'calfincore' ),
                'label_off'    => esc_html__( 'Hide', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'yes',
            ]
        );
        $this->add_control(
            'enable_slide_loop',
            [
                'label'        => esc_html__( 'Enable Loop ', 'calfincore' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'On', 'calfincore' ),
                'label_off'    => esc_html__( 'Off', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'calfin_slide_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_slider_speed',
            [
                'label'     => esc_html__( 'Slide Speed', 'calfincore' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 500,
                'max'       => 8000,
                'step'      => 10,
                'default'   => 1000,
                'condition' => array(
                    'calfin_slide_enable' => 'yes',
                    'enable_slide_loop' => 'yes',
                ),
            ]
        );
        $this->add_control(
            'enable_slider_auto_loop',
            [
                'label'        => esc_html__( 'Enable Auto Loop ', 'calfincore' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'On', 'calfincore' ),
                'label_off'    => esc_html__( 'Off', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'calfin_slide_enable' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'calfin_auto_speed',
            [
                'label'     => esc_html__( 'Slide auto Speed', 'calfincore' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 500,
                'max'       => 8000,
                'step'      => 50,
                'default'   => 2000,
                'condition' => array(
                    'calfin_slide_enable'       => 'yes',
                    'enable_slider_auto_loop' => 'yes',
                ),
            ]
        );
        $this->add_control(
            'calfin_slidesToShow',
            [
                'label'     => esc_html__( 'Slides Show Item', 'calfincore' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 3,
                'max'       => 10,
                'step'      => 1,
                'default'   => 5,
                'condition' => array(
                    'calfin_slide_enable' => 'yes',
                ),
            ]
        );
        $this->add_control(
            'calfin_enable_dots',
            [
                'label'        => esc_html__( 'Enable Dots ', 'calfincore' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'On', 'calfincore' ),
                'label_off'    => esc_html__( 'Off', 'calfincore' ),
                'return_value' => 'yes',
                'default'      => 'no',
                'condition'    => [
                    'calfin_slide_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'desktop_col',
            [
                'label' => esc_html__( 'Columns On Desktop', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-xl-3',
                'options' => [
                    'col-xl-12'  => esc_html__( '1 Column', 'calfincore' ),
                    'col-xl-6'  => esc_html__( '2 Column', 'calfincore' ),
                    'col-xl-4'  => esc_html__( '3 Column', 'calfincore' ),
                    'col-xl-3'  => esc_html__( '4 Column', 'calfincore' ),
                ],
            ]
        );
        $this->add_responsive_control(
            'ipadpro_col',
            [
                'label' => esc_html__( 'Columns On Ipad Pro', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-lg-3',
                'options' => [
                    'col-lg-12'  => esc_html__( '1 Column', 'calfincore' ),
                    'col-lg-6'  => esc_html__( '2 Column', 'calfincore' ),
                    'col-lg-4'  => esc_html__( '3 Column', 'calfincore' ),
                    'col-lg-3'  => esc_html__( '4 Column', 'calfincore' ),
                ],
            ]
        );
        $this->add_responsive_control(
            'tab_col',
            [
                'label' => esc_html__( 'Columns On Tablet', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'col-md-3',
                'options' => [
                    'col-md-12'  => esc_html__( '1 Column', 'calfincore' ),
                    'col-md-6'  => esc_html__( '2 Column', 'calfincore' ),
                    'col-md-4'  => esc_html__( '3 Column', 'calfincore' ),
                    'col-md-3'  => esc_html__( '4 Column', 'calfincore' ),
                ],
            ]
        );
        $this->end_controls_section();

      

        //========================================//
        //========= BRAND BOX style Start==========//
        //========================================//

        $this->start_controls_section(
            'services_box',
            [
                'label' => esc_html__( 'Content Box', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'services_section_tabs'
        );
        $this->start_controls_tab(
            'services_section_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
			'box_align',
			[
				'label' => esc_html__( 'Alignment', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'calfincore' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'calfincore' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'calfincore' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .calfin-brand-wrapper' => 'text-align: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .calfin-brand-wrapper',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-brand-wrapper',
            ]
        );
        $this->add_responsive_control(
            'services_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-brand-wrapper',
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'box_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds_hover',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .calfin-brand-wrapper:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow_hover',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-brand-wrapper:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border_hover',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-brand-wrapper:hover',
            ]
        );

        $this->add_responsive_control(
            'border_radius_hover',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        // ================================//
        //======= brand section style====//
        //================================//

        $this->start_controls_section(
            'calfin_brand_style',
            [
                'label' => esc_html__( 'Item', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_bg_color',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-brand-items .brand-logo-item img' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_bg_hover_color',
            [
                'label'     => esc_html__( 'Background Hover Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-brand-items .brand-logo-item img:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-brand-items .brand-logo-item img',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'calfin_item_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-brand-items .brand-logo-item img',
            ]
        );
        $this->add_responsive_control(
            'calfin_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-items .brand-logo-item img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-items .brand-logo-item img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_padding_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-brand-items .brand-logo-item img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        if ( $settings['enable_container'] == 'yes' ) {
            $container = 'container';
        } else {
            $container = 'container-fluid';
        }
        $_id = rand( 1241, 3256 );
        if ( $settings['calfin_slide_enable'] == 'yes' ) {
            $col = 'brand-logo-item';
            $row = 'calfin-brand-items';
        ob_start();
            ?>

         <script>
            jQuery(document).ready(function($) {
                "use strict";
                $("#brand<?php echo esc_attr( $_id ) ?>").slick({
                    dots: <?php echo json_encode( $settings['calfin_enable_dots'] == 'yes' ? true : false ); ?>,
                    infinite: <?php echo json_encode( $settings['enable_slide_loop'] == 'yes' ? true : false ); ?>,
                    speed:<?php echo json_encode( $settings['calfin_slider_speed'] ); ?>,
                    autoplay: <?php echo json_encode( $settings['enable_slider_auto_loop'] == 'yes' ? true : false ); ?>,
                    autoplaySpeed: <?php echo json_encode( $settings['calfin_auto_speed'] ); ?>,
                    arrows: false,
                    slidesToShow: <?php echo json_encode( $settings['calfin_slidesToShow'] ); ?>,
                    slidesToScroll: 1,
                    responsive: [
                        {
                    breakpoint: 1023,
                    settings: {
                        slidesToShow: 4
                    }
                    },
																 {
                    breakpoint: 991,
                    settings: {
                        arrows: false,
                        centerMode: true,
						centerPadding: '40px',
                        slidesToShow: 3
						
                    }
                    },
                    {
                    breakpoint: 768,
                    settings: {
                        arrows: false,
                        centerMode: true,
						centerPadding: '40px',
                        slidesToShow: 2
                    }
                    },
                    {
                    breakpoint: 481,
                    settings: {
                        arrows: false,
                        centerMode: true,
						centerPadding: '40px',
                        slidesToShow: 1
                    }
                    }
                ]
                })
                });
            </script>
       <?php
        } else {
            $col = 'brand-logo-item col-12 col-sm-6 col-md-3 col-lg-3 ';
            $row = 'calfin-brand-items row';
            $brands = 'brands-logo';
        }?>
        <div class="calfin-brand-wrapper">
            <div class="<?php echo esc_attr( $container ); ?>">
                <div class="<?php echo esc_attr( $row ); ?>" id="brand<?php echo esc_attr( $_id ); ?>">
                    <?php foreach ( $settings['brand_logo_list'] as $item ): ?>
                        <div class="<?php echo esc_attr( $col ); ?>">
                            <?php 
                            if ( 'yes' === $item['brand_logo_enable_link'] ) :
                                $url      = $item['brand_link']['url'];
                                $target   = $item['brand_link']['is_external'] ? ' target="_blank"' : '';
                                $nofollow = $item['brand_link']['nofollow'] ? ' rel="nofollow"' : '';
                            ?>
                            <a href="<?php echo esc_url($url); ?>" <?php echo $target . $nofollow;?>><?php endif;?>
                                <?php echo wp_get_attachment_image( $item['brand_logo']['id'], 'full' ); ?>
                            <?php  if ( 'yes' === $item['brand_logo_enable_link'] ) :?></a><?php endif;?>
                        </div>
                    <?php endforeach;?>
                </div>
            </div>
        </div>
    <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_brand_widget );