<?php namespace Elementor;

class calfin_contact_info_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_contact_info';
    }

    public function get_title() {
        return esc_html__( 'calfin Contact', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-info-circle';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_contact_info_options',
            [
                'label' => esc_html__( 'calfin Contact Info', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'small_title',
            [
                'label'       => esc_html__( 'Small Title', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Contact Us', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'calfin_contact_info_hadding',
            [
                'label'      => esc_html__( 'Title', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::TEXTAREA,
                'default'    => esc_html__( 'Feel free to contact or reach us !!', 'calfincore' ),
                'show_label' => true,
            ]
        );
        $this->add_control(
            'calfin_contact_info_tag',
            [
                'label'       => esc_html__( 'HTML Tag', 'calfincore' ),
                'description' => esc_html__( 'Add HTML Tag For Title', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::SELECT,
                'default'     => 'h2',
                'options'     => [
                    'h1'   => esc_html__( 'H1', 'calfincore' ),
                    'h2'   => esc_html__( 'H2', 'calfincore' ),
                    'h3'   => esc_html__( 'H3', 'calfincore' ),
                    'h4'   => esc_html__( 'H4', 'calfincore' ),
                    'h5'   => esc_html__( 'H5', 'calfincore' ),
                    'h6'   => esc_html__( 'H6', 'calfincore' ),
                    'p'    => esc_html__( 'P', 'calfincore' ),
                    'span' => esc_html__( 'span', 'calfincore' ),
                    'div'  => esc_html__( 'Div', 'calfincore' ),
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();

         $repeater->add_control(
            'contact-icon',
            [
                'label'   => esc_html__( 'Icon', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'fas fa-phone-alt',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $repeater->add_control(
            'calfin_contact_info_label',
            [
                'label'       => esc_html__( 'Item Label', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Head office address :', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'calfin_contact_info_contact1',
            [
                'label'      => esc_html__( 'Content', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::WYSIWYG,
                'default'    => __( '+012-345-6789', 'calfincore' ),
                'show_label' => true,
            ]
        );
        $repeater->add_control(
            'calfin_contact_info_contact2',
            [
                'label'      => esc_html__( 'Content', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::WYSIWYG,
                'default'    => esc_html__( '467 Park Avenue New York,
                Ny 10 ', 'calfincore' ),
                'show_label' => true,
            ]
        );
        $this->add_control(
            'calfin_contact_info',
            [
                'label'   => esc_html__( 'Info List', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'calfin_contact_info_label'    => esc_html__( 'Head office address', 'calfincore' ),
                        'calfin_contact_info_contact1' => esc_html__( '+012-345-6789 ', 'calfincore' ),
                        'calfin_contact_info_contact2' => esc_html__( '467 Park Avenue New York,
                        Ny 10 ', 'calfincore' ),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_contact_info_CSS_options',
            [
                'label' => esc_html__( 'Box', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_box_align',
            [
                'label'     => esc_html__( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'calfincore' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'calfincore' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'calfincore' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .calfin-contact-info' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'calfin_contact_info_CSS_box_bg',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .calfin-contact-info',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'calfin_contact_info_CSS_box_shadwo',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-contact-info',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'calfin_contact_info_CSS_box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-contact-info',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_box_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-contact-info' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-contact-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-contact-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ===============================//
        // ==== ICON STYLE START ========
        //=================================//

        $this->start_controls_section(
            'calfin_contact_info_CSS_icon_options',
            [
                'label' => esc_html__( 'Icon', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon' => 'color: {{VALUE}}',
                   
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'calfin_contact_info_CSS_icon_bg',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_contact_info_CSS_icon_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon',
                'exclude'  => [
                    'letter_spacing',
                    'text_transform',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_icon_width',
            [
                'label'      => esc_html__( 'Width', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_icon_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_icon_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_icon_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_icon_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo .calfin-cinfo-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        ); 
		$this->add_control(
			'svg_options',
		[
			'label' => esc_html__( 'Svg Image Control', 'calfincore'),
			'type' => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		]
	);
        $this->add_responsive_control(
            'calfin_svg_width',
            [
                'label' => esc_html__( 'Width', 'calfincore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-cinfo-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_svg_height',
            [
                'label' => esc_html__( 'Height', 'calfincore'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                        'step' => 1,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .calfin-cinfo-icon svg' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        ); 
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_contact_info_CSS_content_options',
            [
                'label' => esc_html__( 'Content', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_CSS_content_item_margin',
            [
                'label'      => esc_html__( 'Item Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default'    => [
                    'top'      => '0',
                    'right'    => '0',
                    'bottom'   => '45',
                    'left'     => '0',
                    'isLinked' => true,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'calfin_contact_stitle_tabs'
        );
        $this->start_controls_tab(
            'calfin_contact_stitle_tab',
            [
                'label' => esc_html__( 'Small Title', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_stitle_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-small-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_contact_stitle_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .contact-small-title',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_stitle_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .contact-small-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_stitle_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .contact-small-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'calfin_contact_info_tabs_hadding',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_hadding_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-contact-info .contact-info-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_contact_info_hadding_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-contact-info .contact-info-title',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_hadding_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-contact-info .contact-info-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_hadding_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-contact-info .contact-info-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'calfin_contact_info_tabs_label',
            [
                'label' => esc_html__( 'Label', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_label_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-cinfo-dec .cinfo-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_contact_info_label_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-cinfo-dec .cinfo-title',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_label_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo-dec .cinfo-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_label_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-cinfo-dec .cinfo-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'calfin_contact_tabs_dec',
            [
                'label' => esc_html__( 'Content', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_dec_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cinfo-contact' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_contact_info_dec_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .cinfo-contact',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_dec_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .cinfo-contact' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_info_dec_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .cinfo-contact' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        ob_start();
        ?>
        <div class="calfin-contact-info-warpper">
            <div class="calfin-contact-info">
                <span class='contact-small-title'> <?php echo esc_html($settings['small_title'])?></span>
                <?php if(!empty($settings['calfin_contact_info_hadding'])){
                    echo '<'.esc_attr($settings['calfin_contact_info_tag']).' class="contact-info-title">'.esc_html($settings['calfin_contact_info_hadding']).'</'.esc_attr($settings['calfin_contact_info_tag']).'>';
                } ?>
                <div class="calfin-contact-info-items">
                    <?php foreach($settings['calfin_contact_info'] as $calfin_cinfo ) : ?>
                    <div class="calfin-cinfo d-flex align-items-center">
                        <div class="calfin-cinfo-icon">
                        <?php \Elementor\Icons_Manager::render_icon( $calfin_cinfo['contact-icon'], ['aria-hidden' => 'true'] );?>
                        </div>
                        <div class="calfin-cinfo-dec">
                            <h2 class="cinfo-title"> <?php echo esc_html($calfin_cinfo['calfin_contact_info_label']); ?></h2>
                            <span class="cinfo-contact"><?php echo  wp_kses_post($calfin_cinfo['calfin_contact_info_contact1']); ?></span>
                            <span class="cinfo-contact"><?php echo  wp_kses_post($calfin_cinfo['calfin_contact_info_contact2']); ?></span>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_contact_info_Widget );