<?php namespace Elementor;

class calfin_contact_list_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_contact_list';
    }

    public function get_title() {
        return esc_html__( 'calfin Contact List', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-site-identity';
    }

    public function get_categories() {
        return ['calfinhf'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_contact_list_options',
            [
                'label' => esc_html__( 'calfin Company Info', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_contact_list_align',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'default'   => 'left',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'calfin_contact_list_icon',
            [
                'label' => esc_html__( 'Icon', 'calfincore' ),
                'type'  => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $repeater->add_control(
            'calfin_contact_list_text',
            [
                'label'      => esc_html__( 'Textarea', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::TEXTAREA,
                'default'    => esc_html__( '1791 Yorkshire Circle Kitty Hawk, NC 27949', 'calfincore' ),
                'show_label' => true,
            ]
        );
        $this->add_control(
            'calfin_contact_lists',
            [
                'label'   => esc_html__( 'Slider List', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'calfin_contact_list_icon' => '',
                        'calfin_contact_list_text' => '',
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'calfin_contact_list__box_CSS_options',
            [
                'label' => esc_html__( 'Box Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_box_padding',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'calfin_contact_list_CSS_options',
            [
                'label' => esc_html__( 'Contact List', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_tabs_list_c',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'calfin_contact_list_CSS_tabs_list_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .company-info-widget ul li',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_tabs_list_m',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_tabs_list_p',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'calfin_contact_list_CSS_tabs_note',
            [
                'label'     => __( 'Icon CSS', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_bgcolor',
            [
                'label'     => esc_html__( 'Background Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_widgth',
            [
                'label'      => esc_html__( 'Icon Width', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 60,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_height',
            [
                'label'      => esc_html__( 'Icon Height', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 60,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_size',
            [
                'label'      => esc_html__( 'Icon Size', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 60,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_position',
            [
                'label'      => esc_html__( 'Icon Position', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -200,
                        'max'  => 200,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_contact_list_CSS_icon_radius',
            [
                'label'      => esc_html__( 'Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['%'],
                'range'      => [
                    '%' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .company-info-widget ul li i' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        if ( $settings['calfin_contact_list_align'] == 'right' ) {
            $right = 'fright';
        } else {
            $right = '';
        }
        ob_start();
        ?>
        <div class="calfin-company-info-wrapper">
            <div class="company-info-widget">
                <div class="company-contact-widget">
                    <ul>
                        <?php foreach( $settings['calfin_contact_lists'] as $info ) : ?>
                        <li>
                            <i class="<?php echo esc_attr($right); ?> <?php echo esc_attr($info['calfin_contact_list_icon']['value']); ?>"></i><?php echo esc_html($info['calfin_contact_list_text']); ?>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_contact_list_Widget );