<?php
namespace Elementor;

class calfin_dot_shape_Widget extends Widget_Base {

    public function get_name() {

        return 'calfin_dot_shape';
    }

    public function get_title() {
        return esc_html__( 'calfin Dot Shape', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-apps';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'calfin_dots_shape_options',
            [
                'label' => esc_html__( 'Animation', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'calfin_dots_animation_enable',
            [
                'label'     => esc_html__( 'Enable Animation', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Show', 'calfincore' ),
                'label_off' => esc_html__( 'Hide', 'calfincore' ),
            ]
        );
        $this->add_control(
            'calfin_dots_shape_select',
            [
                'label'     => esc_html__( 'Select Animation', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'shapeMover',
                'options'   => [
                    'shapeMover'        => esc_html__( 'Shape Mover', 'calfincore' ),
                    'bubbleMover'       => esc_html__( 'Bubble Mover', 'calfincore' ),
                    'bounce'            => esc_html__( 'Bounce', 'calfincore' ),
                    'zoomIn'            => esc_html__( 'ZoomIn', 'calfincore' ),
                    'flash'             => esc_html__( 'Flash', 'calfincore' ),
                    'pulse'             => esc_html__( 'Pulse', 'calfincore' ),
                    'rubberBand'        => esc_html__( 'Rubber Band', 'calfincore' ),
                    'shake'             => esc_html__( 'ShakeX', 'calfincore' ),
                    'fadeIn'            => esc_html__( 'FadeIn', 'calfincore' ),
                    'fadeInDown'        => esc_html__( 'FadeIn Down', 'calfincore' ),
                    'fadeInLeft'        => esc_html__( 'FadeIn Left', 'calfincore' ),
                    'fadeInRight'       => esc_html__( 'FadeIn Right', 'calfincore' ),
                    'fadeInUp'          => esc_html__( 'FadeIn Up', 'calfincore' ),
                    'fadeOut'           => esc_html__( 'FadeOut', 'calfincore' ),
                    'fadeOutDown'       => esc_html__( 'FadeOut Down', 'calfincore' ),
                    'fadeOutLeft'       => esc_html__( 'FadeOut Left', 'calfincore' ),
                    'fadeOutRight'      => esc_html__( 'FadeOut Right', 'calfincore' ),
                    'fadeOutUp'         => esc_html__( 'FadeOut Up', 'calfincore' ),
                    'flip'              => esc_html__( 'Flip', 'calfincore' ),
                    'flipInX'           => esc_html__( 'FlipInX', 'calfincore' ),
                    'flipInY'           => esc_html__( 'FlipInY', 'calfincore' ),
                    'rotateIn'          => esc_html__( 'RotateIn', 'calfincore' ),
                    'rotateInDownLeft'  => esc_html__( 'RotateIn Down Left', 'calfincore' ),
                    'rotateInDownRight' => esc_html__( 'RotateIn Down Right', 'calfincore' ),
                    'rotateInUpLeft'    => esc_html__( 'RotateIn Up Left', 'calfincore' ),
                    'rotateInUpRight'   => esc_html__( 'RotateIn Up Right', 'calfincore' ),
                    'rotateOut'         => esc_html__( 'Rotate Out', 'calfincore' ),
                    'hinge'             => esc_html__( 'Hinge', 'calfincore' ),
                    'slideInDown'       => esc_html__( 'SlideIn Down', 'calfincore' ),
                    'slideInLeft'       => esc_html__( 'SlideIn Left', 'calfincore' ),
                    'slideInRight'      => esc_html__( 'SlideIn Right', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .shapeanimation' => 'animation-name: {{VALUE}};',
                ],
                'condition' => [
                    'calfin_dots_animation_enable' => 'yes',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_dots_shape_duration',
            [
                'label'      => esc_html__( 'Animation Duration', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range'      => [
                    's' => [
                        'min'  => 0.1,
                        'max'  => 100,
                        'step' => 0.1,
                    ],
                ],
                'default'    => [
                    'unit' => 's',
                    'size' => 9,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .shapeanimation' => '-webkit-animation-duration: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .shapeanimation' => 'animation-duration: {{SIZE}}{{UNIT}};',
                ],
                'condition'  => [
                    'calfin_dots_animation_enable' => 'yes',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'calfin_dot_shape_CSS',
            [
                'label' => esc_html__( 'Dot Shape', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'calfin_dot_shape_width',
            [
                'label'      => esc_html__( 'Width', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['em', 'px'],
                'range'      => [
                    'em' => [
                        'min'  => 2,
                        'max'  => 200,
                        'step' => 1,
                    ],
                    'px' => [
                        'min'  => 10,
                        'max'  => 800,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'em',
                    'size' => 20,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .dot-shapes' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_dot_shape_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['em', 'px'],
                'range'      => [
                    'em' => [
                        'min'  => 2,
                        'max'  => 200,
                        'step' => 1,
                    ],
                    'px' => [
                        'min'  => 10,
                        'max'  => 800,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'em',
                    'size' => 20,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .dot-shapes' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_dot_shape_top',
            [
                'label'      => esc_html__( 'Position Top To Bottom', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -1000,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .dot-shapes.shape_dots' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_dot_shape_left',
            [
                'label'      => esc_html__( 'Position Left To Right', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -1000,
                        'max'  => 1000,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .dot-shapes.shape_dots' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'calfin_dot_shape_size',
            [
                'label'      => esc_html__( 'Dot Size', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 10,
                        'max'  => 40,
                        'step' => 1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 18,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .dot-shapes.shape_dots' => '-webkit-mask-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'calfin_dot_shape_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .dot-shapes.shape_dots' => 'background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();

        ob_start();
        ?>
        <div class="dot-shapes shape_dots dot-animate shapeanimation"></div>
        <?php
echo ob_get_clean();

    }
}
Plugin::instance()->widgets_manager->register( new calfin_dot_shape_Widget );