<?php namespace Elementor;

class calfin_progressbar_Widget extends Widget_Base {
    public function get_name() {

        return 'calfin_progressbar';
    }

    public function get_title() {
        return esc_html__( 'calfin Progressbar', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {

        //Content tab start
        $this->start_controls_section(
            'progressbar_options',
            [
                'label' => esc_html__( 'calfin Progress Bar', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();
        $repeater->add_control(
            'number',
            [
                'label'   => esc_html__( 'Circle Box Number', 'calfincore' ),
                'type'    => Controls_Manager::NUMBER,
                'min'     => 1,
                'max'     => 100,
                'step'    => 1,
                'default' => 80,
            ]
        );

        $repeater->add_control(
            'unit',
            [
                'label'   => __( 'Circle Box Unit', 'calfincore' ),
                'type'    => Controls_Manager::TEXT,
                'default' => '%',
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label'   => esc_html__( 'Title', 'calfincore' ),
                'type'    => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Flexible Solutions', 'calfincore' ),
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );
        $repeater->add_control(
            'circle_bg',
            [
                'label'   => esc_html__( 'Circle Background', 'calfincore' ),
                'type'    => Controls_Manager::COLOR,
                'default' => '#F0F4F9',
            ]
        );
        $repeater->add_control(
            'circle_fill_bg',
            [
                'label'   => esc_html__( 'Active Color', 'calfincore' ),
                'type'    => Controls_Manager::COLOR,
                'default' => '#5842BC',
            ]
        );

        $this->add_control(
            'list',
            [
                'label'       => __( 'Circle List', 'calfincore' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'title'  => 'Flexible Solutions',
                        'number' => 90,
                        'unit'   => '%',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $this->add_control(
            'desktop_col',
            [
                'label'     => __( 'Columns On Desktop', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'col-xl-3',
                'options'   => [
                    'col-xl-12' => __( '1 Column', 'calfincore' ),
                    'col-xl-6'  => __( '2 Column', 'calfincore' ),
                    'col-xl-4'  => __( '3 Column', 'calfincore' ),
                    'col-xl-3'  => __( '4 Column', 'calfincore' ),
                    'col-xl-2'  => __( '6 Column', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'laptop_col',
            [
                'label'     => __( 'Columns for Laptop', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'col-lg-4',
                'options'   => [
                    'col-lg-12' => __( '1 Column', 'calfincore' ),
                    'col-lg-6'  => __( '2 Column', 'calfincore' ),
                    'col-lg-4'  => __( '3 Column', 'calfincore' ),
                    'col-lg-3'  => __( '4 Column', 'calfincore' ),
                    'col-lg-2'  => __( '6 Column', 'calfincore' ),
                ],
            ]
        );

        $this->add_control(
            'tab_col',
            [
                'label'     => __( 'Columns On Tablet', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'col-md-6',
                'options'   => [
                    'col-md-12' => __( '1 Column', 'calfincore' ),
                    'col-md-6'  => __( '2 Column', 'calfincore' ),
                    'col-md-4'  => __( '3 Column', 'calfincore' ),
                    'col-md-3'  => __( '4 Column', 'calfincore' ),
                    'col-md-2'  => __( '6 Column', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'title_tag',
            [
                'label'   => __( 'Select Title Tag', 'calfincore' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'h2',
                'options' => [
                    'h1'   => __( 'H1', 'calfincore' ),
                    'h2'   => __( 'H2', 'calfincore' ),
                    'h3'   => __( 'H3', 'calfincore' ),
                    'h4'   => __( 'H4', 'calfincore' ),
                    'h5'   => __( 'H5', 'calfincore' ),
                    'h6'   => __( 'H6', 'calfincore' ),
                    'span' => __( 'Span', 'calfincore' ),
                    'p'    => __( 'P', 'calfincore' ),
                    'div'  => __( 'Div', 'calfincore' ),
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'progressbar_box_css',
            [
                'label' => esc_html__( 'Box CSS', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'rezilla_class_box_aligment',
            [
                'label'     => __( 'Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => __( 'Left', 'calfincore' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'calfincore' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => __( 'Right', 'calfincore' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'background',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box',
            ]
        );
        $this->add_responsive_control(
            'radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box',
            ]
        );
        $this->add_responsive_control(
            'margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'progressbar_title_css',
            [
                'label' => esc_html__( 'Content Style', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box .calfin-progress-title',
            ]
        );
        $this->add_responsive_control(
            'title_color',
            [
                'label'     => esc_html__( 'Title Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box .calfin-progress-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box .calfin-progress-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-progressbar-wrapper .calfin-progress-box .calfin-progress-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'more_options',
            [
                'label'     => esc_html__( 'Circle Content', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'circle_typo',
                'label'    => esc_html__( 'Typography', 'calfincore' ),
                'selector' => '{{WRAPPER}} .calfin-count-numbers span',
            ]
        );
        $this->add_responsive_control(
            'circle_color',
            [
                'label'     => esc_html__( 'Number', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-count-numbers .calfin-count-number' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'circle_unit_color',
            [
                'label'     => esc_html__( 'Unit Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .calfin-count-numbers .unit' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'circle_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-count-numbers span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'circle_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .calfin-count-numbers span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
		$column = $settings['desktop_col'] . ' ' . $settings['laptop_col'] . ' ' . $settings['tab_col'];
        $count_id = rand( 100, 10000 );

        ob_start();
        ?>
        <div class="calfin-progressbar-wrapper">
            <div class="row">
                <?php
				$bar_number = 0;
				foreach ( $settings['list'] as $bar ):
					$bar_number++;
					if ( $bar['number'] == 100 ) {
						$output_number = 1;
					} else if ( $bar['number'] < 10 ) {
					$output_number = '.0' . $bar['number'];
				} else {
					$output_number = '.' . $bar['number'];
				}
				?>
                <div class="<?php echo esc_attr($column);?> col-12">
                    <div class="calfin-progress-inner" id="circle-wrapper-id-<?php echo $count_id . $bar_number; ?>">
                        <div class="calfin-progress-box">
                            <div class="calfin-circle-progress-items">
                                <div class="calfin-circle-progress-item">
                                    <div id="bar-<?php echo $count_id . $bar_number; ?>"></div>
                                    <div class="calfin-count-numbers">
                                        <span class="calfin-count-number"><?php echo esc_html( $bar['number'] ); ?></span>
                                        <span class="unit"><?php echo esc_html( $bar['unit'] ); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="calfin-progress-content">
                                <<?php echo esc_attr( $settings['title_tag'] ); ?> class="calfin-progress-title"><?php echo esc_html( $bar['title'] ); ?></<?php echo esc_attr( $settings['title_tag'] ); ?>>
                            </div>

                        </div>
                    </div>
                </div>
                <script>
            (function ($) {
                "use strict";
                jQuery(document).ready(function ($) {
                    $('#bar-<?php echo $count_id . $bar_number; ?>').circleProgress({
                        value: "<?php echo $output_number; ?>",
                        size: 100,
                        lineCap: "round",
                        emptyFill: "<?php echo $bar['circle_bg']; ?>",
                        thickness: "7",
                        fill: { color: "<?php echo $bar['circle_fill_bg']; ?>"}
                    });
                });
            }(jQuery));
        </script>
                <?php endforeach;?>

            </div>
        </div>
        <?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_progressbar_Widget );