<?php namespace Elementor;

class ptoject_details_widget extends Widget_Base {

    public function get_name() {

        return 'calfin_project_details_page';
    }

    public function get_title() {
        return esc_html__( 'Calfin project Details', 'calfincore' );
    }

    public function get_icon() {

        return 'eicon-kit-details';
    }

    public function get_categories() {
        return ['calfin'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'ricp_project_options',
            [
                'label' => esc_html__( 'Calfin project Info', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'name_label', [
                'label'       => esc_html__( 'Label', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Name', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'title', [
                'label'       => esc_html__( 'Title', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => esc_html__( 'Title', 'calfincore' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'project_details_list',
            [
                'label'       => esc_html__( 'Repeater List', 'calfincore' ),
                'type'        => \Elementor\Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'name_label' => esc_html__( 'Client Name', 'calfincore' ),
                        'title'      => esc_html__( 'Alex jhonthan', 'calfincore' ),
                    ],
                    [
                        'name_label' => esc_html__( 'Date', 'calfincore' ),
                        'title'      => esc_html__( '11/11/2022', 'calfincore' ),
                    ],
                    [
                        'name_label' => esc_html__( 'Locatin', 'calfincore' ),
                        'title'      => esc_html__( 'NY Canada', 'calfincore' ),
                    ],
                    [
                        'name_label' => esc_html__( 'Project value', 'calfincore' ),
                        'title'      => esc_html__( '10000$', 'calfincore' ),
                    ],

                ],
                'title_field' => '{{{ name_label }}}',
            ]
        );
        $this->add_control(
			'enable_container',
			[
				'label' => esc_html__( 'Enable Container', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
            'desktop_col',
            [
                'label'     => __( 'Columns On Desktop', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'col-xl-3',
                'options'   => [
                    'col-xl-12' => __( '1 Column', 'calfincore' ),
                    'col-xl-6'  => __( '2 Column', 'calfincore' ),
                    'col-xl-4'  => __( '3 Column', 'calfincore' ),
                    'col-xl-3'  => __( '4 Column', 'calfincore' ),
                    'col-xl-2'  => __( '6 Column', 'calfincore' ),
                ],
            ]
        );
        $this->add_control(
            'laptop_col',
            [
                'label'     => __( 'Columns for Laptop', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'col-lg-3',
                'options'   => [
                    'col-lg-12' => __( '1 Column', 'calfincore' ),
                    'col-lg-6'  => __( '2 Column', 'calfincore' ),
                    'col-lg-4'  => __( '3 Column', 'calfincore' ),
                    'col-lg-3'  => __( '4 Column', 'calfincore' ),
                    'col-lg-2'  => __( '6 Column', 'calfincore' ),
                ],
            ]
        );

        $this->add_control(
            'tab_col',
            [
                'label'     => __( 'Columns On Tablet', 'calfincore' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'col-md-6',
                'options'   => [
                    'col-md-12' => __( '1 Column', 'calfincore' ),
                    'col-md-6'  => __( '2 Column', 'calfincore' ),
                    'col-md-4'  => __( '3 Column', 'calfincore' ),
                    'col-md-3'  => __( '4 Column', 'calfincore' ),
                    'col-md-2'  => __( '6 Column', 'calfincore' ),
                ],
            ]
        );
        $this->end_controls_section();

        // ===============================================
        // =========== IMAGE STYLE CSS ===================
        // ===============================================

        $this->start_controls_section(
            'box_tab',
            [
                'label' => esc_html__( 'Box Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .project-details-item',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .project-details-item',
            ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ===============================================
        // =========== IMAGE STYLE CSS ===================
        // ===============================================

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__( 'Image Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' =>1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item .project-datails-img img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item .project-datails-img img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'object',
            [
                'label' => esc_html__( 'Object Fit', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__( 'Fill', 'calfincore' ),
                    'contain' => esc_html__( 'Contain', 'calfincore' ),
                    'cover' => esc_html__( 'Cover', 'calfincore' ),
                    'none' => esc_html__( 'None', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .project-details-item .project-datails-img img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .project-details-item .project-datails-img img',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item .project-datails-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item .project-datails-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-item .project-datails-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // ==============================//
        // ====== STYLE START ==========//
        // ==============================//

        $this->start_controls_section(
            'calfin_project_details_box',
            [
                'label' => esc_html__( 'Inner Box Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'project_details_alignment',
            [
                'label'     => esc_html__( 'Content Alignment', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'calfincore' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'calfincore' ),
                        'icon'  => 'eicon-text-align-center',
                    ],

                    'right'  => [
                        'title' => esc_html__( 'Right', 'calfincore' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'default'   => 'center',
                'toggle'    => true,
                'selectors' => [
                    '{{WRAPPER}} .project-details-content' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'project_details_bg',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .project-details-content',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'project_details_box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'calfincore' ),
                'selector' => '{{WRAPPER}} .project-details-content',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'project_details_box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .project-details-content',
            ]
        );
        $this->add_responsive_control(
            'project_details_box_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'project_details_box_section_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'project_details_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-details-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        // =====================================//
        // ========== PROJECT DETAILS INFO ========//
        //=====================================//

        $this->start_controls_section(
            'calfin_project_details',
            [
                'label' => esc_html__( 'Content Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'project_content_tabs'
        );
        $this->start_controls_tab(
            'project_title_tab',
            [
                'label' => esc_html__( 'Label', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typo',
                'selector' => '{{WRAPPER}} .project-name',
            ]
        );
        $this->add_responsive_control(
            'name_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'name_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'name_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_title_tab',
            [
                'label' => esc_html__( 'Value', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'project_title_typo',
                'selector' => '{{WRAPPER}} .project-d-title',
            ]
        );
        $this->add_responsive_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .project-d-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-d-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-d-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'inner_box_padding',
            [
                'label'      => esc_html__( 'Inner Box Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .project-d-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .project-meddile-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        $column = $settings['desktop_col'] . ' ' . $settings['laptop_col'] . ' ' . $settings['tab_col'];
        $calfin_id = get_the_ID();
        $calfin_team_meta = get_post_meta( $calfin_id, 'calfin_project', true );
        if ( $settings['enable_container'] == 'yes' ) {
            $container = 'container';
        } else {
            $container = 'container-fluid';
        }
        ob_start();
        ?>
        <div class="project-details-wraper">
            <div class="<?php echo esc_attr( $container ); ?>">
                <div class="project-details-item">
                    <div class="project-datails-img">
                        <?php the_post_thumbnail( 'full', array( 'class' => 'img-responsive' ) );?>
                    </div>
                    <div class="project-details-content">
                        <div class="row">
                            <?php $count = 0;foreach ( $settings['project_details_list'] as $item ): $count++;
                                if ( $count == 1 || $count == 2 || $count == 3  ) {
                                    $meddile = 'project-meddile-item';
                                } else {
                                    $meddile = '';
                                }?> 
                                    <div class="<?php echo esc_attr($column); ?>">
                                    <div class="project-d-item <?php echo esc_attr( $meddile ) ?>">
                                        <span class="project-name"><?php echo esc_html( $item['name_label'] ) ?></span>
                                        <h4 class="project-d-title"><?php echo esc_html( $item['title'] ) ?></h4>
                                    </div>
                                </div>
                            <?php endforeach;?>
                        </div>
                    </div>
                </div>
            </div>
         </div>
	<?php
echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new ptoject_details_widget );