<?php namespace Elementor;

class calfin_team_details_widget extends Widget_Base {

    public function get_name() {

        return 'calfin_team_info';
    }

    public function get_title() {
        return esc_html__( 'Calfin Team Details', 'calfincore' );
    }

    public function get_icon() {

        return ' eicon-person';
    }

    public function get_categories() {
        return ['calfin'];
    }
	
    protected function register_controls() {

        $this->start_controls_section(
			'team_single_section',
			[
				'label' => esc_html__( 'Team Section Style', 'calfincore' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'enable_container',
			[
				'label' => esc_html__( 'Enable Container', 'calfincore' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'calfincore' ),
				'label_off' => esc_html__( 'Hide', 'calfincore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->start_controls_tabs(
            'team_content_tabs'
        );
		$this->start_controls_tab(
            'team_box_tab',
            [
                'label' => esc_html__( 'Box', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'box_backgrounds',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .team-info-wrapper',
            ]
        );
		 $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'team_box_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .team-info-wrapper',
            ]
        );
		$this->add_responsive_control(
            'team_box_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		 $this->add_responsive_control(
            'team_box_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_box_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'team_image_tab',
            [
                'label' => esc_html__( 'image', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
            'image_height',
            [
                'label'      => esc_html__( 'Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' =>1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .team-image img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_width',
            [
                'label'      => esc_html__( 'width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 800,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'selectors'  => [
                    '{{WRAPPER}} .team-image img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'object',
            [
                'label' => esc_html__( 'Object Fit', 'calfincore' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'  => esc_html__( 'Fill', 'calfincore' ),
                    'contain' => esc_html__( 'Contain', 'calfincore' ),
                    'cover' => esc_html__( 'Cover', 'calfincore' ),
                    'none' => esc_html__( 'None', 'calfincore' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .team-image img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .team-image img',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_section_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();


        $this->start_controls_section(
            'team_details_content',
            [
                'label' => esc_html__( 'Calfin Info', 'calfincore' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'team_details_title_tabs'
        );
        $this->start_controls_tab(
            'team_title_tab',
            [
                'label' => esc_html__( 'Title', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typo',
                'selector' => '{{WRAPPER}} .team-title',
            ]
        );
        $this->add_responsive_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'team_designation_tab',
            [
                'label' => esc_html__( 'Desiganation', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'team_designation_typo',
                'selector' => '{{WRAPPER}} .team-designation',
            ]
        );
        $this->add_responsive_control(
            'team_designation_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-designation' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_designation_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_designation_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'team_des_tab',
            [
                'label' => esc_html__( 'Description', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'team_des_typo',
                'selector' => '{{WRAPPER}} .team-sort-dec',
            ]
        );
        $this->add_responsive_control(
            'team_des_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-sort-dec' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_des_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-sort-dec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_des_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-sort-dec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
                
        //==============================================//
        //========= SOCIAL ADDRESS STYLE START ========//
        //============================================//

        $this->start_controls_tabs(
            'label_tabs'
        );
        
        $this->start_controls_tab(
            'label_tab',
            [
                'label' => esc_html__( 'Label', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'label_typo',
                'selector' => '{{WRAPPER}} .team-info-list-wrapper .info-label',
            ]
        );
        $this->add_responsive_control(
            'label_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-info-list-wrapper .info-label' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'label_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-list-wrapper .info-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'label_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-list-wrapper .info-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'address_tab',
            [
                'label' => esc_html__( 'Address', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'team_info_typo',
                'selector' => '{{WRAPPER}} .team-info-list-wrapper ul li',
            ]
        );
        $this->add_responsive_control(
            'team_info_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-info-list-wrapper ul li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_info_Margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-list-wrapper ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_info_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-info-list-wrapper ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

        
        //==============================================//
        //========= SOCIAL SECTION STYLE START ========//
        //============================================//

		$this->start_controls_section(
            'calfin_social_icon_style',
            [
                'label' => esc_html__( 'Team Social Icon Style', 'calfincore' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'social_icon_tabs'
        );
        $this->start_controls_tab(
            'social_icon_tab',
            [
                'label' => esc_html__( 'Icon Normal', 'calfincore' ),
            ]
        );
        $this->add_responsive_control(
			'gap',
			[
				'label' => esc_html__( 'Gap', 'calfincore' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 2,
						'max' => 60,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .team-social-area' => 'margin-top: {{SIZE}}{{UNIT}}',
				],
				'separator' => 'before',
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'social_icons_typo',
                'selector' => '{{WRAPPER}} .team-social-area ul li a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'team_social_icon_backgrounds',
                'label'    => esc_html__( 'Background', 'calfincore' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .team-social-area ul li a',
            ]
        );
      
        $this->add_responsive_control(
            'tean_social_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-social-area ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_socials_icon_height',
            [
                'label'      => esc_html__( 'Icon Height', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'team_social_icon_width',
            [
                'label'      => esc_html__( 'Icon Width', 'calfincore' ),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a' => 'Width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'social_icons_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .team-social-area ul li a',
            ]
        );
        $this->add_responsive_control(
            'social_icons_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_icons_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_icons_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_description_tab',
            [
                'label' => esc_html__( 'Icon Hover', 'calfincore' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'     => 'social_icon_typo',
                'selector' => '{{WRAPPER}} .team-social-area ul li a:hover',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'     => 'team_social_backgrounds',
                'types' => [ 'classic', 'gradient', 'video' ],
                'types'    => ['gradient', 'video'],
                'selector' => '{{WRAPPER}} .team-social-area ul li a:hover',
            ]
        );
      
        $this->add_responsive_control(
            'social_icon_color',
            [
                'label'     => esc_html__( 'Color', 'calfincore' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-social-area ul li a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'social_icon_border',
                'label'    => esc_html__( 'Border', 'calfincore' ),
                'selector' => '{{WRAPPER}} .team-social-area ul li a:hover',
            ]
        );
        $this->add_responsive_control(
            'social_icon_border_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_icon_margin',
            [
                'label'      => esc_html__( 'Margin', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'social_icon_padding',
            [
                'label'      => esc_html__( 'Padding', 'calfincore' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .team-social-area ul li a:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    //Render
    protected function render() {
        $settings = $this->get_settings_for_display();
        $calfin_id = get_the_ID();
        $calfin_team_meta = get_post_meta($calfin_id, 'calfin_teammeta', true);
        if ( $settings['enable_container'] == 'yes' ) {
            $container = 'container';
        } else {
            $container = 'container-fluid';
        }
        ob_start();
		?>
        <div class="team_section_wraper">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                        <div class="team-image">
                        <?php echo the_post_thumbnail('full', array('class' => 'img-responsive')); ?>
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-6 col-sm-12 col-12">
                        <div class="team-info-wrapper">
                            <div class="team-title-wrapper">
                                <h5 class="team-title"><?php the_title(); ?></h5>
                                <?php if(!empty($calfin_team_meta['calfin_team_stitle'])) : ?>
                                <h4 class="team-designation"><?php echo esc_html($calfin_team_meta['calfin_team_stitle']); ?></h4>
                                <?php endif; ?>
                            </div>
                            <?php if(!empty($calfin_team_meta['calfin_team_sort_dec'])) : ?>
                            <div class="team-sort-dec">
                                <?php echo wp_kses_post($calfin_team_meta['calfin_team_sort_dec']); ?>
                            </div>
                            <?php endif; ?>
                            <?php if(!empty($calfin_team_meta['calfin_team_info'])) : ?>
                                <div class="team-info-list-wrapper">
                                    <ul>
                                        <?php foreach($calfin_team_meta['calfin_team_info'] as $info ) : ?>
                                        <li><label class="info-label"><?php echo esc_html($info['calfin_team_info_label']); ?></label>
                                        <?php echo wp_kses_post($info['calfin_team_info_content']); ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            <?php endif;  ?>
                            <?php if(!empty($calfin_team_meta['calfin_team_socials'])) :?>
                                <div class="team-social-area">
                                    <ul>
                                        <?php foreach($calfin_team_meta['calfin_team_socials'] as $social ) : ?>
                                            <li><a href="<?php echo esc_url($social['calfin_team_social_link']['url']); ?>" target="<?php echo esc_attr($social['calfin_team_social_link']['target']); ?>" class="">
                                            <i class="<?php echo esc_attr($social['calfin_teams_socials_icon']); ?>"></i></a></li>
                                        <?php endforeach; ?>
                                    </ul>                           
                                </div>
                            <?php endif?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	<?php
        echo ob_get_clean();
    }
}
Plugin::instance()->widgets_manager->register( new calfin_team_details_widget );