<?php 

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'calfin_company_info_widget', array(
        'title'       => esc_html__( 'Calfin: Company Info', 'calfincore' ),
        'classname'   => 'calfin_company_info_widget',
        'description' => esc_html__( 'Add Your Company Info', 'calfincore' ),
        'fields'      => array(
            array(
                'id'    => 'title',
                'type'  => 'text',
                'title' => esc_html__( 'Title', 'calfincore' ),
            ),
            array(
                'id'      => 'cinfo_img_enable',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Logo', 'calfincore' ),
                'default' => false,
            ),
    
            array(
                'id'          => 'cinfo_img',
                'type'        => 'media',
                'title'       => esc_html__( 'Upload Logo', 'calfincore' ),
                'library'     => 'image',
                'preview'     => true,
                'placeholder' => 'http://',
                'dependency'  => array( 'cinfo_img_enable', '==', 'true' ), // check for true/false by field id
            ),
            array(
                'id'      => 'calfin_conpany_info_dec',
                'type'    => 'textarea',
                'title'   => esc_html__( 'Content', 'calfincore' ),
                'default' => esc_html__( 'Lorem ipsum dolor sit amet elit consectetur adipisicing sed do eiusmod tempor incididunt et dolore elit labore', 'calfincore' ),
            ),
            array(
                'id'      => 'cinfo_social_enable',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Social', 'calfincore' ),
                'default' => false,
            ),
            array(
                'id'         => 'calfin_company_info_group',
                'type'       => 'group',
                'title'      => esc_html__( 'Social Info', 'calfincore' ),
                'dependency' => array( 'cinfo_social_enable', '==', 'true' ),
                'fields'     => array(
                    array(
                        'id'    => 'calfin_coinfo_gdec',
                        'type'  => 'text',
                        'title' => esc_html__( 'Social Link', 'calfincore' ),
                    ),
                    array(
                        'id'    => 'calfin_coinfo_gicon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Social Icon', 'calfincore' ),
                    ),
                ),
                'default'    => array(
                    array(
                        'calfin_coinfo_gdec'  => 'facebook.com',
                        'calfin_coinfo_gicon' => 'fab fa-facebook-f',
                    ),
                    array(
                        'calfin_coinfo_gdec'  => 'twitter.com',
                        'calfin_coinfo_gicon' => 'fab fa-twitter',
                    ),
                    array(
                        'calfin_coinfo_gdec'  => 'linkedin.com',
                        'calfin_coinfo_gicon' => 'fab fa-linkedin-in',
                    ),
                    array(
                        'calfin_coinfo_gdec'  => 'instagram.com',
                        'calfin_coinfo_gicon' => 'fab fa-instagram',
                    ),
                ),
            ),
        ),
    ) );
    
    // OutPut
    
    if ( !function_exists( 'calfin_company_info_widget' ) ) {
        function calfin_company_info_widget( $args, $instance ) {
            echo wp_kses_post( $args['before_widget'] );
            ?>
    
            <?php
              if ( !empty( $instance['title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title widtet-title', $instance['title'] ) . wp_kses_post( $args['after_title'] );
            }
    
            ?>
            <div class="company-info-widget">
                <?php if ( $instance['cinfo_img_enable'] == true ):
                $logo = $instance['cinfo_img'];
                ?>
                        <div class="conpany-info-img">
                            <img src="<?php echo esc_url( $logo['url'] ); ?>" alt="<?php esc_html_e( 'calfin by Themepul', 'calfincore' );?>">
                        </div>
                    <?php endif;?>
                <p><?php echo esc_html( $instance['calfin_conpany_info_dec'] ); ?></p>
                <?php if ( !empty( $instance['calfin_company_info_group'] && $instance['cinfo_social_enable'] == true ) ): ?>
                <div class="social-icons company-socials-icon">
                    <ul>
                    <?php foreach ( $instance['calfin_company_info_group'] as $calfin_cinfo ): ?>
                        <li><a href="<?php echo esc_url( $calfin_cinfo['calfin_coinfo_gdec'] ); ?>"><i class="<?php echo esc_attr( $calfin_cinfo['calfin_coinfo_gicon'] ); ?>"></i></a></li>
                        <?php endforeach;?>
                    </ul>
                </div>
                <?php endif;?>
            </div>
            <?php
          echo wp_kses_post( $args['after_widget'] );
        }
    }
}