<?php 
if( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'calfin_blog_post_widget', array(
        'title'       => esc_html__( 'Calfin: Post With Thumbnail', 'calfincore' ),
        'classname'   => 'footer-widget-post-with-thum',
        'description' => esc_html__( 'Add your Contact Info', 'calfincore' ),
        'fields'      => array(
            array(
                'id'    => 'title',
                'type'  => 'text',
                'title' => esc_html__( 'Title', 'calfincore' ),
            ),
            array(
                'id'      => 'calfin_widget_blog_position',
                'type'    => 'select',
                'title'   => esc_html__( 'Select Options', 'calfincore' ),
                'options' => array(
                    'ASC'  => esc_html__( 'ASC', 'calfincore' ),
                    'DESC' => esc_html__( 'DESC', 'calfincore' ),
                ),
                'default' => 'ASC',
            ),
            array(
                'id'      => 'calfin_widget_blog_number',
                'type'    => 'number',
                'title'   => esc_html__( 'Show Post', 'calfincore' ),
                'default' => 2,
            ),
            array(
                'id'      => 'calfin_widget_blog_show_meta',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Meta', 'calfincore' ),
                'default' => true,
            ),
            array(
                'id'      => 'calfin_widget_blog_show_image',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Enable Image', 'calfincore' ),
                'default' => true,
            ),
            array(
                'id'      => 'calfin_widget_blog_text_limit',
                'type'    => 'number',
                'title'   => esc_html__( 'Title Text Limit', 'calfincore' ),
                'default' => 5,
            ),
        ),
    ) );

    // OutPut

    if ( !function_exists( 'calfin_blog_post_widget' ) ) {
        function calfin_blog_post_widget( $args, $instance ) {
            echo wp_kses_post( $args['before_widget'] );
            if ( !empty( $instance['title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title widtet-title', $instance['title'] ) . wp_kses_post( $args['after_title'] );
            }
            ?>
            <ul class="calfin-widget-post-thum">
                <?php
                $post_q = new WP_Query( array(
                'post_type'      => 'post',
                'posts_per_page' => $instance['calfin_widget_blog_number'],
                'order'          => $instance['calfin_widget_blog_position'],
            ) );
            if ( $post_q->have_posts() ):
                while ( $post_q->have_posts() ):
                    $post_q->the_post();
                ?>
                <li>
                    <?php if ( !empty( $instance['calfin_widget_blog_show_image'] == true ) ) {
                    the_post_thumbnail( 'thumbnail' );
                    }?>
                    <div class="calfin-widget-post-thum-content">
                        <h6><a class="recent-post-title" href="<?php echo esc_url( get_permalink() ); ?>"><?php echo wp_trim_words( get_the_title(), $instance['calfin_widget_blog_text_limit'] ); ?></a></h6>
                        <?php if ( !empty( $instance['calfin_widget_blog_show_meta'] == true ) ): ?>
                        <div class="recent-widget-date">
                            <?php echo get_the_date() ?>
                        </div>
                        <?php endif;?>
                    </div>
                </li>
                        <?php endwhile;endif;?>
            </ul>
            <?php
    echo wp_kses_post( $args['after_widget'] );
        }
    }
}