<?php 
if( class_exists( 'CSF' ) ) {
    CSF::createWidget( 'calfin_social_widget', array(
        'title'       => esc_html__( 'Calfin: Social Widget', 'calfincore' ),
        'classname'   => 'calfin-social-widgets social-icons',
        'description' => esc_html__( 'Add Your Social Info', 'calfincore' ),
        'fields'      => array(
            array(
                'id'    => 'title',
                'type'  => 'text',
                'title' => esc_html__( 'Title', 'calfincore' ),
            ),
            array(
                'id'      => 'calfin_socials_widget',
                'type'    => 'group',
                'title'   => esc_html__( 'Add Social Links', 'calfincore' ),
                'fields'  => array(
                    array(
                        'id'    => 'calfin_social_label',
                        'type'  => 'text',
                        'title' => esc_html__( 'Name', 'calfincore' ),
                    ),
                    array(
                        'id'    => 'calfin_social_link',
                        'type'  => 'text',
                        'title' => esc_html__( 'Site Link', 'calfincore' ),
                    ),
                    array(
                        'id'    => 'calfin_social_icon',
                        'type'  => 'icon',
                        'title' => esc_html__( 'Site Icon', 'calfincore' ),
                    ),
                ),
                'default' => array(
                    array(
                        'calfin_social_label' => esc_html__( 'Facebook', 'calfincore' ),
                        'calfin_social_link'  => '#',
                        'calfin_social_icon'  => 'fab fa-facebook',
                    ),
                    array(
                        'calfin_social_label' => esc_html__( 'Twitter', 'calfincore' ),
                        'calfin_social_link'  => '#',
                        'calfin_social_icon'  => 'fab fa-twitter',
                    ),
                    array(
                        'calfin_social_label' => esc_html__( 'Linkedin', 'calfincore' ),
                        'calfin_social_link'  => '#',
                        'calfin_social_icon'  => 'fab fa-linkedin',
                    ),
                    array(
                        'calfin_social_label' => esc_html__( 'Instagram', 'calfincore' ),
                        'calfin_social_link'  => '#',
                        'calfin_social_icon'  => 'fab fa-instagram',
                    ),
                ),
            ),
        ),
    ) );

    // OutPut
    if ( !function_exists( 'calfin_social_widget' ) ) {
        function calfin_social_widget( $args, $instance ) {
            echo wp_kses_post( $args['before_widget'] );
            if ( !empty( $instance['title'] ) ) {
                echo wp_kses_post( $args['before_title'] ) . apply_filters( 'widget_title widtet-title', $instance['title'] ) . wp_kses_post( $args['after_title'] );
            }
            ?>
                <ul>
                <?php foreach ( $instance['calfin_socials_widget'] as $social ) {
                echo ' <li><a href="' . esc_url( $social['calfin_social_link'] ) . '" data-toggle="tooltip" data-placement="top" title="' . esc_attr( $social['calfin_social_label'] ) . '"><i class="' . esc_attr( $social['calfin_social_icon'] ) . '"></i></a></li>';
            }
            ?>
                </ul>
            <?php
    echo wp_kses_post( $args['after_widget'] );
        }
    }
}