<?php

if ( !function_exists( 'calfin_options' ) ) {
    function calfin_options( $option = '', $default = null ) {
        $defaults = calfin_default_theme_options();
        $options = get_option( 'calfin_Theme_Option' );
        $default = ( !isset( $default ) && isset( $defaults[$option] ) ) ? $defaults[$option] : $default;
        return ( isset( $options[$option] ) ) ? $options[$option] : $default;
    }
}
add_action( 'init', 'calfin_custom_post_type' );
function calfin_custom_post_type() {
    register_post_type( 'calfin_project',
        array(
            'labels'       => array(
                'name'          => esc_html__( 'Project', 'calfincore' ),
                'singular_name' => esc_html__( 'Project', 'calfincore' ),
            ),
            'show_in_rest' => true,
            'supports'     => array( 'title', 'thumbnail', 'page-attributes', 'editor', 'excerpt' ),
            'menu_icon'    => esc_attr__( 'dashicons-image-filter', 'calfincore' ),
            'public'       => true,
            'rewrite'      => array(
                'slug'       => calfin_options( 'calfin_project_custom_slug' ),
                'with_front' => true,
            ),
        )
    );
    register_post_type( 'calfin_team',
        array(
            'labels'       => array(
                'name'          => esc_html__( 'Team', 'calfincore' ),
                'singular_name' => esc_html__( 'Team', 'calfincore' ),
            ),
            'show_in_rest' => true,
            'supports'     => array( 'title', 'thumbnail', 'page-attributes', 'editor', 'excerpt' ),
            'menu_icon'    => esc_attr__( 'dashicons-admin-users', 'calfincore' ),
            'public'       => true,
            'rewrite'      => array(
                'slug'       => calfin_options( 'calfin_team_custom_slug' ),
                'with_front' => true,
            ),
        )
    );
   
}
/*** Custom taxonomy ***/
add_action( 'init', 'calfin_custom_post_taxonomy' );
function calfin_custom_post_taxonomy() {
    register_taxonomy(
        'calfin_project_cat',
        'calfin_project',
        array(
            'label'             => esc_html__( 'Project Category', 'calfincore' ),
            'query_var'         => true,
            'hierarchical'      => true,
            'public'            => true,
            'show_ui'           => true,
            'show_admin_column' => true,
            'show_in_nav_menus' => true,
            'show_in_rest'      => true,
            'show_tagcloud'     => true,
            'rewrite'           => array(
                'slug'       => 'project-category',
                'with_front' => true,
            ),
        )
    );
}