<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package calfin
 */

get_header();
$calfin_error_page_banner = calfin_options( 'calfin_error_page_banner', true );
$calfin_error_page_title = calfin_options( 'calfin_error_page_title' );
$calfin_breadcrumb_select_html = calfin_options( 'calfin_breadcrumb_select_html', 'h2' );
$calfin_error_image = calfin_options( 'calfin_error_image' );
$calfin_not_found_text = calfin_options( 'calfin_not_found_text' );
$calfin_go_back_home = calfin_options( 'calfin_go_back_home', true );
$calfin_error_page_button_text = calfin_options( 'calfin_error_page_button_text', esc_html( 'Go Back', 'calfin' ) );
?>
<?php if ( $calfin_error_page_banner == true ): ?>
	<div class="breadcroumb-area">
		<div class="container">
			<div class="breadcroumn-contnt">
				<<?php echo esc_attr( $calfin_breadcrumb_select_html ); ?> class="brea-title">
				<?php if ( !empty( $calfin_error_page_title ) ) {
						echo esc_html( $calfin_error_page_title );
					} ?>
				</<?php echo esc_attr( $calfin_breadcrumb_select_html ); ?>>
				<div class="bre-sub">
				<?php if ( function_exists( 'bcn_display' ) ) {
					bcn_display();
				}?>
				</div>
			</div>
		</div>
	</div>
<?php endif;?>
	<main id="primary" class="site-main">
		<div class="container error-404 not-found">
			<div class="row justify-content-center">
				<div class="col-12 col-sm-12 col-md-10 col-xl-8 col-lg-8">
					<div class="page-content">
						<?php if ( !empty( $calfin_error_image['url'] ) ): ?>
						<div class="error-image">
							<img src="<?php echo esc_url( $calfin_error_image['url'] ); ?>" alt="<?php echo esc_attr( $calfin_error_image['alt'] ) ?>">
						</div>
						<?php endif;?>
						<div class="error-dec">
							<?php echo wp_kses( $calfin_not_found_text, 'calfin_allowed_html' ); ?>
						</div>
						<?php if ( $calfin_go_back_home == true ): ?>
							<div class="error-button">
							<a class="theme-btns" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html( $calfin_error_page_button_text ); ?></a>
							</div>
						<?php endif;?>
					</div><!-- .page-content -->
				</div>
			</div>
		</div>
	</main><!-- #main -->

<?php
get_footer();
