<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package calfin
 */
if(is_page() || is_singular('post') || is_singular('calfin_project') || is_singular('calfin_event') || is_singular('calfin_team') && get_post_meta( $post->ID, 'calfin_metabox', true)) {
	$calfinMeta = get_post_meta($post->ID, 'calfin_metabox', true);
} else {
	$calfinMeta = array();
}
$calfin_footer_styles = calfin_options('calfin_footer_styles');
$calfin_enable_top_to_bottom = calfin_options('calfin_enable_top_to_bottom', true);
$calfin_enable_ttb_icon = calfin_options('calfin_enable_ttb_icon','fa fa-angle-up');
if (is_array($calfinMeta) && array_key_exists('calfin_meta_footer_styles', $calfinMeta) && array_key_exists('calfin_meta_footer_style_shwo', $calfinMeta) && $calfinMeta['calfin_meta_footer_style_shwo'] == true && get_post_meta($post->ID, 'calfin_metabox', true) ) {
	$selectedFooter = $calfinMeta['calfin_meta_footer_styles'];
}elseif (!empty($calfin_footer_styles) && class_exists( 'CSF' )) {
	$selectedFooter = calfin_options('calfin_footer_styles');
}else {
	$selectedFooter = 'one';
} 
if ( is_active_sidebar( 'footer-1') || class_exists( 'CSF' ) ){
	$active_widgets = 'widget-yes';
}else{
	$active_widgets ='widget-no';
}
?>
	<footer id="colophon" class="site-footer footer-<?php echo esc_attr($selectedFooter); ?>">
		<div class="footer-widget-area <?php echo esc_attr($active_widgets); ?>">
			<?php 
			get_template_part('inc/footer/footer','widgets');
			get_template_part('inc/footer/copyright');
			?>
		</div>
		<?php  ?>
	</footer><!-- #colophon -->
	<?php if($calfin_enable_top_to_bottom == true ) : ?><div class="to-top" id="back-top"><i class="<?php echo esc_attr($calfin_enable_ttb_icon); ?>"></i></div><?php endif; ?>
</div><!-- #page -->
<?php wp_footer(); ?>
</body>
</html>