<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package calfin
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php 
	if(is_page() || is_singular('post') || is_singular('calfin_project') || is_singular('calfin_event') || is_singular('calfin_team') && get_post_meta($post->ID, 'calfin_metabox', true)) {
        $calfinMeta = get_post_meta($post->ID, 'calfin_metabox', true);
    } else {
        $calfinMeta = array();
    }
    $calfin_enable_preloader = calfin_options('calfin_enable_preloader', true);
    $calfin_header_styles = calfin_options('calfin_header_styles');
    if (is_array($calfinMeta) && array_key_exists('calfin_meta_select_header', $calfinMeta) && $calfinMeta['calfin_meta_select_header'] != 'default' && $calfinMeta['calfin_meta_enable_header'] == true ) {
        $selectedHeader = $calfinMeta['calfin_meta_select_header'];
    } else if (!empty($calfin_header_styles) && class_exists( 'CSF' )) {
        $selectedHeader = calfin_options('calfin_header_styles');
    } else {
        $selectedHeader = 'default';
    }
	wp_head(); 
    ?>
    
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site <?php echo esc_attr($selectedHeader == 'two' ? 'header-v2' : 'header-v1'); ?>">
    <?php if($calfin_enable_preloader == true ) { ?>
    <div class="preloader-area">
        <div class="preloader-inner">
			<div class="theme-loader"></div>
		</div>
    </div>
    <?php } ?>
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'calfin' ); ?></a>
	<?php get_template_part( 'inc/header/header-'.$selectedHeader.'' ); ?>