<?php 
/**
 * Enqueue scripts and styles.
 */
function calfin_scripts() {
	global $wp_query;
	wp_enqueue_style('bootstrap', get_theme_file_uri('assets/bootstrap/bootstrap-min.css'), array(),  CALFIN_VERSION, 'all');
	wp_enqueue_style('bootstrap-rtl', get_theme_file_uri('assets/bootstrap/bootstrap-rtl-min.css'), array(),  CALFIN_VERSION, 'all');
	wp_enqueue_style('bootstrap-icons', get_theme_file_uri('assets/bootstrap/bootstrap-icons.css'), array(),  CALFIN_VERSION, 'all');
	wp_enqueue_style('magnific-popup', get_theme_file_uri('assets/popup/magnific-popup.css'), array(), CALFIN_VERSION , 'all');
	wp_enqueue_style('slick', get_theme_file_uri('assets/slick/slick.css'), array(), CALFIN_VERSION , 'all');
	wp_enqueue_style('calfin-unitest', get_theme_file_uri('assets/css/unitest.css'), array(), CALFIN_VERSION , 'all');
	wp_enqueue_style('calfin-theme', get_theme_file_uri('assets/css/theme.css'), array(), CALFIN_VERSION , 'all');
	wp_enqueue_style('fontawesome-all', get_theme_file_uri('assets/css/fontawesome-all.css'), array(),  CALFIN_VERSION , 'all');
	wp_enqueue_style('calfin-style', get_stylesheet_uri(), array(), CALFIN_VERSION, 'all');
	wp_style_add_data( 'calfin-style', 'rtl', 'replace' );
	if( !class_exists( 'CSF' ) ) {
		wp_enqueue_style( 'calfin-inter-fonts', 'Inter:wght@100;200;300;400;500;600;700;800;900', '', CALFIN_VERSION, 'screen' );
	}
	//Enqueue scripts.
	wp_enqueue_script('popper', get_theme_file_uri('assets/bootstrap/popper-min.js'), array(),  CALFIN_VERSION, true);
	wp_enqueue_script('bootstrap', get_theme_file_uri('assets/bootstrap/bootstrap-min.js'), array(), CALFIN_VERSION, true);
	wp_enqueue_script('jquery-magnific-popup', get_theme_file_uri('assets/popup/jquery-magnific-popup-min.js'), array('jquery'), CALFIN_VERSION , true);
	wp_enqueue_script('slick-min', get_theme_file_uri('assets/slick/slick-min.js'), array(), CALFIN_VERSION , true);
	wp_enqueue_script('calfin-theme', get_theme_file_uri('assets/js/theme.js'), array('jquery'), CALFIN_VERSION , true);
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'calfin_scripts' );
?>