<?php
// ----- Mobile Logo Option---------
$mobile_logo  = calfin_options('mobile_logo');
// ----------
$calfin_logo1 = calfin_options('calfin_logo1');

$calfin_enable_sticky_menu1 = calfin_options( 'calfin_enable_sticky_menu1' );
if ( $calfin_enable_sticky_menu1 == true ) {
    $sticky = 'sticky-menu';
} else {
    $sticky = 'no-sticky';
}
$call_us_enable = calfin_options('call_us_enable');
$call_us_option = calfin_options('call_us_option');

//  -----------Button -------------
$calfin_cta_show = calfin_options( 'calfin_cta_show' );
$calfin_cta_text = calfin_options( 'calfin_cta_text' );
$calfin_cta_link = calfin_options( 'calfin_cta_link' );
?>
    <!--==============================
    Mobile Menu
  ============================== -->
  <div class="ot-menu-wrapper">
        <div class="ot-menu-area text-center">
            <button class="ot-menu-toggle">X</button>
            <div class="mobile-logo">
				<?php
					if(!empty($mobile_logo['url'])){
						$mobile_logoUrl = $mobile_logo['url'];
						?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img src="<?php echo esc_url($mobile_logoUrl); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>" title="<?php echo esc_attr($mobile_logo['title']) ?>">
						</a>
				<?php
					}elseif(!empty($calfin_logo1['url'])){
						$logoUrl = $calfin_logo1['url'];
						?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img src="<?php echo esc_url($logoUrl); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>" title="<?php echo esc_attr($calfin_logo1['title']) ?>">
						</a>
						<?php 
					}elseif(has_custom_logo()){
						the_custom_logo();
					}else{
						?>
						<h2>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
								<?php esc_html(bloginfo( 'name' )); ?>
							</a>
						</h2>
						<?php 
					}
				?>
            </div>
            <div class="ot-mobile-menu">
					<?php
						wp_nav_menu(
							array(
								'container'      => false,
								'theme_location' => 'mainmenu',
								'menu_id'        => 'mainmenu',
								'menu_class'     => '',
								'echo'           => true,
								'fallback_cb'    => 'calfin_Nav_Walker::fallback',
								'walker'         => new calfin_Nav_Walker,
							)
						);
					?>
            </div>
        </div>
    </div>
<!--==============================
	Header Area
==============================-->
<header class="ot-header header-one">
	<div class="sticky-wrapper" id="<?php echo esc_attr( $sticky ); ?>">
		<div class="menu-area ">
			<div class="container-fluid">
				<div class="row align-items-center justify-content-between">
					<div class="header-logo col-auto">
					<div class="header-logo-bg">
					<?php
							if(!empty($calfin_logo1['url'])){
								$logoUrl = $calfin_logo1['url'];
								?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<img src="<?php echo esc_url($logoUrl); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>" title="<?php echo esc_attr($calfin_logo1['title']) ?>">
								</a>
								<?php 
							}elseif(has_custom_logo()){
								the_custom_logo();
							}else{
								?>
								<h2>
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
										<?php esc_html(bloginfo( 'name' )); ?>
									</a>
								</h2>
								<?php 
							}
                        ?>
					</div>
					</div>
					<div class="col-auto">
						<nav class="main-menu d-none d-lg-inline-block">
						<?php
								wp_nav_menu(
									array(
										'container'      => false,
										'theme_location' => 'mainmenu',
										'menu_id'        => 'mainmenu',
										'echo'           => true,
										'fallback_cb'    => 'calfin_Nav_Walker::fallback',
										'walker'         => new calfin_Nav_Walker,
									)
								);
							?>
						</nav>
						<button type="button" class="ot-menu-toggle d-inline-block d-lg-none"><i class="fas fa-bars"></i></button>
					</div>
					
					<div class="col-auto d-none d-xl-block">
						<?php if( $calfin_cta_show == true ) : ?>
							<div class="header-button">
								<a href="<?php echo esc_url($calfin_cta_link['url']); ?>" class=" theme-btns" target="<?php echo esc_attr($calfin_cta_link['target']);?>" > <span> <?php echo esc_html($calfin_cta_text); ?> </span></a>
							</div>
						<?php endif; ?>
						<?php if( $call_us_enable == true ) : ?>
							<div class="header-call-us">
								<div class="header-call-box">
									<?php if(!empty( $call_us_option['call_us_icon'])) : ?>
									<div class="icon">
										<i class="<?php  echo esc_attr( $call_us_option['call_us_icon'] );?>"></i>
									</div>
									<?php endif; ?>
									<div class="call-text-box">
										<?php if(!empty($call_us_option['call_us_link']['url'])){
											$call_link = $call_us_option['call_us_link']['url'];
										}else{
											$call_link = '';
										} ?>
										<a href="<?php echo esc_url( $call_link ); ?>">
											<?php if(!empty($call_us_option['phone_number_text'])) : ?>
												<div class="call-number"><?php echo esc_html($call_us_option['phone_number_text']); ?></div>
											<?php endif; ?>
											<?php if(!empty($call_us_option['call_us_text'])) : ?>
												<div class="call-text"><?php echo esc_html($call_us_option['call_us_text']); ?></div>
											<?php endif; ?>
										</a>
									</div>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>