<?php
// ----- Mobile Logo Option---------
$mobile_logo  = calfin_options('mobile_logo2');
// -------
$calfin_top_header2_group = calfin_options('calfin_top_header2_group');
$join_us_button_text = calfin_options('join_us_button_text');
$join_us_button_link = calfin_options('join_us_button_link');
$calfin_enable_sticky_menu2 = calfin_options( 'calfin_enable_sticky_menu2' );
$calfin_join_enable  = calfin_options( 'join_us_button_enable' );
if ( $calfin_enable_sticky_menu2 == true ) {
    $sticky = 'sticky-header';
} else {
    $sticky = 'no-sticky';
}

if ( is_page() || is_singular( 'post' ) || is_singular( 'calfin_portfolio' ) || is_singular( 'calfin_team' ) && get_post_meta( get_the_ID(), 'calfin_metabox', true ) ) {
    $calfinMeta = get_post_meta( get_the_ID(), 'calfin_metabox', true );
} else {
    $calfinMeta = array();
}
// HEADER TOP 
?>
   <!--==============================
    Mobile Menu
  ============================== -->
  <div class="ot-menu-wrapper">
        <div class="ot-menu-area text-center">
            <button class="ot-menu-toggle">X</button>
            <div class="mobile-logo">
				<?php
					if(!empty($mobile_logo['url'])){
						$mobile_logoUrl = $mobile_logo['url'];
						?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img src="<?php echo esc_url($mobile_logoUrl); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>" title="<?php echo esc_attr($mobile_logo['title']) ?>">
						</a>
				<?php
					}elseif(!empty($calfin_logo1['url'])){
						$logoUrl = $calfin_logo1['url'];
						?>
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
							<img src="<?php echo esc_url($logoUrl); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>" title="<?php echo esc_attr($calfin_logo1['title']) ?>">
						</a>
						<?php 
					}elseif(has_custom_logo()){
						the_custom_logo();
					}else{
						?>
						<h2>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
								<?php esc_html(bloginfo( 'name' )); ?>
							</a>
						</h2>
						<?php 
					}
				?>
            </div>
            <div class="ot-mobile-menu">
					<?php
						wp_nav_menu(
							array(
								'container'      => false,
								'theme_location' => 'mainmenu',
								'menu_id'        => 'mainmenu',
								'menu_class'     => '',
								'echo'           => true,
								'fallback_cb'    => 'calfin_Nav_Walker::fallback',
								'walker'         => new calfin_Nav_Walker,
							)
						);
					?>
            </div>
        </div>
    </div>

<header class="site-header header-two ot-header">
	<div class="header-top-section primary-bg">
		<div class="container">
			<div class="header-top-box">
				<div class="header-top-info list-style-none">
					<ul>
						<?php foreach( $calfin_top_header2_group['calfin_top_header_info2'] as $info ) : ?>
                        <li>
                            <?php if(!empty($info['calfin_topbar_info_icon2'])) : ?>
                                <i class="<?php  echo esc_attr($info['calfin_topbar_info_icon2']);?>"></i>
                            <?php endif; ?>
                            <?php if(!empty($info['calfin_topbar_info2'])) : ?>
                                <?php echo wp_kses($info['calfin_topbar_info2'],'calfin_allowed_html');?>
                            <?php endif; ?>
                        </li>
						<?php endforeach; ?>  
					</ul>
				</div>
				<?php if( $calfin_top_header2_group['calfin_top_header_social2']) : ?>
				<div class="header-top-social list-style-none">
					<ul>
					<?php foreach( $calfin_top_header2_group['calfin_top_header_social2'] as $social ) : ?>
						<li>
                            <a href="<?php  echo esc_url($social['calfin_social_link_2']['url']); ?>">  
                                <i class="<?php echo esc_attr($social['calfin_topbar_social_icon_2']); ?>"></i>
                            </a> 
                        </li>
					<?php endforeach;?>
					</ul>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
    <div class="main-header" id="<?php echo esc_attr($sticky); ?>">
		<div class="container">
			<nav class="navbar navbar-light main-navigation" id="site-navigation">
				<div class="logo-area">
					<div class="site-branding">
					<?php
						if(!empty(is_array($calfinMeta) && array_key_exists('calfin_meta_select_logo', $calfinMeta)) && $calfinMeta['calfin_meta_select_logo'] == true && !empty($calfinMeta['calfin_meta_logo']['url'])){
							?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
								<img src="<?php echo esc_url($calfinMeta['calfin_meta_logo']['url']); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>">
							</a>
							<?php 
						}elseif(has_custom_logo()){
							the_custom_logo();
						}else{
							$calfin_ShowLogo = calfin_options('calfin_show_hlogo2');
							$calfin_logo = calfin_options('calfin_logo2');
							if( $calfin_ShowLogo == true && !empty($calfin_logo['url'])){
								$calfin_logoUrl = $calfin_logo['url'];?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<img src="<?php echo esc_url($calfin_logoUrl); ?>" alt="<?php esc_attr(bloginfo( 'name' )); ?>">
								</a>
							<?php }else{ ?>
								<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php }
						}
						?>
					</div><!-- .site-branding -->
				</div>
				<div class="main-menu d-none d-lg-inline-block">
					<?php
					if (!empty(is_array($calfinMeta) && array_key_exists('calfin_meta_select_menu', $calfinMeta) &&  $calfinMeta['calfin_meta_enable_header_menu'] == true) ) {
						$selectedmenu = $calfinMeta['calfin_meta_select_menu'];
					}else{
						$selectedmenu = '';
					}
					wp_nav_menu(
						array(
							'container'      => false,
							'theme_location' => 'mainmenu',
							'menu_id'        => 'mainmenu',
							'echo'           => true,
							'fallback_cb'    => 'calfin_Nav_Walker::fallback',
							'walker'         => new calfin_Nav_Walker,
						)
					);
					?>
				</div>
				<button type="button" class="ot-menu-toggle d-inline-block d-lg-none"><i class="fas fa-bars"></i></button>
				<?php if( $calfin_join_enable == true ) : ?>
				<div class="header-button">
					<a href="<?php echo esc_url($join_us_button_link['url']); ?>" target="<?php echo esc_url($join_us_button_link['target']); ?>" class="theme-btns"><?php echo esc_html($join_us_button_text); ?></a>
				</div>
				<?php endif; ?>
			</nav>
		</div>
	</div>
</header>