<?php

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

//
// Metabox of the PAGE
// Set a unique slug-like ID
//
$calfinmetabox = 'calfin_metabox';

//
// Create a metabox
//
CSF::createMetabox( $calfinmetabox, array(
    'title'        => 'Metabox Options',
    'post_type'    => array( 'page', 'post', 'calfin_project', 'calfin_team' ),
    'show_restore' => true,
) );

//
// Create a section
//
CSF::createSection( $calfinmetabox, array(
    'title'  => esc_html__( 'Header', 'calfin' ),
    'icon'   => 'fas fa-rocket',
    'fields' => array(
        array(
            'id'       => 'calfin_meta_enable_header',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Header', 'calfin' ),
            'subtitle' => esc_html__( 'Enable this Options if you need', 'calfin' ),
        ),
        array(
            'id'          => 'calfin_meta_select_header',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Header Style', 'calfin' ),
            'placeholder' => esc_html__( 'Select an option', 'calfin' ),
            'options'     => array(
                'one'   => esc_html__( 'Header One', 'calfin' ),
                'two'   => esc_html__( 'Header Two', 'calfin' ),
                'three' => esc_html__( 'Header Three', 'calfin' ),
            ),
            'dependency'  => array( 'calfin_meta_enable_header', '==', 'true' ),
        ),
        array(
            'id'       => 'calfin_meta_enable_header_menu',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Header Menus', 'calfin' ),
            'subtitle' => esc_html__( 'Enable this Options if you need', 'calfin' ),
        ),
        array(
            'id'          => 'calfin_meta_select_menu',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Menu', 'calfin' ),
            'placeholder' => esc_html__( 'Select an option', 'calfin' ),
            'options'     => 'menus',
            'dependency'  => array( 'calfin_meta_enable_header_menu', '==', 'true' ),
        ),
        array(
            'id'       => 'calfin_meta_select_logo',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Specific Logo', 'calfin' ),
            'subtitle' => esc_html__( 'Enable Specific Logo Options', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_meta_logo',
            'type'       => 'media',
            'title'      => esc_html__( 'Specific Logo', 'calfin' ),
            'subtitle'   => esc_html__( '  Upload Specific Logo for page, post, Custom Post', 'calfin' ),
            'library'    => 'image',
            'dependency' => array( 'calfin_meta_select_logo', '==', 'true' ),
        ),

    ),
) );

// Create layout section
CSF::createSection( $calfinmetabox, array(
    'title'  => esc_html__( 'Layout', 'calfin' ),
    'icon'   => 'fas fa-rocket',
    'fields' => array(
        array(
            'id'          => 'calfin_layout_meta',
            'type'        => 'select',
            'title'       => esc_html__( 'Layout', 'calfin' ),
            'placeholder' => esc_html__( 'Select an option', 'calfin' ),
            'options'     => array(
                'full-width'    => esc_html__( 'Full Width', 'calfin' ),
                'left-sidebar'  => esc_html__( 'Left Sidebar', 'calfin' ),
                'right-sidebar' => esc_html__( 'Right Sidebar', 'calfin' ),
            ),
            'desc'        => esc_html__( 'Select layout', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_sidebar_meta',
            'type'       => 'select',
            'title'      => esc_html__( 'Sidebar', 'calfin' ),
            'options'    => 'calfin_sidebars',
            'dependency' => array( 'calfin_layout_meta', 'any', 'left-sidebar,right-sidebar' ),
            'desc'       => esc_html__( 'Select sidebar you want to show with this page.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_meta_page_navbar',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Pagination', 'calfin' ),
            'subtitle' => esc_html__( 'This Options only for Default page', 'calfin' ),
            'default'  => true,
        ),
        array(
            'id'          => 'calfin_meta_page_spacing',
            'type'        => 'spacing',
            'title'       => esc_html__( 'Padding', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Page Padding If you need', 'calfin' ),
            'output'      => '.site-main.content-area',
            'output_mode' => 'padding',
        ),
    ),
) );

// Create a section
CSF::createSection( $calfinmetabox, array(
    'title'  => esc_html__( 'Banner / Breadcrumb Area', 'calfin' ),
    'icon'   => 'fas fa-rocket',
    'fields' => array(
        array(
            'id'       => 'calfin_meta_enable_banner',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Banner', 'calfin' ),
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'default'  => true,
            'desc'     => esc_html__( 'Enable or disable banner.', 'calfin' ),
        ),
        array(
            'id'                    => 'calfin_meta_banner_options',
            'type'                  => 'background',
            'title'                 => esc_html__( 'Banner Background', 'calfin' ),
            'background_gradient'   => true,
            'background_origin'     => false,
            'background_clip'       => false,
            'background_blend-mode' => false,
            'default'               => array(
                'background-color'              => '',
                'background-gradient-color'     => '',
                'background-gradient-direction' => 'to right',
                'background-size'               => 'cover',
                'background-position'           => 'center center',
                'background-repeat'             => 'no-repeat',
            ),
            'dependency'            => array( 'calfin_meta_enable_banner', '==', true ),
            'output'                => '.breadcroumb-area',
            'desc'                  => esc_html__( 'If you use gradient background color (Second Color) then background image will not working. Gradient background priority is higher then background image', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_meta_banner_title_color',
            'type'       => 'color',
            'title'      => esc_html__( 'Banner Title Color', 'calfin' ),
            'output'     => '.breadcroumn-contnt .brea-title',
            'dependency' => array( 'calfin_meta_enable_banner', '==', true ),
            'desc'       => esc_html__( 'Select banner title color.', 'calfin' ),
        ),

        array(
            'id'         => 'calfin_meta_breadcrumb_normal_color',
            'type'       => 'color',
            'title'      => esc_html__( 'Breadcrumb Text Color', 'calfin' ),
            'output'     => '.bre-sub span',
            'subtitle'   => esc_html__( 'Breadcrumb Text Color', 'calfin' ),
            'dependency' => array( 'calfin_meta_enable_banner', '==', true ),
            'desc'       => esc_html__( 'Select breadcrumb text color.', 'calfin' ),
        ),

        array(
            'id'         => 'calfin_meta_breadcrumb_link_color',
            'type'       => 'link_color',
            'title'      => esc_html__( 'Breadcrumb Link Color', 'calfin' ),
            'output'     => array( '.bre-sub span a' ),
            'subtitle'   => esc_html__( 'Breadcrumb Link color', 'calfin' ),
            'dependency' => array( 'calfin_meta_enable_banner', '==', true ),
            'desc'       => esc_html__( 'Select breadcrumb link and link hover color.', 'calfin' ),
        ),

    ),
) );
CSF::createSection( $calfinmetabox, array(
    'title'  => esc_html__( 'Footer Settings', 'calfin' ),
    'icon'   => 'fas fa-rocket',
    'fields' => array(
        array(
            'id'       => 'calfin_meta_footer_style_shwo',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Footer Style', 'calfin' ),
            'subtitle' => esc_html__( 'Enable Footer Style for Specific Page, post or Custom Post', 'calfin' ),
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'default'  => false,
            'desc'     => esc_html__( 'Enable or disable Footer Style.', 'calfin' ),
        ),
        array(
            'id'          => 'calfin_meta_footer_styles',
            'type'        => 'select',
            'title'       => esc_html__( 'Footer Styles', 'calfin' ),
            'placeholder' => esc_html__( 'Select an option', 'calfin' ),
            'options'     => array(
                'one'   => esc_html__( 'Footer One', 'calfin' ),
            ),
            'dependency'  => array( 'calfin_meta_footer_style_shwo', '==', true ),
            'subtitle'    => esc_html__( 'Select Your Footer', 'calfin' ),
        ),
    ),
) );
