<?php

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

//
// Metabox of the PAGE
// Set a unique slug-like ID
//
$postgallery = 'calfin_postmeta_gallery';

//
// Create a metabox
//
CSF::createMetabox( $postgallery, array(
    'title'        => esc_html( 'Post Format image Gallery', 'calfin' ),
    'post_type'    => array( 'post' ),
    'post_formats' => 'gallery',
) );

//
// Create a section
//
CSF::createSection( $postgallery, array(
    'title'  => esc_html__( 'Add Gallery Image', 'calfin' ),
    'icon'   => 'fas fa-rocket',
    'fields' => array(
        array(
            'id'          => 'calfin_post_gallery',
            'type'        => 'gallery',
            'title'       => esc_html( 'Gallery', 'calfin' ),
            'add_title'   => esc_html( 'Add Image', 'calfin' ),
            'edit_title'  => esc_html( 'Edit Image', 'calfin' ),
            'clear_title' => esc_html( 'Remove Image', 'calfin' ),
        ),
    ),
) );