<?php

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

//
// Metabox of the PAGE
// Set a unique slug-like ID
//
$teammeta = 'calfin_teammeta';

//
// Create a metabox
//
CSF::createMetabox( $teammeta, array(
    'title'        => esc_html__( 'Team Options', 'calfin' ),
    'post_type'    => array( 'calfin_team' ),
    'show_restore' => true,
) );

//
// Create a section
//
CSF::createSection( $teammeta, array(
    'title'    => esc_html__( 'Team Info Options', 'calfin' ),
    'subtitle' => esc_html__( 'Add Team Sort info and info list here', 'calfin' ),
    'icon'     => 'fas fa-arrow-right',
    'fields'   => array(
        array(
            'id'       => 'calfin_team_stitle',
            'type'     => 'text',
            'title'    => esc_html__( 'Designation', 'calfin' ),
            'subtitle' => esc_html__( 'Add Team Designation here', 'calfin' ),
            'default'  => esc_html__( 'Human Resource', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_team_sort_dec',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Sort Description', 'calfin' ),
            'subtitle' => esc_html__( 'Add Team sort Description Here', 'calfin' ),
            'default'  => esc_html__( 'sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.', 'calfin' ),
        ),

        array(
            'id'       => 'calfin_team_info',
            'type'     => 'group',
            'title'    => esc_html__( 'Team Info Box', 'calfin' ),
            'subtitle' => esc_html__( 'Add Team Members Info here', 'calfin' ),
            'fields'   => array(
                array(
                    'id'       => 'calfin_team_info_label',
                    'type'     => 'text',
                    'title'    => esc_html__( 'label', 'calfin' ),
                    'subtitle' => esc_html__( 'Add info Label Here', 'calfin' ),
                    'default'  => esc_html__( 'Phone', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_team_info_content',
                    'type'     => 'wp_editor',
                    'title'    => esc_html__( 'Phone', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Team Phone Number Here', 'calfin' ),
                    'default'  => esc_html__( '+1234567890', 'calfin' ),
                ),
            ),
            'default'  => array(
                array(
                    'calfin_team_info_label'   => esc_html__( 'Phone:', 'calfin' ),
                    'calfin_team_info_content' => esc_html__( '+1234567890', 'calfin' ),
                ),
                array(
                    'calfin_team_info_label'   => esc_html__( 'Email:', 'calfin' ),
                    'calfin_team_info_content' => esc_html__( 'nathan.roberts@example.com', 'calfin' ),
                ),
                array(
                    'calfin_team_info_label'   => esc_html__( 'Website:', 'calfin' ),
                    'calfin_team_info_content' => esc_html__( 'http://yoursite.com/mugli', 'calfin' ),
                ),
                array(
                    'calfin_team_info_label'   => esc_html__( 'Address:', 'calfin' ),
                    'calfin_team_info_content' => esc_html__( '8502 Preston Rd. Inglewood, Maine 98380', 'calfin' ),
                ),
            ),
        ),
    ),
) );
CSF::createSection( $teammeta, array(
    'title'    => esc_html__( 'Team Social Info', 'calfin' ),
    'subtitle' => esc_html__( 'Add Team Social Information here', 'calfin' ),
    'icon'     => 'fas fa-arrow-right',
    'fields'   => array(
        array(
            'id'    => 'calfin_static_icon',
            'type'  => 'icon',
            'title'    => esc_html__( 'Social Static Icon', 'calfin' ),
            'default' => 'fas fa-share-alt'
          ),
        array(  
            'id'       => 'calfin_team_socials',
            'type'     => 'group',
            'title'    => esc_html__( 'Team Socials link', 'calfin' ),
            'subtitle' => esc_html__( 'Add Social Info', 'calfin' ),
            'fields'   => array(
                array(
                    'id'       => 'calfin_team_social_label',
                    'type'     => 'text',
                    'title'    => esc_html__( 'label', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Social label Name', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_teams_socials_icon',
                    'type'     => 'icon',
                    'title'    => esc_html__( 'Icon', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Social Icon', 'calfin' ),
                    'default'  => 'fa fa-facebook',
                ),
                array(
                    'id'       => 'calfin_team_social_link',
                    'type'     => 'link',
                    'title'    => esc_html__( 'Link', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Social Link', 'calfin' ),
                ),
            ),
            'default'  => array(
                array(
                    'calfin_team_social_label'  => esc_html__( 'Facebook', 'calfin' ),
                    'calfin_teams_socials_icon' => esc_html__( 'fab fa-facebook-f', 'calfin' ),
                    'calfin_team_social_link'   => 'facebook.com',
                ),
                array(
                    'calfin_team_social_label'  => esc_html__( 'Twitter', 'calfin' ),
                    'calfin_teams_socials_icon' => esc_html__( 'fab fa-twitter', 'calfin' ),
                    'calfin_team_social_link'   => 'twitter.com',
                ),
                array(
                    'calfin_team_social_label'  => esc_html__( 'Linkedin', 'calfin' ),
                    'calfin_teams_socials_icon' => esc_html__( 'fab fa-linkedin-in', 'calfin' ),
                    'calfin_team_social_link'   => 'linkedin.com',
                ),
                array(
                    'calfin_team_social_label'  => esc_html__( 'Instagram', 'calfin' ),
                    'calfin_teams_socials_icon' => esc_html__( 'fab fa-instagram', 'calfin' ),
                    'calfin_team_social_link'   => 'instragram.com',
                ),
            ),
        ),

    ),
) );