<?php
//Archive Options
CSF::createSection( $calfinThemeOption, array(
    'parent' => 'calfin_page_options',
    'title'  => esc_html__( 'Archive Page', 'calfin' ),
    'icon'   => 'fa fa-archive',
    'fields' => array(
        array(
            'id'      => 'calfin_archive_layout',
            'type'    => 'select',
            'title'   => esc_html__( 'Archive Layout', 'calfin' ),
            'options' => array(
                'grid'          => esc_html__( 'Grid Full', 'calfin' ),
                'grid-ls'       => esc_html__( 'Grid With Left Sidebar', 'calfin' ),
                'grid-rs'       => esc_html__( 'Grid With Right Sidebar', 'calfin' ),
                'left-sidebar'  => esc_html__( 'Left Sidebar', 'calfin' ),
                'right-sidebar' => esc_html__( 'Right Sidebar', 'calfin' ),
            ),
            'default' => 'right-sidebar',
            'desc'    => esc_html__( 'Select blog page layout.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_archive_banner',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Archive Banner', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable archive page banner.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_archive_pagination',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Archive Pagination', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable archive Pagination.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_archive_banner_title_static_color',
            'type'       => 'color',
            'title'      => esc_html__( 'Banner Static Title Color', 'calfin' ),
            'output'     => '.page-header .container h2.archive-title',
            'dependency' => array( 'calfin_archive_banner', '==', true ),
            'desc'       => esc_html__( 'Select banner Static title color.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_archive_banner_title_color',
            'type'       => 'color',
            'title'      => esc_html__( 'Banner Title Color', 'calfin' ),
            'output'     => '.archive-title span',
            'dependency' => array( 'calfin_archive_banner', '==', true ),
            'desc'       => esc_html__( 'Select banner title color.', 'calfin' ),
        ),
    ),
) );