<?php
//authors Options
CSF::createSection( $calfinThemeOption, array(
    'parent' => 'calfin_page_options',
    'title'  => esc_html__( 'Author Page', 'calfin' ),
    'icon'   => 'fa fa-user',
    'fields' => array(
        array(
            'id'      => 'calfin_authors_layout',
            'type'    => 'select',
            'title'   => esc_html__( 'authors Layout', 'calfin' ),
            'options' => array(
                'grid' => esc_html__( 'Grid View', 'calfin' ),
                'list' => esc_html__( 'List View', 'calfin' ),
            ),
            'default' => 'list',
            'desc'    => esc_html__( 'Select blog page layout.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_authors_banner',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable authors Banner', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable authors page banner.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_authors_pagination',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable authors Pagination', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable authors Pagination.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_banner_title_static_color',
            'type'       => 'color',
            'title'      => esc_html__( 'Banner Static Title Color', 'calfin' ),
            'output'     => '.page-header .container h2.authors-title',
            'dependency' => array( 'calfin_authors_banner', '==', true ),
            'desc'       => esc_html__( 'Select banner Static title color.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_banner_title_color',
            'type'       => 'color',
            'title'      => esc_html__( 'Banner Title Color', 'calfin' ),
            'output'     => '.authors-title span',
            'dependency' => array( 'calfin_authors_banner', '==', true ),
            'desc'       => esc_html__( 'Select banner title color.', 'calfin' ),
        ),
        array(
            'type'    => 'notice',
            'style'   => 'success',
            'content' => esc_html__( 'Author Info Section for Author Page', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_authors_info_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Total Post Text', 'calfin' ),
            'subtitle' => esc_html__( 'Add Author Info Text', 'calfin' ),
            'default'  => esc_html__( 'Author Info', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_authors_image',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Image', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Image.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_authors_name',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Name', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Name.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_namet',
            'type'       => 'text',
            'title'      => esc_html__( 'Name Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Author Name Text', 'calfin' ),
            'default'    => esc_html__( 'Name:', 'calfin' ),
            'dependency' => array( 'calfin_authors_name', '==', true ),
        ),
        array(
            'id'       => 'calfin_authors_dname',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Dispaly Name', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Dispaly Name.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_dnamet',
            'type'       => 'text',
            'title'      => esc_html__( 'Dispaly Name Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Author Dispaly Name Text', 'calfin' ),
            'default'    => esc_html__( 'Display:', 'calfin' ),
            'dependency' => array( 'calfin_authors_dname', '==', true ),
        ),

        array(
            'id'       => 'calfin_authors_email',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Email', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Email.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_emailt',
            'type'       => 'text',
            'title'      => esc_html__( 'Email Name Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Author Email Name Text', 'calfin' ),
            'default'    => esc_html__( 'Email:', 'calfin' ),
            'dependency' => array( 'calfin_authors_email', '==', true ),
        ),
        array(
            'id'       => 'calfin_authors_website',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Website', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Website.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_websitet',
            'type'       => 'text',
            'title'      => esc_html__( 'Website Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Author Website Text', 'calfin' ),
            'default'    => esc_html__( 'Website:', 'calfin' ),
            'dependency' => array( 'calfin_authors_website', '==', true ),
        ),
        array(
            'id'       => 'calfin_authors_total_post',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Total Post', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Total Post.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_authors_total_postt',
            'type'       => 'text',
            'title'      => esc_html__( 'Total Post Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Author Total Post Text', 'calfin' ),
            'default'    => esc_html__( 'Total Post:', 'calfin' ),
            'dependency' => array( 'calfin_authors_total_post', '==', true ),
        ),
        array(
            'id'       => 'calfin_authors_dec',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Description', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Description.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_authors_social',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Author Social', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable Author Social.', 'calfin' ),
        ),
    ),
) );