<?php

//Banner Options
CSF::createSection( $calfinThemeOption, array(
    'parent' => 'calfin_page_options',
    'title'  => esc_html__( 'Banner / Breadcrumb Area', 'calfin' ),
    'icon'   => 'fa fa-flag',
    'fields' => array(
        array(
            'id'                    => 'calfin_banner_default_options',
            'type'                  => 'background',
            'title'                 => esc_html__( 'Banner Background', 'calfin' ),
            'background_gradient'   => true,
            'background_origin'     => false,
            'background_clip'       => false,
            'background_blend-mode' => false,
            'default'               => array(
                'background-color'              => '',
                'background-gradient-color'     => '',
                'background-gradient-direction' => 'to right',
                'background-size'               => 'cover',
                'background-position'           => 'center center',
                'background-repeat'             => 'no-repeat',
            ),
            'output'                => '.breadcroumb-area',
            'subtitle'              => esc_html__( 'Select banner default properties for all page / post. You can override this settings on individual page / post.', 'calfin' ),
            'desc'                  => esc_html__( 'If you use gradient background color (Second Color) then background image will not working. Gradient background priority is higher then background image', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_breadcrumb_normal_color',
            'type'     => 'color',
            'title'    => esc_html__( 'Breadcrumb Text Color', 'calfin' ),
            'output'   => '.breadcroumn-contnt .brea-title',
            'subtitle' => esc_html__( 'Breadcrumb Text Color', 'calfin' ),
            'desc'     => esc_html__( 'Select breadcrumb text color.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_breadcrumb_link_color',
            'type'     => 'link_color',
            'title'    => esc_html__( 'Breadcrumb Link Color', 'calfin' ),
            'output'   => array( '.bre-sub span a span' ),
            'subtitle' => esc_html__( 'Breadcrumb Link color', 'calfin' ),
            'desc'     => esc_html__( 'Select breadcrumb link and link hover color.', 'calfin' ),
        ),
        array(
            'id'          => 'calfin_breadcrumb_spacing',
            'type'        => 'spacing',
            'title'       => esc_html__( 'Breadcrumb Spacing', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Breadcrumb Content Spacing', 'calfin' ),
            'output'      => '.breadcroumb-area',
            'output_mode' => 'padding', // or margin, relative
        ),
        array(
            'id'          => 'calfin_breadcrumb_select_html',
            'type'        => 'select',
            'title'       => esc_html__( 'HTML Tag', 'calfin' ),
            'subtitle'    => esc_html__( 'Select Title HTML Tag', 'calfin' ),
            'placeholder' => esc_html__( 'Select an option', 'calfin' ),
            'options'     => array(
                'h1' => esc_html__( 'H1', 'calfin' ),
                'h2' => esc_html__( 'H2', 'calfin' ),
                'h3' => esc_html__( 'H3', 'calfin' ),
                'h4' => esc_html__( 'H4', 'calfin' ),
                'h5' => esc_html__( 'H5', 'calfin' ),
                'h6' => esc_html__( 'H6', 'calfin' ),
            ),
            'default'     => 'h2',
        ),
    ),
) );