<?php
//Blog Page Options
CSF::createSection( $calfinThemeOption, array(
    'parent' => 'calfin_page_options',
    'title'  => esc_html__( 'Blog Page', 'calfin' ),
    'icon'   => 'fa fa-pencil-square-o',
    'fields' => array(
        array(
            'id'      => 'calfin_blog_layout',
            'type'    => 'select',
            'title'   => esc_html__( 'Blog Layout', 'calfin' ),
            'options' => array(
                'grid'          => esc_html__( 'Grid Full', 'calfin' ),
                'grid-ls'       => esc_html__( 'Grid With Left Sidebar', 'calfin' ),
                'grid-rs'       => esc_html__( 'Grid With Right Sidebar', 'calfin' ),
                'left-sidebar'  => esc_html__( 'Left Sidebar', 'calfin' ),
                'right-sidebar' => esc_html__( 'Right Sidebar', 'calfin' ),
            ),
            'default' => 'right-sidebar',
            'desc'    => esc_html__( 'Select blog page layout.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_blog_banner_enable',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Banner', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show Banner.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_blog_title',
            'type'       => 'text',
            'title'      => esc_html__( 'Banner Title', 'calfin' ),
            'dependency' => array( 'calfin_blog_banner_enable', '==', 'true' ),
            'desc'       => esc_html__( 'Type blog banner title here.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_blog_home_title',
            'type'       => 'text',
            'default'    => esc_html__( 'calfin', 'calfin' ),
            'title'      => esc_html__( 'Banner Home Text', 'calfin' ),
            'dependency' => array( 'calfin_blog_banner_enable', '==', 'true' ),
            'desc'       => esc_html__( 'Type blog banner Home Text here.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_blog_home_stitle',
            'type'       => 'text',
            'title'      => esc_html__( 'Banner Home Sub Text', 'calfin' ),
            'dependency' => array( 'calfin_blog_banner_enable', '==', 'true' ),
            'default'    => esc_html__( 'Blog Standard', 'calfin' ),
            'desc'       => esc_html__( 'Type blog banner Home Sub Text here.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_post_author',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Author Name', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post author name.', 'calfin' ),
        ),

        array(
            'id'       => 'calfin_post_date',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Post Date', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post date.', 'calfin' ),
        ),

        array(
            'id'       => 'calfin_cmnt_number',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Comment Number', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post comment number.', 'calfin' ),
        ),

        array(
            'id'       => 'calfin_show_category',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Category Name', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post category name.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_share_blog',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Share Icon', 'calfin' ),
            'default'  => false,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post category name.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_show_pagination',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Pagination', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post category name.', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_show_readmore',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Show Readmore Button', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Hide / Show post category name.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_blog_read_text',
            'type'       => 'text',
            'default'    => esc_html__( 'Read More', 'calfin' ),
            'title'      => esc_html__( 'Read More Text', 'calfin' ),
            'dependency' => array( 'calfin_show_readmore', '==', 'true' ),
            'desc'       => esc_html__( 'Add ReadMore Text here.', 'calfin' ),
        ),
    ),
) );