<?php
CSF::createSection( $calfinThemeOption, array(
    'parent' => 'calfin_page_options',
    'title'  => esc_html__( 'Error 404', 'calfin' ),
    'icon'   => 'fa fa-exclamation-triangle',
    'fields' => array(

        array(
            'id'       => 'calfin_error_page_banner',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Error Banner', 'calfin' ),
            'default'  => true,
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable search page banner.', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_error_page_title',
            'type'       => 'text',
            'title'      => esc_html__( 'Banner Title', 'calfin' ),
            'desc'       => esc_html__( 'Type Banner Title Here.', 'calfin' ),
            'dependency' => array( 'calfin_error_page_banner', '==', 'true' ),
        ),
        array(
            'id'           => 'calfin_error_image',
            'type'         => 'media',
            'title'        => esc_html__( 'Error Image', 'calfin' ),
            'library'      => 'image',
            'button_title' => esc_html__( 'Upload Image', 'calfin' ),
            'desc'         => esc_html__( 'Upload error page image', 'calfin' ),
        ),
        array(
            'id'            => 'calfin_not_found_text',
            'type'          => 'wp_editor',
            'title'         => esc_html__( 'Not Found Text', 'calfin' ),
            'tinymce'       => true,
            'quicktags'     => true,
            'media_buttons' => false,
            'height'        => '150px',
            'desc'          => esc_html__( 'Type not found text here.', 'calfin' ),
        ),

        array(
            'id'       => 'calfin_go_back_home',
            'type'     => 'switcher',
            'title'    => esc_html__( 'Enable Go Back Home Button', 'calfin' ),
            'text_on'  => esc_html__( 'Yes', 'calfin' ),
            'text_off' => esc_html__( 'No', 'calfin' ),
            'desc'     => esc_html__( 'Enable or disable go back home button.', 'calfin' ),
            'default'  => true,
        ),
        array(
            'id'         => 'calfin_error_page_button_text',
            'type'       => 'text',
            'dependency' => array( 'calfin_go_back_home', '==', 'true' ),
            'title'      => esc_html__( 'Bottom Text', 'calfin' ),
            'desc'       => esc_html__( 'Type Banner Title Here.', 'calfin' ),
            'default'    => esc_html__( 'Go Back', 'calfin' ),
        ),

    ),
) );