<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
// Create layout and options section
CSF::createSection( $calfinThemeOption, array(
    'title'  => esc_html__( 'Footer Settings', 'calfin' ),
    'id'     => 'calfin_footer_options',
    'icon'   => 'fa fa-sort-amount-asc',
    'fields' => array(
        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Footer Style Settings', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_footer_styles',
            'type'     => 'select',
            'title'    => esc_html__( 'Footer Select', 'calfin' ),
            'subtitle' => esc_html__( 'Select your Footer Style', 'calfin' ),
            'options'  => array(
                'one' => esc_html__( 'Footer One', 'calfin' ),
            ),
            'default'  => 'one',
        ),
        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Footer Widget Style', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_footer_column_layout',
            'type'     => 'image_select',
            'title'    => esc_attr__( 'Footer Widget Columns', 'calfin' ),
            'subtitle' => esc_attr__( 'Select Your Footer Widget Columns Here.', 'calfin' ),
            'options'  => array(
                '12'      => get_template_directory_uri() . '/assets/image/widgets/footer_col_12.png',
                '6_6'     => get_template_directory_uri() . '/assets/image/widgets/footer_col_6_6.png',
                '4_4_4'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_4_4_4.png',
                '3_3_3_3' => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_3_3_3.png',
                '3_2_3_4' => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_2_3_4.png',
                '8_4'     => get_template_directory_uri() . '/assets/image/widgets/footer_col_8_4.png',
                '4_8'     => get_template_directory_uri() . '/assets/image/widgets/footer_col_4_8.png',
                '6_3_3'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_6_3_3.png',
                '3_3_6'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_3_3_6.png',
                '8_2_2'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_8_2_2.png',
                '2_2_8'   => get_template_directory_uri() . '/assets/image/widgets/footer_col_2_2_8.png',
                '6_2_2_2' => get_template_directory_uri() . '/assets/image/widgets/footer_col_6_2_2_2.png',
                '2_2_2_6' => get_template_directory_uri() . '/assets/image/widgets/footer_col_2_2_2_6.png',
            ),
            'default'  => '3_3_3_3',
            'after'    => esc_attr__( 'Select Footer Column layout View for widgets.', 'calfin' ),
        ),

        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Design Settings For Footer Widgets Area', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_ft_widgets_style',
            'type'       => 'fieldset',
            'title'      => esc_html__( 'Footer Widget Style', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Design for Footer Widget Sarea', 'calfin' ),
            'dependency' => array( 'calfin_footer_styles', '==', 'one', 'all' ),
            'fields'     => array(
                array(
                    'id'                  => 'calfin_ft_bg1',
                    'type'                => 'background',
                    'title'               => esc_html__( 'Background', 'calfin' ),
                    'subtitle'            => esc_html__( 'Add Your Footer Background color or Image or Gradient', 'calfin' ),
                    'background_gradient' => true,
                    'background_origin'   => true,
                    'output'              => '.footer-one .footer-widgets-area .footer-widget-section',
                ),
                array(
                    'id'       => 'calfin_title_color1',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Title Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Widget Title color ', 'calfin' ),
                    'output'   => '.footer-one .footer-widgets-area .site-info',
                ),
                array(
                    'id'       => 'calfin_text_color1',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Widget Text color ', 'calfin' ),
                    'output'   => '',
                ),
                array(
                    'id'       => 'calfin_link_color1',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Link Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Widget Link color ', 'calfin' ),
                    'output'   => '',
                ),
                array(
                    'id'       => 'calfin_link_hover_color1',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Link Hover Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Widget Link Hover color ', 'calfin' ),
                    'output'   => '',
                ),
            ),
        ),

        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Footer CopyRight Section', 'calfin' ),
        ),
        array(
            'id'            => 'calfin_copyright_text',
            'type'          => 'wp_editor',
            'title'         => esc_html__( 'Copyright Text', 'calfin' ),
            'subtitle'      => esc_html__( 'Site copyright text', 'calfin' ),
            'desc'          => esc_html__( 'Type site copyright text here.', 'calfin' ),
            'tinymce'       => true,
            'quicktags'     => true,
            'media_buttons' => false,
            'height'        => '100px',
        ),
        array(
            'id'         => 'calfin_ft_style',
            'type'       => 'fieldset',
            'title'      => esc_html__( 'Footer Style', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Design for Footer Buttom Area', 'calfin' ),
            'dependency' => array( 'calfin_footer_styles', '==', 'one', 'all' ),
            'fields'     => array(
                array(
                    'id'       => 'calfin_footer_bg1',
                    'type'     => 'background',
                    'title'    => esc_html__( 'Background', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Background color For Buttom Area', 'calfin' ),
                    'output'   => '.footer-one .footer-widgets-area .copyright-area',
                ),
                array(
                    'id'       => 'calfin_ft_text_color1',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Bottom Text color ', 'calfin' ),
                    'output'   => '.footer-one .footer-widgets-area .site-info',
                ),
                array(
                    'id'       => 'calfin_ft_link_color1',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Link Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Footer Bottom Link color ', 'calfin' ),
                    'output'   => '.footer-one .copyright-area .site-info a',
                ),
            ),
        ),
        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Menu Settings', 'calfin' ),
        ),
        array(
            'id'      => 'calfin_ft_menu_show',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Menu', 'calfin' ),
            'default' => false
        ),
        array(
            'id'          => 'calfin_ft_menu',
            'type'        => 'select',
            'title'       => esc_html__( 'Select Menu', 'calfin' ),
            'options' => 'menus',
            'dependency' => array( 'calfin_ft_menu_show', '==', 'true' ),
        ),
    ),
) );
