<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
CSF::createSection( $calfinThemeOption, array(
    'title'  => esc_html__( 'General', 'calfin' ),
    'icon'   => 'fa fa-cogs',
    'fields' => array(
        
        array(
            'type'    => 'notice',
            'style'   => 'success',
            'content' => esc_html__( 'Preloader Options', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_enable_preloader',
            'type'     => 'switcher',
            'default'  => true,
            'title'    => esc_html__( 'Preloader', 'calfin' ),
            'subtitle' => esc_html__( 'Select Site Preloader. Default Enable', 'calfin' ),
        ),
        array(
            'id'          => 'calfin_preloader_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Preloader color One', 'calfin' ),
            'dependency'  => array( 'calfin_enable_preloader', '==', 'true' ),
            'output'      => '.theme-loader',
            'output_mode' => 'border-color', // Supports css properties like ( border-color, color, background-color etc )
        ),
        array(
            'id'          => 'calfin_preloader2_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Preloader color Two', 'calfin' ),
            'dependency'  => array( 'calfin_enable_preloader', '==', 'true' ),
            'output'      => '.theme-loader::after',
            'output_mode' => 'border-color', // Supports css properties like ( border-color, color, background-color etc )
        ),
        array(
            'id'          => 'calfin_preloader3_color',
            'type'        => 'color',
            'title'       => esc_html__( 'Preloader Full Width Background', 'calfin' ),
            'dependency'  => array( 'calfin_enable_preloader', '==', 'true' ),
            'output'      => '.preloader-area',
            'output_mode' => 'background-color', // Supports css properties like ( border-color, color, background-color etc )
        ),
        array(
            'type'    => 'notice',
            'style'   => 'success',
            'content' => esc_html__( 'Comment Options', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_enable_page_cmt',
            'type'     => 'switcher',
            'default'  => true,
            'title'    => esc_html__( 'Enable Comment for page', 'calfin' ),
            'subtitle' => esc_html__( 'Enable Comment section on Page', 'calfin' ),
        ),
        array(
            'type'    => 'subheading',
            'content' => esc_html__( 'Top To Bottom Button Settings', 'calfin' ),
        ),
        array(
            'id'       => 'calfin_enable_top_to_bottom',
            'type'     => 'switcher',
            'default'  => true,
            'title'    => esc_html__( 'Enable Top To Bottom Icon', 'calfin' ),
            'subtitle' => esc_html__( 'Enable Top To Bottom Icon', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_enable_ttb_icon',
            'type'       => 'icon',
            'title'      => esc_html__( 'Select Icon', 'calfin' ),
            'default'    => 'fa fa-angle-up',
            'dependency' => array( 'calfin_enable_top_to_bottom', '==', 'true' ),
        ),
        array(
            'id'          => 'calfin_enable_ttb_bgi',
            'type'        => 'color',
            'title'       => esc_html__( 'Icon Color', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Color for Top To bottom icon', 'calfin' ),
            'dependency'  => array( 'calfin_enable_top_to_bottom', '==', 'true' ),
            'output'      => '.to-top',
            'output_mode' => 'color',
        ),
        array(
            'id'          => 'calfin_enable_ttb_bg',
            'type'        => 'color',
            'title'       => esc_html__( 'Background Color', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Background Color for Top To bottom icon', 'calfin' ),
            'dependency'  => array( 'calfin_enable_top_to_bottom', '==', 'true' ),
            'output'      => '.to-top',
            'output_mode' => 'background-color',
        ),
    ),
) );