<?php
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Header Setings
CSF::createSection( $calfinThemeOption, array(
    'id'     => 'calfin_header_settings',
    'title'  => esc_html__( 'Header Settings', 'calfin' ),
    'icon'   => 'fa fa-header',
    'fields' => array(
        array(
            'id'       => 'calfin_header_styles',
            'type'     => 'image_select',
            'title'    => esc_html__( 'Select Style', 'calfin' ),
            'options'  => array(
                'one'   => get_theme_file_uri( 'assets/image/header-1.png' ),
                'two'   => get_theme_file_uri( 'assets/image/header-2.png' ),
            ),
            'default'  => 'one',
            'subtitle' => esc_html__( 'Choose Your Header Style For Global', 'calfin' ),
        ),
        /////////////////////////////////////
        ////////// HEADER DESIGN ONE ////////
        ////////////////////////////////////

         //______-------________------________---------
        //__________ HEADER ONE STICKY  OPTIONS _________
        //______-------________------________---------

        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Sticky Menu Options', 'calfin' ),
        ),
        array(
            'id'         => 'calfin_enable_sticky_menu',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Sticky Menu', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Sticky Menu If you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),

            ),
        ),
        array(
            'id'               => 'calfin_header_sticky',
            'type'             => 'color',
            'title'            => esc_html__( 'Sticky Menu Background', 'calfin' ),
            'subtitle'         => esc_html__( 'Add Background Color for Sticky Menu', 'calfin' ),
            'output_mode'      => 'background-color',
            'output'           => '.header-one .sticky-bar',
            'output_important' => true,
            'dependency'       => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_enable_sticky_menu', '==', 'true' ),
            ),
        ),
        //______-------________------________---------
        //__________ HEADER LOGO OPTIONS _________
        //______-------________------________---------

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Site Logo Options', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            ),
        ),
        array(
            'id'         => 'calfin_show_hlogo1',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            )
        ),
        array(
            'id'         => 'calfin_logo1',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'calfin' ),
            'library'    => 'image',
            'dependency' => array(
                array( 'calfin_header_styles|calfin_show_hlogo1', '==|==', 'one|true', 'all' ),
            ) 
        ),
        array(
            'id'          => 'calfin_logo1_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'calfin' ),
            'subtitle'    => esc_html__( 'Add logo Size if you need Logo Size', 'calfin' ),
            'unit'        => 'px',
            'output'      => '.header-one .site-branding img',
            'output_mode' => 'width',
            'dependency' => array(
                array( 'calfin_header_styles|calfin_show_hlogo1', '==|==', 'one|true', 'all' ),
            ) 
        ),
        array(
            'id'       => 'calfin_logo_color_1',
            'type'     => 'color',
            'title'    => esc_html__( 'Text Color', 'calfin' ),
            'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
            'output'   => '.header-one .header-logo h2 a',
            'dependency' => array(
                array( 'calfin_header_styles|calfin_show_hlogo1', '==|==', 'one|true', 'all' ),
            )
        ),
        array(
            'id'          => 'calfin_logo_bg_color_1',
            'type'        => 'color',
            'title'       => esc_html__( 'Background Color', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Color For Logo Background Area', 'calfin' ),
            'output'      => '.header-one .header-logo-bg',
            'output_mode' => 'background-color',
            'dependency' => array(
                array( 'calfin_header_styles|calfin_show_hlogo1', '==|==', 'one|true', 'all' ),
            )
        ),
		
		   //______-------________------________---------
        //__________ HEADER MOBILE LOGO OPTIONS _________
        //______-------________------________---------

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Site Mobile Options', 'calfin' ),
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            )
        ),
        array(
            'id'         => 'calfin_mobile_logo_enable',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Logo for Mobile Options if you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            ) 
        ),
        array(
            'id'         => 'mobile_logo',
            'type'       => 'media',
            'title'      => esc_html__( 'Mobile Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Upload Mobile Header Logo if you Need  ', 'calfin' ),
            'library'    => 'image',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_mobile_logo_enable', '==', 'true', 'all' )
            )
        ),
        array(
            'id'       => 'calfin_mlogo_color_1',
            'type'     => 'color',
            'title'    => esc_html__( 'Text Color', 'calfin' ),
            'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
            'output'   => '.ot-menu-wrapper .mobile-logo a',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_mobile_logo_enable', '==', 'true', 'all' )
            )
        ),
        array(
            'id'          => 'calfin_mlogo_bg_color_1',
            'type'        => 'color',
            'title'       => esc_html__( 'Background Color', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Color For Logo MObile Background Area', 'calfin' ),
            'output'      => '.ot-menu-wrapper .mobile-logo',
            'output_mode' => 'background-color',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_mobile_logo_enable', '==', 'true', 'all' )
            )
        ),
        //______-------________------________---------
        //__________ HEADER ONE MENU OPTIONS _________
        //______-------________------________---------

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Header Menu Options', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            ) 
        ),
        array(
            'id'         => 'calfin_header-menu_group1',
            'type'       => 'fieldset',
            'title'      => esc_html__( 'Site Header Options', 'calfin' ),
            'subtitle'   => esc_html__( 'Add your Site Header Options here', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            ),
            'fields'     => array(
                array(
                    'type'    => 'submessage',
                    'style'   => 'info',
                    'content' => esc_html__( 'Parent Menu Options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_top_header1_menu_ncolors',
                    'type'     => 'link_color',
                    'title'    => esc_html__( 'Menu Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Nav Menu Normal and Hover Color', 'calfin' ),
                    'output'   => '.header-one .main-menu > ul > li > a',
                ),
                
                array(
                    'type'    => 'submessage',
                    'style'   => 'info',
                    'content' => esc_html__( 'Sub menu Options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_header_submenu_color1',
                    'type'     => 'link_color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'   => '.header-one .main-menu ul.sub-menu li a',
                ),
                array(
                    'id'          => 'calfin_header_submenu_bgcolor1',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'      => '.header-one .main-menu ul.sub-menu li a',
                    'output_mode' => 'background-color',
                ),
                array(
                    'id'          => 'calfin_header_submenu_bgcolor1_hover',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Hover Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'      => '.header-one .main-menu ul.sub-menu li a:hover',
                    'output_mode' => 'background-color',
                ),
                array(
                    'id'          => 'calfin_header_submenu_border',
                    'type'        => 'color',
                    'title'       => esc_html__( 'border Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Sub menu', 'calfin' ),
                    'output'      => '.header-one .main-menu ul.sub-menu li',
                    'output_mode' => 'border-color',
                ),
            ),
        ),
        //______-------________------________---------
        //__________ HEADER GET A QUOTE OPTIONS _________
        //______-------________------________---------

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Get A Quote Options', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            ) 
        ),
        array(
            'id'         => 'calfin_cta_show',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Get A Quote', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Get A Quote button Here', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
            ) 
        ),
        array(
            'id'         => 'calfin_cta_text',
            'type'       => 'text',
            'title'      => esc_html__( 'Button Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Get A Guote Button Text Here', 'calfin' ),
            'default'    => esc_html__( 'Discover More', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_cta_show', '==', 'true' ),
            ),
        ),
        array(
            'id'         => 'calfin_cta_link',
            'type'       => 'link',
            'title'      => esc_html__( 'Link', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Get A Quote Button Link Here', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_cta_show', '==', 'true' ),
            ),
        ),
        array(
            'id'         => 'calfin_cta_fieldset',
            'type'       => 'fieldset',
            'title'      => esc_html__( 'Get A Quote Options', 'calfin' ),
            'subtitle'   => esc_html__( 'This Options for Header Quite Button', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                array( 'calfin_cta_show', '==', 'true' ),
            ),
            'fields'     => array(
                array(
                    'id'       => 'calfin_cta_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Button Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Header Get A Quote Button text Color Here', 'calfin' ),
                    'output'   => '.header-one .header-button .theme-btns',
                ),
                array(
                    'id'          => 'calfin_cta_bg',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Header Get A Quote Button Background Color Here', 'calfin' ),
                    'output_mode' => 'background-color',
                    'output'      => '.header-one .header-button .theme-btns',
                ),
                array(
                    'type'    => 'notice',
                    'style'   => 'success',
                    'content' => esc_html__( 'Hover Color Options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_cta_hcolor',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Button Text Hover Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Header Get A Quote Button text Hover Color Here', 'calfin' ),
                    'output'   => '.header-one .header-button .theme-btns:hover',
                ),
                array(
                    'id'          => 'calfin_cta_hbg',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Hover Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Header Get A Quote Button Background hover Color Here', 'calfin' ),
                    'output_mode' => 'background-color',
                    'output'      => '.header-one .header-button .theme-btns:hover',
                ),
            ),
        ),


         // ==================================================//
        //=========== HEADER ONE CALL US  OPTIONS ==========//
        // =================================================//

        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Call Us Options', 'calfin' ),
            'dependency' => array( 'calfin_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'call_us_enable',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Option', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Call Us Options If you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array( 'calfin_header_styles', '==', 'one', 'all' ),
        ),
        array(
            'id'         => 'call_us_option',
            'type'       => 'fieldset',
            'title'      => esc_html__( ' Call Us Option', 'calfin' ),
            'subtitle'   => esc_html__( 'Add your Site Header Call Us Option', 'calfin' ),
            'dependency' => array(
                array( 'call_us_enable', '==', 'true' ),
                array( 'calfin_header_styles', '==', 'one', 'all' ),
                
            ),
            'fields'     => array(
                array(
                    'id'         => 'phone_number_text',
                    'type'       => 'text',
                    'title'      => esc_html__( 'Phone Number', 'calfin' ),
                    'subtitle'   => esc_html__( 'Add your Phone Number Text', 'calfin' ),
                    'default'    => esc_html__( '+(08)-387-214-032', 'calfin' ),
                ),
                array(
                    'id'         => 'call_us_text',
                    'type'       => 'text',
                    'title'      => esc_html__( 'Call Us Text', 'calfin' ),
                    'subtitle'   => esc_html__( 'Add your Call Us Text Text', 'calfin' ),
                    'default'    => esc_html__( 'Call 24HR / 7Days', 'calfin' ),
                ),
                array(
                    'id'      => 'call_us_icon',
                    'type'    => 'icon',
                    'title'   => esc_html__( 'Icon', 'calfin' ),
                    'default' => 'fas fa-phone-alt', 'calfin',
                ),
                array(
                    'id'         => 'call_us_link',
                    'type'       => 'link',
                    'title'      => esc_html__( 'Call Us Link', 'calfin' ),
                    'subtitle'   => esc_html__( 'Add Your Call Us Link', 'calfin' ),
                ),
                array(
                    'type'    => 'submessage',
                    'style'   => 'info',
                    'content' => esc_html__( 'Call Us Option Css Style', 'calfin' ),
                ),
                array(
                    'id'          => 'calfin_call_us_bg_color1',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Call Us Area', 'calfin' ),
                    'output'      => '.header-one .header-call-us',
                    'output_mode' => 'background-color',
                ),
                array(
                    'id'       => 'number_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Number Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add your Call Us Number Color', 'calfin' ),
                    'output'   => '.header-one .call-text-box .call-number',
                ),
                array(
                    'id'       => 'call_us_text_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add your Call Us Text Color', 'calfin' ),
                    'output'   => '.header-one .call-text-box .call-text',
                ),
                array(
                    'id'       => 'call_us_icon_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Icon Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add your Call Us Icon Color', 'calfin' ),
                    'output'   => '.header-one .header-call-box .icon',
                ),
            ),
        ),

        // ---------------------------------------------------
        // ------------------- HOME TWO CONTENT ---------------
        // ---------------------------------------------------

        array(
            'id'         => 'calfin_enable_sticky_menu2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Sticky Menu', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Sticky Menu If you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),

            ),
        ),
        array(
            'id'               => 'calfin_header_sticky2',
            'type'             => 'color',
            'title'            => esc_html__( 'Sticky Menu Background', 'calfin' ),
            'subtitle'         => esc_html__( 'Add Background Color for Sticky Menu', 'calfin' ),
            'output_mode'      => 'background-color',
            'output'           => '.header-two .sticky-bar',
            'output_important' => true,
            'dependency'       => array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_enable_sticky_menu2', '==', 'true' ),
            ),
        ),

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Site Logo Options', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            ),
        ),
        array(
            'id'         => 'calfin_show_hlogo2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Logo Options if you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array( 'calfin_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'calfin_logo2',
            'type'       => 'media',
            'title'      => esc_html__( 'SIte Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Upload Header Logo if you do not use Wordpress Default logo option ', 'calfin' ),
            'library'    => 'image',
            'dependency' => array( 'calfin_header_styles|calfin_show_hlogo2', '==|==', 'two|true', 'all' ),
        ),
        array(
            'id'          => 'calfin_logo2_size',
            'type'        => 'number',
            'title'       => esc_html__( 'Logo Size', 'calfin' ),
            'subtitle'    => esc_html__( 'Add logo Size if you need Logo Size', 'calfin' ),
            'unit'        => 'px',
            'output'      => '.header-two .site-branding img',
            'output_mode' => 'width',
            'dependency'  => array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_show_hlogo2', '==', 'true' ),
            ),
        ),
        array(
            'id'       => 'calfin_logo_color_2',
            'type'     => 'color',
            'title'    => esc_html__( 'Text Color', 'calfin' ),
            'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
            'output'   => '.header-two .logo-area a',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_mobile_logo_enable2', '==', 'true', 'all' )
            )
        ),
        array(
            'id'          => 'calfin_logo_bg_color_2',
            'type'        => 'color',
            'title'       => esc_html__( 'Background Color', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Color For Logo MObile Background Area', 'calfin' ),
            'output'      => '.header-two .logo-area a',
            'output_mode' => 'background-color',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_mobile_logo_enable2', '==', 'true', 'all' )
            )
        ),
        		   //______-------________------________---------
        //__________ HEADER MOBILE LOGO OPTIONS _________
        //______-------________------________---------

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Site Mobile Options', 'calfin' ),
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            )
        ),
        array(
            'id'         => 'calfin_mobile_logo_enable2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Logo for Mobile Options if you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            ) 
        ),
        array(
            'id'         => 'mobile_logo2',
            'type'       => 'media',
            'title'      => esc_html__( 'Mobile Logo', 'calfin' ),
            'subtitle'   => esc_html__( 'Upload Mobile Header Logo if you Need  ', 'calfin' ),
            'library'    => 'image',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_mobile_logo_enable2', '==', 'true', 'all' )
            )
        ),
        array(
            'id'       => 'calfin_mlogo_color_2',
            'type'     => 'color',
            'title'    => esc_html__( 'Text Color', 'calfin' ),
            'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
            'output'   => '.ot-menu-wrapper .mobile-logo a',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_mobile_logo_enable2', '==', 'true', 'all' )
            )
        ),
        array(
            'id'          => 'calfin_mlogo_bg_color_2',
            'type'        => 'color',
            'title'       => esc_html__( 'Background Color', 'calfin' ),
            'subtitle'    => esc_html__( 'Add Color For Logo MObile Background Area', 'calfin' ),
            'output'      => '.ot-menu-wrapper .mobile-logo',
            'output_mode' => 'background-color',
            'dependency' =>array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_mobile_logo_enable2', '==', 'true', 'all' )
            )
        ),
        // ------------TOP HEADER TWO ----------------- //

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Top Header', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            ),
        ),
        array(
            'id'         => 'calfin_enable_top_headre2',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Top header', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable top Header options if you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array( 'calfin_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'calfin_top_header2_group',
            'type'       => 'fieldset',
            'title'      => esc_html__( 'Top Header Section', 'calfin' ),
            'subtitle'   => esc_html__( 'Add your contnt for top header', 'calfin' ),
            'dependency' => array(
                array( 'calfin_header_styles', '==', 'two', 'all' ),
                array( 'calfin_enable_top_headre2', '==', 'true' ),
            ),
            'fields'     => array(
                array(
                    'id'       => 'calfin_top_header_info2',
                    'type'     => 'group',
                    'title'    => esc_html__( 'Info list', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Information for top header left', 'calfin' ),
                    'fields'   => array(
                        array(
                            'id'      => 'calfin_topbar_info2',
                            'type'    => 'wp_editor',
                            'title'   => esc_html__( 'Content', 'calfin' ),
                            'default' => esc_html__( '2072 Pinnickinick Street, WA 98370', 'calfin' ),
                        ),
                        array(
                            'id'      => 'calfin_topbar_info_icon2',
                            'type'    => 'icon',
                            'title'   => esc_html__( 'Icon', 'calfin' ),
                            'default' => 'fas fa-map-marker-alt', 'calfin',
                        ),
                    ),
                    'default'  => array(
                        array(
                            'calfin_topbar_info_icon2' => 'far fa-map-marker-alt',
                            'calfin_topbar_info2'      => esc_html__( '2072 Pinnickinick Street, WA 98370', 'calfin' ),
                        ),
                        array(
                            'calfin_topbar_info_icon2' => 'fas fa-envelope',
                            'calfin_topbar_info2'      => esc_html__( 'info@website.com', 'calfin' ),
                        ),
                    ),
                ),
                // top header social area
                array(
                    'type'    => 'subheading',
                    'content' => esc_html__( 'Header top social Info', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_top_header_social2',
                    'type'     => 'group',
                    'title'    => esc_html__( 'Social List', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Your Socials  Information for top header Right', 'calfin' ),
                    'fields'   => array(
                        array(
                            'id'      => 'calfin_topbar_social_label_2',
                            'type'    => 'text',
                            'title'   => esc_html__( 'Label', 'calfin' ),
                            'default' => esc_html__( 'Facebook', 'calfin' ),
                        ),
                        array(
                            'id'      => 'calfin_topbar_social_icon_2',
                            'type'    => 'icon',
                            'title'   => esc_html__( 'Icon', 'calfin' ),
                            'default' => 'fab fa-facebook-f',
                        ),
                        array(
                            'id'      => 'calfin_social_link_2',
                            'type'    => 'link',
                            'title'   => esc_html__( 'Link', 'calfin' ),
                            'default' => array(
                                'url'    => '#',
                                'target' => '_blank',
                            ),
                        ),
                    ),
                    'default'  => array(
                        array(
                            'calfin_topbar_social_label_2' => esc_html__( 'Facebook', 'calfin' ),
                            'calfin_topbar_social_icon_2'  => 'fab fa-facebook-f',
                        ),
                        array(
                            'calfin_topbar_social_label_2' => esc_html__( 'Twitter', 'calfin' ),
                            'calfin_topbar_social_icon_2'  => 'fab fa-twitter',
                        ),
                        array(
                            'calfin_topbar_social_label_2' => esc_html__( 'Linkedin', 'calfin' ),
                            'calfin_topbar_social_icon_2'  => 'fab fa-linkedin-in',
                        ),
                        array(
                            'calfin_topbar_social_label_2' => esc_html__( 'Instagram', 'calfin' ),
                            'calfin_topbar_social_icon_2'  => 'fab fa-instagram',
                        ),
                    ),
                ),

                // Top Header CONTENT STYLE start     //

                array(
                    'type'    => 'subheading',
                    'content' => esc_html__( 'Style options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_top_header_bg2',
                    'type'     => 'background',
                    'title'    => esc_html__( 'Top Header Background', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Background Color Top Header', 'calfin' ),
                    'output'   => '.header-two .header-top-section.primary-bg',
                ),
                array(
                    'id'       => 'calfin_top_header_text_color2',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Top Header Text', 'calfin' ),
                    'output'   => array( '.header-two .header-top-info ul li', ' .header-two .header-top-right .header-socials label' ),
                    'output'   => '.header-two .header-top-info ul li',
                ),
                array(
                    'id'       => 'calfin_top_header_icon_color2',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Icon Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Top Header Icon', 'calfin' ),
                    'output'   => '.header-two .header-top-info ul li i',
                ),
                array(
                    'id'       => 'calfin_header_link_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Link Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Top Header Link ', 'calfin' ),
                    'output'   => '.header-two .header-top-info ul li a',
                ),
                array(
                    'id'       => 'calfin_header_link_hover_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Link Hover Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Top Header Link Hover ', 'calfin' ),
                    'output'   => '.header-two .header-top-info ul li a:hover',
                ),

                // Top Header Social area start     //

                array(
                    'type'    => 'subheading',
                    'content' => esc_html__( 'Social Style options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_top_header_social_icon_C2',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Icon Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Top Header Social Icon', 'calfin' ),
                    'output'   => '.header-two .header-top-social ul li a',
                ),
                array(
                    'id'       => 'calfin_top_header_social_icon_hover_c2',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Icon Hover Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Top Header Hover Social Icon', 'calfin' ),
                    'output'   => '.header-two .header-top-social ul li a:hover',
                ),
                array(
                    'id'          => 'calfin_top_header_social_icon_bg2',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Top Header Social Background ', 'calfin' ),
                    'output'      => '.header-two .header-top-social ul li a',
                    'output_mode' => 'background-color',
                ),
                array(
                    'id'          => 'calfin_top_header_social_icon_bg_hover2',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Hover Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Top Header Hover Social Background ', 'calfin' ),
                    'output'      => '.header-two .header-top-social ul li a:hover',
                    'output_mode' => 'background-color',
                ),

            ),
        ),

        // ------------ HEADER MENU OPTION ONE ----------------- //

        array(
            'type'       => 'heading',
            'content'    => esc_html__( 'Header Menu Options', 'calfin' ),
            'dependency' => array( 'calfin_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'calfin_header-menu_group2',
            'type'       => 'fieldset',
            'title'      => esc_html__( 'Site Header Options', 'calfin' ),
            'subtitle'   => esc_html__( 'Add your Site Header Options here', 'calfin' ),
            'dependency' => array( 'calfin_header_styles', '==', 'two', 'all' ),
            'fields'     => array(
                array(
                    'type'    => 'submessage',
                    'style'   => 'info',
                    'content' => esc_html__( 'Parent Menu Options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_top_header2_menu_ncolors',
                    'type'     => 'link_color',
                    'title'    => esc_html__( 'Menu Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Nav Menu Normal and Hover Color', 'calfin' ),
                    'output'   => '.header-two .main-navigation ul li a',
                ),
                array(
                    'id'       => 'calfin_header2_menu_bg',
                    'type'     => 'background',
                    'title'    => esc_html__( 'Background', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Background Color for Menu Area', 'calfin' ),
                    'output'   => '.header-two .main-header',
                ),
                array(
                    'type'    => 'submessage',
                    'style'   => 'info',
                    'content' => esc_html__( 'Sub menu Options', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_header_submenu_color2',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'   => '.header-two .main-navigation ul ul.sub-menu li a ',
                ),
                array(
                    'id'          => 'calfin_header_submenu_bgcolor2',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'      => '.header-two .main-navigation ul li ul',
                    'output_mode' => 'background-color',
                ),
                array(
                    'type'    => 'notice',
                    'style'   => 'success',
                    'content' => esc_html__( 'Sub Menu Hover CSS', 'calfin' ),
                ),
                array(
                    'id'       => 'calfin_header_submenu_hcolor2',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'   => '.header-two .main-navigation ul li ul li a:hover',
                ),
                array(
                    'id'          => 'calfin_header_submenu_hbgcolor2',
                    'type'        => 'color',
                    'title'       => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'    => esc_html__( 'Add Color For Sub Menu Text', 'calfin' ),
                    'output'      => '.header-two .main-navigation ul li ul li a:hover',
                    'output_mode' => 'background-color',
                ),

            ),
        ),


          // ===================================//
        //=========== HEADER BUTTON OPTIONS ==========//
        // ===================================//

        array(
            'type'    => 'heading',
            'content' => esc_html__( 'Join us Button', 'calfin' ),
            'dependency' => array( 'calfin_header_styles', '==', 'two', 'all' ),
        ),
        array(
            'id'         => 'join_us_button_enable',
            'type'       => 'switcher',
            'title'      => esc_html__( 'Enable Button', 'calfin' ),
            'subtitle'   => esc_html__( 'Enable Button If you need', 'calfin' ),
            'default'    => true,
            'text_on'    => esc_html__( 'Enabled', 'calfin' ),
            'text_off'   => esc_html__( 'Disabled', 'calfin' ),
            'text_width' => 100,
            'dependency' => array( 'calfin_header_styles', '==', 'two', 'all' ),
            
        ),
        array(
            'id'         => 'join_us_button_text',
            'type'       => 'text',
            'title'      => esc_html__( 'Button Text', 'calfin' ),
            'subtitle'   => esc_html__( 'Add your Button Text', 'calfin' ),
            'default'    => esc_html__( 'Join us now', 'calfin' ),
            'dependency' => array(
                array( 'join_us_button_enable', '==', 'true' ),
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            ),
        ),
        array(
            'id'         => 'join_us_button_link',
            'type'       => 'link',
            'title'      => esc_html__( 'Button Link', 'calfin' ),
            'subtitle'   => esc_html__( 'Add Your Button Link', 'calfin' ),
            'dependency' => array(
                array( 'join_us_button_enable', '==', 'true' ),
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            ),
        ),
        array(
            'id'         => 'join_us_button_css_area',
            'type'       => 'fieldset',
            'title'      => esc_html__( ' Button', 'calfin' ),
            'subtitle'   => esc_html__( 'Add your Site Header Button', 'calfin' ),
            'dependency' => array(
                array( 'join_us_button_enable', '==', 'true' ),
                array( 'calfin_header_styles', '==', 'two', 'all' ),
            ),

            'fields'     => array(
                array(
                    'id'       => 'join_us_text_color',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add your Header Button Text Color', 'calfin' ),
                    'output'   => '.header-two .header-button .theme-btns',
                ),
                array(
                    'id'       => 'join_us_text_hcolor',
                    'type'     => 'color',
                    'title'    => esc_html__( 'Text Hover Color', 'calfin' ),
                    'subtitle' => esc_html__( 'Add your Header Button Text Hover Color', 'calfin' ),
                    'output'   => '.header-two .header-button .theme-btns:hover',
                ),
                array(
                    'id'                  => 'join_us_text_bg_color',
                    'type'                => 'background',
                    'background_gradient' => true,
                    'title'               => esc_html__( 'Background Color', 'calfin' ),
                    'subtitle'            => esc_html__( 'Add your Header Button Background Color', 'calfin' ),
                    'output'              => '.header-two .header-button .theme-btns',
                    'output_mode'         => 'background-color',
                ),
                array(
                    'id'                  => 'join_us_text_bg_hcolor',
                    'type'                => 'background',
                    'background_gradient' => true,
                    'title'               => esc_html__( 'Background Hover Color', 'calfin' ),
                    'subtitle'            => esc_html__( 'Add your Header Button Background Hover Color', 'calfin' ),
                    'output'              => '.header-two .header-button .theme-btns:hover',
                    'output_mode'         => 'background-color',
                ),
            ),
        ), 
    ),
));
