<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package calfin
 */

get_header();
$calfin_blogc_title      = calfin_options( 'calfin_blog_title' );
$calfin_blog_home_title      = calfin_options( 'calfin_blog_home_title' );
$calfin_blog_home_stitle      = calfin_options( 'calfin_blog_home_stitle' );
$calfin_breadcrumb_select_html = calfin_options('calfin_breadcrumb_select_html', 'h2');
$calfin_banner_enable    = calfin_options( 'calfin_blog_banner_enable', true );
$calfin_blog_layout      = calfin_options( 'calfin_blog_layout', 'right-sidebar' );
if($calfin_blog_layout == 'grid'){
	$calfin_sidebar_bg = 'sidebar-no-bg-main';
}else{
	$calfin_sidebar_bg = 'sidebar-bg-main';
}
?>
<?php if ( $calfin_banner_enable == true ) : ?>
<div class="breadcroumb-area">
	<div class="container">
		<div class="breadcroumn-contnt">
		<<?php echo esc_attr($calfin_breadcrumb_select_html); ?> class="brea-title"><?php echo esc_html( $calfin_blogc_title ); ?></<?php echo esc_attr($calfin_breadcrumb_select_html); ?>>
			<div class="bre-sub">
				<span><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo esc_html($calfin_blog_home_title); ?></a> <i class="fas fa-minus"></i></span>
				<span><span><?php echo esc_html($calfin_blog_home_stitle); ?></span></span>
			</div>
		</div>
	</div>
</div>
<?php endif;?>
<main id="primary" class="site-main content-area  <?php echo esc_attr($calfin_sidebar_bg); ?>">
	<div class="container page-layout <?php echo esc_attr($calfin_blog_layout); ?>">
		<?php
            if ( $calfin_blog_layout == 'grid' ) {
                get_template_part( 'template-parts/blog/post-grid' );
            } else {
                get_template_part( 'template-parts/blog/post-sidebar' );
            }?>
	</div>
</main>
<?php
get_footer();
