<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package calfin
 */

get_header();
if(get_post_meta( get_the_ID(), 'calfin_metabox', true)) {
    $calfin_commonMeta = get_post_meta( get_the_ID(), 'calfin_metabox', true );
} else {
    $calfin_commonMeta = array();
}
if(array_key_exists('calfin_meta_page_navbar', $calfin_commonMeta)){
	$calfin_meta_page_navbar = $calfin_commonMeta['calfin_meta_page_navbar'];
}else{
	$calfin_meta_page_navbar = '';
}
if(array_key_exists('calfin_layout_meta', $calfin_commonMeta)){
    $calfin_pageLayout = $calfin_commonMeta['calfin_layout_meta'];
}else{
    $calfin_pageLayout = 'full-width';
}

if(array_key_exists('calfin_sidebar_meta', $calfin_commonMeta)){
    $calfin_selectedSidebar = $calfin_commonMeta['calfin_sidebar_meta'];
}else{
    $calfin_selectedSidebar = 'sidebar';
}

if($calfin_pageLayout == 'left-sidebar' && is_active_sidebar($calfin_selectedSidebar) || $calfin_pageLayout == 'right-sidebar' && is_active_sidebar($calfin_selectedSidebar)){
    $calfin_pageColumnClass = 'col-12 col-sm-12 col-md-12 col-lg-7 col-xl-8';
}else{
    $calfin_pageColumnClass = 'col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12';
}
if(array_key_exists('calfin_meta_enable_banner', $calfin_commonMeta)){
    $calfin_postBanner = $calfin_commonMeta['calfin_meta_enable_banner'];
}else{
    $calfin_postBanner = true;
}
$calfin_enable_page_cmt = calfin_options('calfin_enable_page_cmt', true );

if($calfin_pageLayout == 'full-width'){
	$calfin_sidebar_bg = 'sidebar-no-bg-main';
}else{
	$calfin_sidebar_bg = 'sidebar-bg-main';
}
$calfin_breadcrumb_select_html = calfin_options('calfin_breadcrumb_select_html', 'h2');
?>
<?php if($calfin_postBanner == true ) : ?>
	<div class="breadcroumb-area">
		<div class="container">
			<div class="breadcroumn-contnt">
			<<?php echo esc_attr($calfin_breadcrumb_select_html); ?> class="brea-title"> <?php the_title(); ?> </<?php echo esc_attr($calfin_breadcrumb_select_html); ?>>
				<div class="bre-sub">
				<?php if(function_exists('bcn_display')){
					bcn_display();
				}?>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>
	<main id="primary" class="site-main content-area <?php echo esc_attr($calfin_sidebar_bg); ?>">
		<div class="container <?php echo esc_attr($calfin_pageLayout); ?>">
			<div class="page-layout">
				<div class="row">
					<?php
					if($calfin_pageLayout == 'left-sidebar' && is_active_sidebar($calfin_selectedSidebar)){
						get_sidebar();
					}
					?>
					<div class="<?php echo esc_attr($calfin_pageColumnClass); ?>">
						<div class="all-posts-wrapper">
						<?php
							while ( have_posts() ) :
								the_post();
								get_template_part( 'template-parts/content', 'page' );
							endwhile; // End of the loop.
							if( $calfin_enable_page_cmt == true) :
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
							endif;
						?>
						</div>
					</div>
					<?php
					if($calfin_pageLayout == 'right-sidebar' && is_active_sidebar($calfin_selectedSidebar)){
						get_sidebar();
					}?>
				</div>
			
			</div>
		</div>
	</main><!-- #main -->
<?php get_footer();
