<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package calfin
 */

get_header();
$calfin_searchLayout = calfin_options('calfin_search_layout', 'right-sidebar');
$calfin_search_banner = calfin_options('calfin_search_banner', true);
$calfin_search_pagination = calfin_options('calfin_search_pagination', true);
$calfin_breadcrumb_select_html = calfin_options('calfin_breadcrumb_select_html', 'h2');
if($calfin_searchLayout == 'grid'){
	$calfin_sidebar_bg = 'sidebar-no-bg-main';
}else{
	$calfin_sidebar_bg = 'sidebar-bg-main';
}
?>
	<?php if($calfin_search_banner == true ) : ?>
	<div class="breadcroumb-area">
		<div class="container">
			<div class="breadcroumn-contnt">
			<<?php echo esc_attr($calfin_breadcrumb_select_html); ?> class="brea-title">
					<?php 
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'calfin' ), '<span>' . get_search_query() . '</span>' );
					?>
				</<?php echo esc_attr($calfin_breadcrumb_select_html); ?>>
				<div class="bre-sub">
				<?php if(function_exists('bcn_display')){
					bcn_display();
				}?>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>
	<main id="primary" class="site-main content-area sidebar-bg-main <?php echo esc_attr($calfin_sidebar_bg); ?>">
		<div class="container page-layout <?php echo esc_attr($calfin_searchLayout); ?>">
			<?php
				if ( $calfin_searchLayout == 'grid' ) {
					get_template_part( 'template-parts/blog/post-grid' );
				} else {
					get_template_part( 'template-parts/blog/post-sidebar' );
				}?>
				
		</div>
	</main><!-- #main -->
<?php get_footer();
