<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package calfin
 */
if(is_page() || is_singular('post') || is_singular('calfin_portfolio') || is_singular('calfin_team') && get_post_meta($post->ID, 'calfin_metabox', true)) {
    $calfin_commonMeta = get_post_meta($post->ID, 'calfin_metabox', true);
} else {
    $calfin_commonMeta = array();
}


if(is_array($calfin_commonMeta) && array_key_exists('calfin_sidebar_meta', $calfin_commonMeta)){
    $calfin_selectedSidebar = $calfin_commonMeta['calfin_sidebar_meta'];
}else{
    $calfin_selectedSidebar = 'sidebar';
}
?>
<div id="secondary" class="col-xl-4 col-lg-5 col-md-12 col-sm-12 col-12 sidebar-widget-area sidebar-bg">
    <div class="sidebar-sticky-area">
    <?php
        if( is_active_sidebar($calfin_selectedSidebar) ) {
            dynamic_sidebar($calfin_selectedSidebar);
        }
    ?>
    </div>
</div>
