<?php
/**
 * The template for displaying all portfolio single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package calfin
 */

get_header();
if ( get_post_meta( get_the_ID(), 'calfin_metabox', true ) ) {
    $calfin_commonMeta = get_post_meta( get_the_ID(), 'calfin_metabox', true );
} else {
    $calfin_commonMeta = array();
}
$calfin_portfolio_nav = calfin_options( 'calfin_portfolio_nav', true );
$calfin_portfolio_related = calfin_options( 'calfin_portfolio_related', true );
$calfin_portfolio_related_title = calfin_options( 'calfin_portfolio_related_title' );
$calfin_portfolio_banner_enable = calfin_options( 'calfin_portfolio_banner_enable' );
$calfin_breadcrumb_select_html = calfin_options( 'calfin_breadcrumb_select_html', 'h2' );
if ( array_key_exists( 'calfin_layout_meta', $calfin_commonMeta ) && !empty( $calfin_commonMeta['calfin_layout_meta'] ) ) {
    $calfin_portfolio_Layout = $calfin_commonMeta['calfin_layout_meta'];
} else {
    $calfin_portfolio_Layout = 'full-width';
}
if ( is_array( $calfin_commonMeta ) && array_key_exists( 'calfin_sidebar_meta', $calfin_commonMeta ) ) {
    $calfin_selectedSidebar = $calfin_commonMeta['calfin_sidebar_meta'];
} else {
    $calfin_selectedSidebar = 'sidebar';
}

if ( $calfin_portfolio_Layout == 'left-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) || $calfin_portfolio_Layout == 'right-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) ) {
    $calfin_portfolioColumnClass = 'col-12 col-sm-12 col-md-12 col-lg-7 col-xl-8';
} else {
    $calfin_portfolioColumnClass = 'col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12';
}

if ( $calfin_portfolio_banner_enable == false ) {
    $calfin_portfolio_post_Banner = false;
} elseif ( array_key_exists( 'calfin_meta_enable_banner', $calfin_commonMeta ) ) {
    $calfin_portfolio_post_Banner = $calfin_commonMeta['calfin_meta_enable_banner'];
} else {
    $calfin_portfolio_post_Banner = true;
}

?>
	<?php if ( $calfin_portfolio_post_Banner == true ): ?>
	<div class="breadcroumb-area">
		<div class="container">
			<div class="breadcroumn-contnt">
			<<?php echo esc_attr( $calfin_breadcrumb_select_html ); ?> class="brea-title"> <?php the_title();?> </<?php echo esc_attr( $calfin_breadcrumb_select_html ); ?>>
				<div class="bre-sub">
					<?php if ( function_exists( 'bcn_display' ) ) {
						bcn_display();
					}?>
				</div>
			</div>
		</div>
	</div>
	<?php endif;?>
	<main id="primary" class="site-main content-area single-project-wrapper">
		<div class="container">
			<div class="page-layout <?php echo esc_attr( $calfin_portfolio_Layout ); ?>">
				<div class="row">
					<?php
						if ( $calfin_portfolio_Layout == 'left-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) ) {
							get_sidebar();
						}
						?>
					<div class="<?php echo esc_attr( $calfin_portfolioColumnClass ); ?>">
						<div class="all-posts-wrapper">
						    <?php
    							while ( have_posts() ):
    								the_post();
    								the_content();
    							endwhile; // End of the loop.
							?>
							<div class="calfin-project-tag-social-wrapper">
							    <div class="calfin-tags-social-box d-flex">
                                    <?php $calfin_project_tags = get_the_terms( get_the_ID(), 'calfin_project_tag' );
									if ( $calfin_project_tags && !is_wp_error( $calfin_project_tags ) && '1' == calfin_options( 'calfin_portfolio_tag' ) ): ?>
                                        <div class="calfin-project-cats-box flex-grow-1">
                                            <ul>
                                            <?php
    											foreach ( $calfin_project_tags as $calfin_project_tag ) {
    												echo '<li><a href="' . esc_url( get_term_link( $calfin_project_tag->slug, 'calfin_project_tag' ) ) . '">' . esc_html( $calfin_project_tag->name ) . '</a></li>';
    											}?>
                                            </ul>
                                        </div>
                                    <?php endif;?>
                                    <?php if( '1' == calfin_options( 'calfin_portfolio_social' ) ) : ?>
                                        <div class="post-share">
                                            <label><?php esc_html_e('Share','calfin'); ?></label>
                                            <?php if(function_exists('calfin_post_share')){
                                                calfin_post_share();
                                            } ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
							</div>
						</div>
					</div>
					<?php
					if ( $calfin_portfolio_Layout == 'right-sidebar' && is_active_sidebar( $calfin_selectedSidebar ) ) {
						get_sidebar();
					}?>
				</div>
			</div>
		</div>
	</main><!-- #main -->
<?php
get_footer();